/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.pain;

import de.mrjulsen.crn.data.TrainCategory;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class CreateTrainCategoryPacketData {
    private static final String NBT_DATA = "Data";
    private static final String NBT_NAME = "Name";

    public static Response handle(Request packet, NetworkPacketContext context) {
        if (!GlobalSettings.modificationsAllowed(context.getPlayer())) {
            return new Response(Optional.empty());
        }
        TrainCategory category = GlobalSettings.getInstance().createOrGetTrainCategory(packet.name, new Owner(context.getPlayer()));
        return new Response(Optional.ofNullable(category));
    }

    public static class Response
    extends NetworkPacketData {
        private Optional<TrainCategory> category;

        public Response(DLStatus status) {
            super(status);
        }

        public Response(Optional<TrainCategory> category) {
            super(DLStatus.OK);
            this.category = category;
        }

        protected void write(CompoundTag nbt) {
            this.category.ifPresent(x -> nbt.m_128365_(CreateTrainCategoryPacketData.NBT_DATA, (Tag)x.toNbt()));
        }

        protected void read(CompoundTag nbt) {
            this.category = nbt.m_128441_(CreateTrainCategoryPacketData.NBT_DATA) ? Optional.ofNullable(TrainCategory.fromNbt(nbt.m_128469_(CreateTrainCategoryPacketData.NBT_DATA))) : Optional.empty();
        }

        public Optional<TrainCategory> getCategory() {
            return this.category;
        }
    }

    public static class Request
    extends NetworkPacketData {
        private String name;

        public Request(DLStatus status) {
            super(status);
        }

        public Request(String name) {
            super(DLStatus.OK);
            this.name = name;
        }

        protected void write(CompoundTag nbt) {
            nbt.m_128359_(CreateTrainCategoryPacketData.NBT_NAME, this.name);
        }

        protected void read(CompoundTag nbt) {
            this.name = nbt.m_128461_(CreateTrainCategoryPacketData.NBT_NAME);
        }
    }
}

