/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.pain;

import de.mrjulsen.crn.data.TrainLine;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class CreateTrainLinePacketData {
    private static final String NBT_DATA = "Data";

    public static Response handle(Request packet, NetworkPacketContext context) {
        if (!GlobalSettings.modificationsAllowed(context.getPlayer())) {
            return new Response(Optional.empty());
        }
        return new Response(Optional.ofNullable(GlobalSettings.getInstance().createOrGetTrainLine(packet.name, new Owner(context.getPlayer()))));
    }

    public static class Response
    extends NetworkPacketData {
        private Optional<TrainLine> line;

        public Response(DLStatus status) {
            super(status);
        }

        public Response(Optional<TrainLine> line) {
            super(DLStatus.OK);
            this.line = line;
        }

        protected void write(CompoundTag nbt) {
            this.line.ifPresent(x -> nbt.m_128365_(CreateTrainLinePacketData.NBT_DATA, (Tag)x.toNbt()));
        }

        protected void read(CompoundTag nbt) {
            this.line = nbt.m_128441_(CreateTrainLinePacketData.NBT_DATA) ? Optional.ofNullable(TrainLine.fromNbt(nbt.m_128469_(CreateTrainLinePacketData.NBT_DATA))) : Optional.empty();
        }

        public Optional<TrainLine> getLine() {
            return this.line;
        }
    }

    public static class Request
    extends NetworkPacketData {
        private String name;

        public Request(DLStatus status) {
            super(status);
        }

        public Request(String name) {
            super(DLStatus.OK);
            this.name = name;
        }

        protected void write(CompoundTag nbt) {
            nbt.m_128359_(CreateTrainLinePacketData.NBT_DATA, this.name);
        }

        protected void read(CompoundTag nbt) {
            this.name = nbt.m_128461_(CreateTrainLinePacketData.NBT_DATA);
        }
    }
}

