/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.pain;

import com.simibubi.create.content.trains.entity.Train;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.TagName;
import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.Route;
import de.mrjulsen.crn.data.navigation.RoutePart;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.ScheduleSection;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import de.mrjulsen.mcdragonlib.util.Pair;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class GetDepartureAndArrivalRoutesAtPacketData {
    private static final String NBT_STATION_TAG_NAME = "StationTagName";
    private static final String NBT_ID = "Id";
    private static final String NBT_DATA = "Data";
    private static final String NBT_IS_ARRIVAL = "IsArrival";

    public static Response handle(Request packet, NetworkPacketContext context) {
        try {
            UserSettings settings = UserSettings.getSettingsFor(packet.playerId, true);
            StationTag station = GlobalSettings.getInstance().getOrCreateStationTagFor(TagName.of(packet.stationTagName));
            Set<Train> trains = TrainUtils.getDepartingTrainsAt(station);
            trains.removeIf(x -> !TrainUtils.isTrainUsable(x) || GlobalSettings.getInstance().isTrainBlacklisted((Train)x) || !TrainListener.hasTrainData(x));
            LinkedList<Pair<Boolean, Route>> routesL = new LinkedList<Pair<Boolean, Route>>();
            for (Train train : trains) {
                TrainData data = TrainListener.getTrainData(train.id).get();
                List<TrainPrediction> matchingPredictions = data.getPredictionsChronologically();
                for (int i = 0; i < matchingPredictions.size(); ++i) {
                    ScheduleSection section;
                    TrainPrediction prediction = matchingPredictions.get(i);
                    if (!prediction.getStationTag().equals(station) || !(section = prediction.getSection()).isUsable() && (!section.isFirstStop(prediction) || !section.previousSection().isUsable() || !section.previousSection().shouldIncludeNextStationOfNextSection()) || section.getTrainCategory().map(x -> settings.searchExcludedTrainCaegories.getValue().contains(x.getId())).orElse(false).booleanValue()) continue;
                    ScheduleSection previousSection = section.previousSection();
                    boolean isStart = section.isFirstStop(prediction);
                    boolean isLast = section.isFinalStop(prediction);
                    boolean isStartAndFinal = isStart && previousSection.isUsable() && previousSection.shouldIncludeNextStationOfNextSection() && previousSection.getTrainCategory().map(x -> !settings.searchExcludedTrainCaegories.getValue().contains(x.getId())).orElse(true) != false;
                    TrainStop stop = new TrainStop(prediction);
                    stop.simulateTicks(settings.searchDepartureInTicks.getValue().intValue());
                    TrainPrediction fromPrediction = section.getFirstStop().get();
                    TrainStop from = new TrainStop(fromPrediction);
                    Route route = new Route(List.of(new RoutePart(data.getSessionId(), train.id, List.of(stop, from), section.getAllStops(settings.searchDepartureInTicks.getValue().intValue(), prediction.getEntryIndex()))), false);
                    if ((!isStart || isStartAndFinal) && section.getTrainCategory().map(x -> !settings.searchExcludedTrainCaegories.getValue().contains(x.getId())).orElse(true).booleanValue()) {
                        Route selectedRoute = route;
                        if (isStartAndFinal) {
                            TrainPrediction frPred = previousSection.getFirstStop().get();
                            TrainStop fr = new TrainStop(frPred);
                            selectedRoute = new Route(List.of(new RoutePart(data.getSessionId(), train.id, List.of(stop, fr), previousSection.getAllStops(settings.searchDepartureInTicks.getValue().intValue(), prediction.getEntryIndex()))), false);
                        }
                        routesL.add((Pair<Boolean, Route>)Pair.of((Object)true, (Object)selectedRoute));
                    }
                    if (!section.isUsable() || isLast && !section.shouldIncludeNextStationOfNextSection() || !section.getTrainCategory().map(x -> !settings.searchExcludedTrainCaegories.getValue().contains(x.getId())).orElse(true).booleanValue()) continue;
                    routesL.add((Pair<Boolean, Route>)Pair.of((Object)false, (Object)route));
                }
            }
            Collections.sort(routesL, (a, b) -> {
                long val1 = (Boolean)a.getFirst() != false ? ((Route)a.getSecond()).getStart().getScheduledArrivalTime() : ((Route)a.getSecond()).getStart().getScheduledDepartureTime();
                long val2 = (Boolean)b.getFirst() != false ? ((Route)b.getSecond()).getStart().getScheduledArrivalTime() : ((Route)b.getSecond()).getStart().getScheduledDepartureTime();
                return Long.compare(val1, val2);
            });
            return new Response(routesL);
        }
        catch (Exception e) {
            CreateRailwaysNavigator.LOGGER.error("Schedule board generation error.", (Throwable)e);
            return new Response(List.of());
        }
    }

    public static class Request
    extends NetworkPacketData {
        private String stationTagName;
        private UUID playerId;

        public Request(DLStatus status) {
            super(status);
        }

        public Request(String stationTagName, UUID playerId) {
            super(DLStatus.OK);
            this.stationTagName = stationTagName;
            this.playerId = playerId;
        }

        protected void write(CompoundTag nbt) {
            nbt.m_128359_(GetDepartureAndArrivalRoutesAtPacketData.NBT_STATION_TAG_NAME, this.stationTagName);
            nbt.m_128362_(GetDepartureAndArrivalRoutesAtPacketData.NBT_ID, this.playerId);
        }

        protected void read(CompoundTag nbt) {
            this.stationTagName = nbt.m_128461_(GetDepartureAndArrivalRoutesAtPacketData.NBT_STATION_TAG_NAME);
            this.playerId = nbt.m_128342_(GetDepartureAndArrivalRoutesAtPacketData.NBT_ID);
        }
    }

    public static class Response
    extends NetworkPacketData {
        private List<Pair<Boolean, Route>> rawData;
        private List<Pair<Boolean, ClientRoute>> data;

        public Response(DLStatus status) {
            super(status);
        }

        public Response(List<Pair<Boolean, Route>> rawData) {
            super(DLStatus.OK);
            this.rawData = rawData;
        }

        protected void write(CompoundTag nbt) {
            ListTag list = new ListTag();
            for (Pair<Boolean, Route> pair : this.rawData) {
                CompoundTag sub = new CompoundTag();
                sub.m_128379_(GetDepartureAndArrivalRoutesAtPacketData.NBT_IS_ARRIVAL, ((Boolean)pair.getFirst()).booleanValue());
                sub.m_128365_(GetDepartureAndArrivalRoutesAtPacketData.NBT_DATA, (Tag)((Route)pair.getSecond()).toNbt());
                list.add((Object)sub);
            }
            nbt.m_128365_(GetDepartureAndArrivalRoutesAtPacketData.NBT_DATA, (Tag)list);
        }

        protected void read(CompoundTag nbt) {
            this.data = nbt.m_128437_(GetDepartureAndArrivalRoutesAtPacketData.NBT_DATA, 10).stream().map(x -> {
                CompoundTag tag = (CompoundTag)x;
                return new Pair((Object)tag.m_128471_(GetDepartureAndArrivalRoutesAtPacketData.NBT_IS_ARRIVAL), (Object)ClientRoute.fromNbt(tag.m_128469_(GetDepartureAndArrivalRoutesAtPacketData.NBT_DATA), false));
            }).toList();
        }

        public List<Pair<Boolean, ClientRoute>> getData() {
            return this.data;
        }
    }
}

