/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.pain;

import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.ClientTrainStop;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class GetDeparturesAtPacketData {
    private static final String NBT_STATION_TAG_ID = "StationTagId";
    private static final String NBT_TRAIN_ID = "TrainId";
    private static final String NBT_REAL_TIME_ONLY = "RealTimeOnly";
    private static final String NBT_DATA = "Data";

    public static Response handle(Request packet, NetworkPacketContext context) {
        try {
            if (!GlobalSettings.getInstance().stationTagExists(packet.stationTagId)) {
                return new Response(List.of());
            }
            StationTag tag = GlobalSettings.getInstance().getStationTag(packet.stationTagId).get();
            return new Response(TrainUtils.getDeparturesAt(tag, packet.trainId, packet.realTimeOnly));
        }
        catch (Exception e) {
            CreateRailwaysNavigator.LOGGER.error("Next connections error.", (Throwable)e);
            return new Response(List.of());
        }
    }

    public static class Request
    extends NetworkPacketData {
        private UUID stationTagId;
        private UUID trainId;
        private boolean realTimeOnly;

        public Request(DLStatus status) {
            super(status);
        }

        public Request(UUID stationTagId, UUID trainId, boolean realTimeOnly) {
            super(DLStatus.OK);
            this.stationTagId = stationTagId;
            this.trainId = trainId;
            this.realTimeOnly = realTimeOnly;
        }

        protected void write(CompoundTag nbt) {
            nbt.m_128362_(GetDeparturesAtPacketData.NBT_STATION_TAG_ID, this.stationTagId);
            nbt.m_128362_(GetDeparturesAtPacketData.NBT_TRAIN_ID, this.trainId);
            nbt.m_128379_(GetDeparturesAtPacketData.NBT_REAL_TIME_ONLY, this.realTimeOnly);
        }

        protected void read(CompoundTag nbt) {
            this.stationTagId = nbt.m_128342_(GetDeparturesAtPacketData.NBT_STATION_TAG_ID);
            this.trainId = nbt.m_128342_(GetDeparturesAtPacketData.NBT_TRAIN_ID);
            this.realTimeOnly = nbt.m_128471_(GetDeparturesAtPacketData.NBT_REAL_TIME_ONLY);
        }
    }

    public static class Response
    extends NetworkPacketData {
        private List<TrainStop> rawData;
        private List<ClientTrainStop> data;

        public Response(DLStatus status) {
            super(status);
        }

        public Response(List<TrainStop> rawData) {
            super(DLStatus.OK);
            this.rawData = rawData;
        }

        protected void write(CompoundTag nbt) {
            ListTag list = new ListTag();
            for (TrainStop data : this.rawData) {
                list.add((Object)data.toNbt(true));
            }
            nbt.m_128365_(GetDeparturesAtPacketData.NBT_DATA, (Tag)list);
        }

        protected void read(CompoundTag nbt) {
            this.data = nbt.m_128437_(GetDeparturesAtPacketData.NBT_DATA, 10).stream().map(x -> (ClientTrainStop)ClientTrainStop.fromNbt((CompoundTag)x)).toList();
        }

        public List<ClientTrainStop> getData() {
            return this.data;
        }
    }
}

