/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.pain;

import de.mrjulsen.crn.data.train.DepartureHistory;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class GetStationDepartureHistoryPacketData {
    private static final String NBT_DATA = "Data";
    private static final String NBT_NAME = "Name";

    public static Response handle(Request packet, NetworkPacketContext context) {
        return new Response(DepartureHistory.Stats.ofStation(packet.name));
    }

    public static class Response
    extends NetworkPacketData {
        private DepartureHistory.Stats history;

        public Response(DLStatus status) {
            super(status);
        }

        public Response(DepartureHistory.Stats history) {
            super(DLStatus.OK);
            this.history = history;
        }

        protected void write(CompoundTag nbt) {
            nbt.m_128365_(GetStationDepartureHistoryPacketData.NBT_DATA, (Tag)this.history.toNbt());
        }

        protected void read(CompoundTag nbt) {
            this.history = DepartureHistory.Stats.fromNbt(nbt.m_128469_(GetStationDepartureHistoryPacketData.NBT_DATA));
        }

        public DepartureHistory.Stats getHistory() {
            return this.history;
        }
    }

    public static class Request
    extends NetworkPacketData {
        private String name;

        public Request(DLStatus status) {
            super(status);
        }

        public Request(String name) {
            super(DLStatus.OK);
            this.name = name;
        }

        protected void write(CompoundTag nbt) {
            nbt.m_128359_(GetStationDepartureHistoryPacketData.NBT_NAME, this.name);
        }

        protected void read(CompoundTag nbt) {
            this.name = nbt.m_128461_(GetStationDepartureHistoryPacketData.NBT_NAME);
        }
    }
}

