/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.pain;

import de.mrjulsen.crn.data.TrainCategory;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class GetTrainCategoryPacketData {
    private static final String NBT_DATA = "Data";
    private static final String NBT_ID = "Id";

    public static Response handle(Request packet, NetworkPacketContext context) {
        return new Response(GlobalSettings.getInstance().getTrainCategory(packet.id));
    }

    public static class Response
    extends NetworkPacketData {
        private Optional<TrainCategory> category;

        public Response(DLStatus status) {
            super(status);
        }

        public Response(Optional<TrainCategory> category) {
            super(DLStatus.OK);
            this.category = category;
        }

        protected void write(CompoundTag nbt) {
            this.category.ifPresent(x -> nbt.m_128365_(GetTrainCategoryPacketData.NBT_DATA, (Tag)x.toNbt()));
        }

        protected void read(CompoundTag nbt) {
            this.category = nbt.m_128441_(GetTrainCategoryPacketData.NBT_DATA) ? Optional.ofNullable(TrainCategory.fromNbt(nbt.m_128469_(GetTrainCategoryPacketData.NBT_DATA))) : Optional.empty();
        }

        public Optional<TrainCategory> getCategory() {
            return this.category;
        }
    }

    public static class Request
    extends NetworkPacketData {
        private UUID id;

        public Request(DLStatus status) {
            super(status);
        }

        public Request(UUID id) {
            super(DLStatus.OK);
            this.id = id;
        }

        protected void write(CompoundTag nbt) {
            nbt.m_128362_(GetTrainCategoryPacketData.NBT_ID, this.id);
        }

        protected void read(CompoundTag nbt) {
            this.id = nbt.m_128342_(GetTrainCategoryPacketData.NBT_ID);
        }
    }
}

