/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.pain;

import de.mrjulsen.crn.data.TrainLine;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class GetTrainLinePacketData {
    private static final String NBT_DATA = "Data";
    private static final String NBT_ID = "Id";

    public static Response handle(Request packet, NetworkPacketContext context) {
        return new Response(GlobalSettings.getInstance().getTrainLine(packet.id));
    }

    public static class Response
    extends NetworkPacketData {
        private Optional<TrainLine> line;

        public Response(DLStatus status) {
            super(status);
        }

        public Response(Optional<TrainLine> line) {
            super(DLStatus.OK);
            this.line = line;
        }

        protected void write(CompoundTag nbt) {
            this.line.ifPresent(x -> nbt.m_128365_(GetTrainLinePacketData.NBT_DATA, (Tag)x.toNbt()));
        }

        protected void read(CompoundTag nbt) {
            this.line = nbt.m_128441_(GetTrainLinePacketData.NBT_DATA) ? Optional.ofNullable(TrainLine.fromNbt(nbt.m_128469_(GetTrainLinePacketData.NBT_DATA))) : Optional.empty();
        }

        public Optional<TrainLine> getLine() {
            return this.line;
        }
    }

    public static class Request
    extends NetworkPacketData {
        private UUID id;

        public Request(DLStatus status) {
            super(status);
        }

        public Request(UUID id) {
            super(DLStatus.OK);
            this.id = id;
        }

        protected void write(CompoundTag nbt) {
            nbt.m_128362_(GetTrainLinePacketData.NBT_ID, this.id);
        }

        protected void read(CompoundTag nbt) {
            this.id = nbt.m_128342_(GetTrainLinePacketData.NBT_ID);
        }
    }
}

