/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.pain;

import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.data.TagName;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.NavigableGraph;
import de.mrjulsen.crn.data.navigation.Route;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class NavigatePacketData {
    private static final String NBT_START = "Start";
    private static final String NBT_END = "End";
    private static final String NBT_ID = "Id";
    private static final String NBT_DATA = "Data";

    public static Response handle(Request packet, NetworkPacketContext context) {
        try {
            GlobalSettings settings = GlobalSettings.getInstance();
            List<Route> routes = NavigableGraph.searchRoutes(settings.getTagByName(TagName.of(packet.start)).orElse(settings.getOrCreateStationTagFor(packet.start)), settings.getTagByName(TagName.of(packet.end)).orElse(settings.getOrCreateStationTagFor(packet.end)), packet.playerId, true);
            return new Response(routes);
        }
        catch (Exception e) {
            CreateRailwaysNavigator.LOGGER.error("Navigation error.", (Throwable)e);
            return new Response(List.of());
        }
    }

    public static class Request
    extends NetworkPacketData {
        private String start;
        private String end;
        private UUID playerId;

        public Request(DLStatus status) {
            super(status);
        }

        public Request(String start, String end, UUID playerId) {
            super(DLStatus.OK);
            this.start = start;
            this.end = end;
            this.playerId = playerId;
        }

        protected void write(CompoundTag nbt) {
            nbt.m_128359_(NavigatePacketData.NBT_START, this.start);
            nbt.m_128359_(NavigatePacketData.NBT_END, this.end);
            nbt.m_128362_(NavigatePacketData.NBT_ID, this.playerId);
        }

        protected void read(CompoundTag nbt) {
            this.start = nbt.m_128461_(NavigatePacketData.NBT_START);
            this.end = nbt.m_128461_(NavigatePacketData.NBT_END);
            this.playerId = nbt.m_128342_(NavigatePacketData.NBT_ID);
        }
    }

    public static class Response
    extends NetworkPacketData {
        private List<Route> rawData;
        private List<ClientRoute> data;

        public Response(DLStatus status) {
            super(status);
        }

        public Response(List<Route> rawData) {
            super(DLStatus.OK);
            this.rawData = rawData;
        }

        protected void write(CompoundTag nbt) {
            ListTag list = new ListTag();
            for (Route route : this.rawData) {
                list.add((Object)route.toNbt());
            }
            nbt.m_128365_(NavigatePacketData.NBT_DATA, (Tag)list);
        }

        protected void read(CompoundTag nbt) {
            this.data = nbt.m_128437_(NavigatePacketData.NBT_DATA, 10).stream().map(x -> ClientRoute.fromNbt((CompoundTag)x, true)).toList();
        }

        public List<ClientRoute> getData() {
            return this.data;
        }
    }
}

