/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.pain;

import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class RemoveStationTagEntryPacketData {
    private static final String NBT_DATA = "Data";
    private static final String NBT_ID = "Id";
    private static final String NBT_STATION = "Station";

    public static Response handle(Request packet, NetworkPacketContext context) {
        return new Response(Optional.ofNullable(GlobalSettings.getInstance().getStationTag(packet.tagId).map(x -> {
            if (!x.getOwner().isAllowed(new Owner(context.getPlayer())) || !GlobalSettings.modificationsAllowed(context.getPlayer())) {
                return null;
            }
            x.remove(packet.station);
            x.updateLastEdited(context.getPlayer());
            return x;
        })).orElse(null));
    }

    public static class Response
    extends NetworkPacketData {
        private Optional<StationTag> tag;

        public Response(DLStatus status) {
            super(status);
        }

        public Response(Optional<StationTag> tag) {
            super(DLStatus.OK);
            this.tag = tag;
        }

        protected void write(CompoundTag nbt) {
            this.tag.ifPresent(x -> nbt.m_128365_(RemoveStationTagEntryPacketData.NBT_DATA, (Tag)x.toNbt()));
        }

        protected void read(CompoundTag nbt) {
            this.tag = nbt.m_128441_(RemoveStationTagEntryPacketData.NBT_DATA) ? Optional.ofNullable(StationTag.fromNbt(nbt.m_128469_(RemoveStationTagEntryPacketData.NBT_DATA), null)) : Optional.empty();
        }

        public Optional<StationTag> getTag() {
            return this.tag;
        }
    }

    public static class Request
    extends NetworkPacketData {
        private UUID tagId;
        private String station;

        public Request(DLStatus status) {
            super(status);
        }

        public Request(UUID tagId, String station) {
            super(DLStatus.OK);
            this.tagId = tagId;
            this.station = station;
        }

        protected void write(CompoundTag nbt) {
            nbt.m_128362_(RemoveStationTagEntryPacketData.NBT_ID, this.tagId);
            nbt.m_128359_(RemoveStationTagEntryPacketData.NBT_STATION, this.station);
        }

        protected void read(CompoundTag nbt) {
            this.tagId = nbt.m_128342_(RemoveStationTagEntryPacketData.NBT_ID);
            this.station = nbt.m_128461_(RemoveStationTagEntryPacketData.NBT_STATION);
        }
    }
}

