/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.pain;

import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class RemoveTrainFromBlacklistPacketData {
    private static final String NBT_DATA = "Data";

    public static Response handle(Request packet, NetworkPacketContext context) {
        if (!GlobalSettings.modificationsAllowed(context.getPlayer())) {
            return new Response(List.of());
        }
        GlobalSettings.getInstance().removeTrainFromBlacklist(packet.name);
        return new Response((Collection<String>)GlobalSettings.getInstance().getAllBlacklistedTrains());
    }

    public static class Response
    extends NetworkPacketData {
        private Collection<String> names;

        public Response(DLStatus status) {
            super(status);
        }

        public Response(Collection<String> names) {
            super(DLStatus.OK);
            this.names = names;
        }

        protected void write(CompoundTag nbt) {
            ListTag list = new ListTag();
            for (String name : this.names) {
                list.add((Object)StringTag.m_129297_((String)name));
            }
            nbt.m_128365_(RemoveTrainFromBlacklistPacketData.NBT_DATA, (Tag)list);
        }

        protected void read(CompoundTag nbt) {
            this.names = nbt.m_128437_(RemoveTrainFromBlacklistPacketData.NBT_DATA, 8).stream().map(x -> ((StringTag)x).m_7916_()).toList();
        }

        public Collection<String> getNames() {
            return this.names;
        }
    }

    public static class Request
    extends NetworkPacketData {
        private String name;

        public Request(DLStatus status) {
            super(status);
        }

        public Request(String name) {
            super(DLStatus.OK);
            this.name = name;
        }

        protected void write(CompoundTag nbt) {
            nbt.m_128359_(RemoveTrainFromBlacklistPacketData.NBT_DATA, this.name);
        }

        protected void read(CompoundTag nbt) {
            this.name = nbt.m_128461_(RemoveTrainFromBlacklistPacketData.NBT_DATA);
        }
    }
}

