/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.pain;

import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class StationTagRequestPacketData {
    private static final String NBT_DATA = "Data";

    public static Response handle(Request packet, NetworkPacketContext context) {
        return new Response(GlobalSettings.getInstance().getOrCreateStationTagFor(packet.name));
    }

    public static class Response
    extends NetworkPacketData {
        private StationTag tag;

        public Response(DLStatus status) {
            super(status);
        }

        public Response(StationTag tag) {
            super(DLStatus.OK);
            this.tag = tag;
        }

        protected void write(CompoundTag nbt) {
            nbt.m_128365_(StationTagRequestPacketData.NBT_DATA, (Tag)this.tag.toNbt());
        }

        protected void read(CompoundTag nbt) {
            this.tag = StationTag.fromNbt(nbt.m_128469_(StationTagRequestPacketData.NBT_DATA), null);
        }

        public StationTag getTag() {
            return this.tag;
        }
    }

    public static class Request
    extends NetworkPacketData {
        private String name;

        public Request(DLStatus status) {
            super(status);
        }

        public Request(String name) {
            super(DLStatus.OK);
            this.name = name;
        }

        protected void write(CompoundTag nbt) {
            nbt.m_128359_(StationTagRequestPacketData.NBT_DATA, this.name);
        }

        protected void read(CompoundTag nbt) {
            this.name = nbt.m_128461_(StationTagRequestPacketData.NBT_DATA);
        }
    }
}

