/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.pain;

import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.util.Lock;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class StationTagUpdatePermissionsPacketData {
    private static final String NBT_DATA = "Data";
    private static final String NBT_ID = "Id";
    private static final String NBT_STATE = "State";
    private static final String NBT_NEW_OWNER = "NewOwner";
    private static final String NBT_TRUSTED = "Trusted";

    public static Response handle(Request packet, NetworkPacketContext context) {
        return new Response(Optional.ofNullable(GlobalSettings.getInstance().getStationTag(packet.id).map(tag -> {
            if (!tag.getOwner().isAdmin(new Owner(context.getPlayer())) || !GlobalSettings.modificationsAllowed(context.getPlayer())) {
                return null;
            }
            if (packet.state != null) {
                tag.getOwner().set(packet.state);
            }
            if (packet.trusted != null) {
                tag.getOwner().updateTrusted(packet.trusted);
            }
            if (packet.newOwner != null) {
                tag.getOwner().setOwner(packet.newOwner);
                tag.getOwner().addTrusted(new Owner(context.getPlayer()));
            }
            return tag;
        })).orElse(null));
    }

    public static class Response
    extends NetworkPacketData {
        private Optional<StationTag> tag;

        public Response(DLStatus status) {
            super(status);
        }

        public Response(Optional<StationTag> tag) {
            super(DLStatus.OK);
            this.tag = tag;
        }

        protected void write(CompoundTag nbt) {
            this.tag.ifPresent(x -> nbt.m_128365_(StationTagUpdatePermissionsPacketData.NBT_DATA, (Tag)x.toNbt()));
        }

        protected void read(CompoundTag nbt) {
            this.tag = nbt.m_128441_(StationTagUpdatePermissionsPacketData.NBT_DATA) ? Optional.ofNullable(StationTag.fromNbt(nbt.m_128469_(StationTagUpdatePermissionsPacketData.NBT_DATA), null)) : Optional.empty();
        }

        public Optional<StationTag> getTag() {
            return this.tag;
        }
    }

    public static class Request
    extends NetworkPacketData {
        private UUID id;
        private Owner newOwner;
        private Lock.LockState state;
        private Set<Owner> trusted;

        public Request(DLStatus status) {
            super(status);
        }

        public Request(UUID id, Owner newOwner, Lock.LockState state, Set<Owner> trusted) {
            super(DLStatus.OK);
            this.id = id;
            this.newOwner = newOwner;
            this.state = state;
            this.trusted = trusted;
        }

        protected void write(CompoundTag nbt) {
            nbt.m_128362_(StationTagUpdatePermissionsPacketData.NBT_ID, this.id);
            if (this.state != null) {
                nbt.m_128344_(StationTagUpdatePermissionsPacketData.NBT_STATE, this.state.getIndex());
            }
            if (this.trusted != null) {
                ListTag list = new ListTag();
                for (Owner t : this.trusted) {
                    list.add((Object)t.toNbt());
                }
                nbt.m_128365_(StationTagUpdatePermissionsPacketData.NBT_TRUSTED, (Tag)list);
            }
            if (this.newOwner != null) {
                nbt.m_128365_(StationTagUpdatePermissionsPacketData.NBT_NEW_OWNER, (Tag)this.newOwner.toNbt());
            }
        }

        protected void read(CompoundTag nbt) {
            this.id = nbt.m_128342_(StationTagUpdatePermissionsPacketData.NBT_ID);
            this.newOwner = nbt.m_128441_(StationTagUpdatePermissionsPacketData.NBT_NEW_OWNER) ? Owner.fromNbt(nbt.m_128469_(StationTagUpdatePermissionsPacketData.NBT_NEW_OWNER)) : null;
            this.state = nbt.m_128441_(StationTagUpdatePermissionsPacketData.NBT_STATE) ? Lock.LockState.getByIndex(nbt.m_128445_(StationTagUpdatePermissionsPacketData.NBT_STATE)) : null;
            this.trusted = nbt.m_128441_(StationTagUpdatePermissionsPacketData.NBT_TRUSTED) ? nbt.m_128437_(StationTagUpdatePermissionsPacketData.NBT_TRUSTED, 10).stream().map(x -> Owner.fromNbt((CompoundTag)x)).collect(Collectors.toSet()) : null;
        }
    }
}

