/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.pain;

import de.mrjulsen.crn.data.navigation.ClientRoutePart;
import de.mrjulsen.crn.data.train.ClientTrainStop;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class UpdateRealtimePacketData {
    private static final String NBT_DATA = "Data";

    public static Response handle(Request packet, NetworkPacketContext context) {
        return new Response(Optional.ofNullable(TrainListener.getTrainData(packet.id).map(data -> {
            List<TrainPrediction> predictions = data.getPredictions();
            HashMap<Integer, ClientTrainStop.TrainStopRealTimeData> values = new HashMap<Integer, ClientTrainStop.TrainStopRealTimeData>();
            for (TrainPrediction prediction : predictions) {
                ClientTrainStop.TrainStopRealTimeData realTimeData = new ClientTrainStop.TrainStopRealTimeData(prediction.getStationTag().getClientTag(prediction.getTargetedStationName()), prediction.getEntryIndex(), prediction.scheduled().arrivalTime(), prediction.scheduled().departureTime(), prediction.realTime().arrivalTime(), prediction.realTime().departureTime(), (int)prediction.realTime().arrivalIn(), prediction.getCurrentCycle());
                values.put(realTimeData.entryIndex(), realTimeData);
            }
            return ClientRoutePart.TrainRealTimeData.createServer(data.getSessionId(), values, data.getStatus(), data.isCancelled());
        }).orElse(null)));
    }

    public static class Response
    extends NetworkPacketData {
        private Optional<ClientRoutePart.TrainRealTimeData> data;

        public Response(DLStatus status) {
            super(status);
        }

        public Response(Optional<ClientRoutePart.TrainRealTimeData> data) {
            super(DLStatus.OK);
            this.data = data;
        }

        protected void write(CompoundTag nbt) {
            this.data.ifPresent(x -> nbt.m_128365_(UpdateRealtimePacketData.NBT_DATA, (Tag)x.toNbt()));
        }

        protected void read(CompoundTag nbt) {
            this.data = Optional.ofNullable(nbt.m_128441_(UpdateRealtimePacketData.NBT_DATA) ? ClientRoutePart.TrainRealTimeData.fromNbt(nbt.m_128469_(UpdateRealtimePacketData.NBT_DATA)) : null);
        }

        public Optional<ClientRoutePart.TrainRealTimeData> getData() {
            return this.data;
        }
    }

    public static class Request
    extends NetworkPacketData {
        private UUID id;

        public Request(DLStatus status) {
            super(status);
        }

        public Request(UUID id) {
            super(DLStatus.OK);
            this.id = id;
        }

        protected void write(CompoundTag nbt) {
            nbt.m_128362_(UpdateRealtimePacketData.NBT_DATA, this.id);
        }

        protected void read(CompoundTag nbt) {
            this.id = nbt.m_128342_(UpdateRealtimePacketData.NBT_DATA);
        }
    }
}

