/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.pain;

import de.mrjulsen.crn.data.TrainCategory;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class UpdateTrainCategoryNamePacketData {
    private static final String NBT_DATA = "Data";
    private static final String NBT_ID = "Id";
    private static final String NBT_NAME = "Name";

    public static Response handle(Request packet, NetworkPacketContext context) {
        return new Response(Optional.ofNullable(GlobalSettings.getInstance().getTrainCategory(packet.id).map(x -> {
            if (!x.getOwner().isAllowed(new Owner(context.getPlayer())) || !GlobalSettings.modificationsAllowed(context.getPlayer())) {
                return null;
            }
            x.setName(packet.name);
            return x;
        })).orElse(null));
    }

    public static class Response
    extends NetworkPacketData {
        private Optional<TrainCategory> category;

        public Response(DLStatus status) {
            super(status);
        }

        public Response(Optional<TrainCategory> category) {
            super(DLStatus.OK);
            this.category = category;
        }

        protected void write(CompoundTag nbt) {
            this.category.ifPresent(x -> nbt.m_128365_(UpdateTrainCategoryNamePacketData.NBT_DATA, (Tag)x.toNbt()));
        }

        protected void read(CompoundTag nbt) {
            this.category = nbt.m_128441_(UpdateTrainCategoryNamePacketData.NBT_DATA) ? Optional.ofNullable(TrainCategory.fromNbt(nbt.m_128469_(UpdateTrainCategoryNamePacketData.NBT_DATA))) : Optional.empty();
        }

        public Optional<TrainCategory> getCategory() {
            return this.category;
        }
    }

    public static class Request
    extends NetworkPacketData {
        private UUID id;
        private String name;

        public Request(DLStatus status) {
            super(status);
        }

        public Request(UUID id, String name) {
            super(DLStatus.OK);
            this.id = id;
            this.name = name;
        }

        protected void write(CompoundTag nbt) {
            nbt.m_128362_(UpdateTrainCategoryNamePacketData.NBT_ID, this.id);
            nbt.m_128359_(UpdateTrainCategoryNamePacketData.NBT_NAME, this.name);
        }

        protected void read(CompoundTag nbt) {
            this.id = nbt.m_128342_(UpdateTrainCategoryNamePacketData.NBT_ID);
            this.name = nbt.m_128461_(UpdateTrainCategoryNamePacketData.NBT_NAME);
        }
    }
}

