/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.pain;

import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.network.packets.pain.EmptyNetworkPacketData;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import de.mrjulsen.mcdragonlib.util.DLColor;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;

public class UpdateTrainLineColorPacketData
extends NetworkPacketData {
    private static final String NBT_COLOR = "Color";
    private static final String NBT_ID = "Id";
    private UUID id;
    private int color;

    public UpdateTrainLineColorPacketData(DLStatus status) {
        super(status);
    }

    public UpdateTrainLineColorPacketData(UUID id, DLColor color) {
        super(DLStatus.OK);
        this.id = id;
        this.color = color.getAsARGB();
    }

    protected void write(CompoundTag nbt) {
        nbt.m_128362_(NBT_ID, this.id);
        nbt.m_128405_(NBT_COLOR, this.color);
    }

    protected void read(CompoundTag nbt) {
        this.id = nbt.m_128342_(NBT_ID);
        this.color = nbt.m_128451_(NBT_COLOR);
    }

    public static EmptyNetworkPacketData handle(UpdateTrainLineColorPacketData packet, NetworkPacketContext context) {
        GlobalSettings.getInstance().getTrainLine(packet.id).ifPresent(x -> {
            if (!x.getOwner().isAllowed(new Owner(context.getPlayer())) || !GlobalSettings.modificationsAllowed(context.getPlayer())) {
                return;
            }
            x.setColor(DLColor.fromInt((int)packet.color));
        });
        return new EmptyNetworkPacketData();
    }
}

