/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.pain;

import de.mrjulsen.crn.data.TrainLine;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.util.Lock;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.data.DLStatus;
import de.mrjulsen.mcdragonlib.network.NetworkPacketContext;
import de.mrjulsen.mcdragonlib.network.NetworkPacketData;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class UpdateTrainLinePermissionsPacketData {
    private static final String NBT_DATA = "Data";
    private static final String NBT_ID = "Id";
    private static final String NBT_STATE = "State";
    private static final String NBT_NEW_OWNER = "NewOwner";
    private static final String NBT_TRUSTED = "Trusted";

    public static Response handle(Request packet, NetworkPacketContext context) {
        return new Response(Optional.ofNullable(GlobalSettings.getInstance().getTrainLine(packet.id).map(line -> {
            if (!line.getOwner().isAdmin(new Owner(context.getPlayer())) || !GlobalSettings.modificationsAllowed(context.getPlayer())) {
                return null;
            }
            if (packet.state != null) {
                line.getOwner().set(packet.state);
            }
            if (packet.trusted != null) {
                line.getOwner().updateTrusted(packet.trusted);
            }
            if (packet.newOwner != null) {
                line.getOwner().setOwner(packet.newOwner);
                line.getOwner().addTrusted(new Owner(context.getPlayer()));
            }
            return line;
        })).orElse(null));
    }

    public static class Response
    extends NetworkPacketData {
        private Optional<TrainLine> line;

        public Response(DLStatus status) {
            super(status);
        }

        public Response(Optional<TrainLine> line) {
            super(DLStatus.OK);
            this.line = line;
        }

        protected void write(CompoundTag nbt) {
            this.line.ifPresent(x -> nbt.m_128365_(UpdateTrainLinePermissionsPacketData.NBT_DATA, (Tag)x.toNbt()));
        }

        protected void read(CompoundTag nbt) {
            this.line = nbt.m_128441_(UpdateTrainLinePermissionsPacketData.NBT_DATA) ? Optional.ofNullable(TrainLine.fromNbt(nbt.m_128469_(UpdateTrainLinePermissionsPacketData.NBT_DATA))) : Optional.empty();
        }

        public Optional<TrainLine> getLine() {
            return this.line;
        }
    }

    public static class Request
    extends NetworkPacketData {
        private UUID id;
        private Owner newOwner;
        private Lock.LockState state;
        private Set<Owner> trusted;

        public Request(DLStatus status) {
            super(status);
        }

        public Request(UUID id, Owner newOwner, Lock.LockState state, Set<Owner> trusted) {
            super(DLStatus.OK);
            this.id = id;
            this.newOwner = newOwner;
            this.state = state;
            this.trusted = trusted;
        }

        protected void write(CompoundTag nbt) {
            nbt.m_128362_(UpdateTrainLinePermissionsPacketData.NBT_ID, this.id);
            if (this.state != null) {
                nbt.m_128344_(UpdateTrainLinePermissionsPacketData.NBT_STATE, this.state.getIndex());
            }
            if (this.trusted != null) {
                ListTag list = new ListTag();
                for (Owner t : this.trusted) {
                    list.add((Object)t.toNbt());
                }
                nbt.m_128365_(UpdateTrainLinePermissionsPacketData.NBT_TRUSTED, (Tag)list);
            }
            if (this.newOwner != null) {
                nbt.m_128365_(UpdateTrainLinePermissionsPacketData.NBT_NEW_OWNER, (Tag)this.newOwner.toNbt());
            }
        }

        protected void read(CompoundTag nbt) {
            this.id = nbt.m_128342_(UpdateTrainLinePermissionsPacketData.NBT_ID);
            this.newOwner = nbt.m_128441_(UpdateTrainLinePermissionsPacketData.NBT_NEW_OWNER) ? Owner.fromNbt(nbt.m_128469_(UpdateTrainLinePermissionsPacketData.NBT_NEW_OWNER)) : null;
            this.state = nbt.m_128441_(UpdateTrainLinePermissionsPacketData.NBT_STATE) ? Lock.LockState.getByIndex(nbt.m_128445_(UpdateTrainLinePermissionsPacketData.NBT_STATE)) : null;
            this.trusted = nbt.m_128441_(UpdateTrainLinePermissionsPacketData.NBT_TRUSTED) ? nbt.m_128437_(UpdateTrainLinePermissionsPacketData.NBT_TRUSTED, 10).stream().map(x -> Owner.fromNbt((CompoundTag)x)).collect(Collectors.toSet()) : null;
        }
    }
}

