/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.util;

import com.google.common.collect.ImmutableMap;
import de.mrjulsen.crn.mixin.TrainPenaltyAccessor;
import de.mrjulsen.mcdragonlib.config.ECachingPriority;
import de.mrjulsen.mcdragonlib.util.Cache;
import de.mrjulsen.mcdragonlib.util.MapCache;
import de.mrjulsen.mcdragonlib.util.Pair;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;

public class PenaltyResult {
    private final Map<Type, Integer> penaltiesByType;
    private final Cache<Integer> penaltySum;

    private PenaltyResult(Map<Type, Integer> penaltiesByType) {
        this.penaltiesByType = penaltiesByType;
        this.penaltySum = new Cache(() -> this.getPenalties().values().stream().mapToInt(x -> x).sum());
    }

    public PenaltyResult() {
        this(new IdentityHashMap<Type, Integer>());
    }

    public PenaltyResult(PenaltyResult other) {
        this(new IdentityHashMap<Type, Integer>(other.penaltiesByType));
    }

    public ImmutableMap<Type, Integer> getPenalties() {
        return ImmutableMap.copyOf(this.penaltiesByType);
    }

    public int getPenaltyValue() {
        return (Integer)this.penaltySum.get();
    }

    public void add(Type type) {
        this.penaltiesByType.merge(type, 1, (prev, val) -> prev + val);
    }

    public static enum Type {
        MANUAL_TRAIN("manual_train", Category.TRAINS, TrainPenaltyAccessor.manualTrain()),
        IDLE_TRAIN("idle_train", Category.TRAINS, TrainPenaltyAccessor.idleTrain()),
        ARRIVING_TRAIN("arriving_train", Category.TRAINS, TrainPenaltyAccessor.arrivingTrain()),
        WAITING_TRAIN("waiting_train", Category.TRAINS, TrainPenaltyAccessor.waitingTrain()),
        ANY_TRAIN("any_train", Category.TRAINS, TrainPenaltyAccessor.anyTrain()),
        RED_SIGNAL("red_signal", Category.ROUTE, TrainPenaltyAccessor.redSignal()),
        REDSTONE_RED_SIGNAL("redstone_red_signal", Category.ROUTE, TrainPenaltyAccessor.redstoneRedSignal());

        private final String name;
        private final Category category;
        private final int penalty;
        private static final MapCache<Type, Pair<Category, Integer>, Pair<Category, Integer>> typeCaches;

        private Type(String name, Category category, int penalty) {
            this.name = name;
            this.category = category;
            this.penalty = penalty;
        }

        public String getName() {
            return this.name;
        }

        public int getPenalty() {
            return this.penalty;
        }

        public Category getCategory() {
            return this.category;
        }

        public static Optional<Type> getTypeByPenalty(Category category, int penalty) {
            Pair p = Pair.of((Object)((Object)category), (Object)penalty);
            return Optional.ofNullable((Type)((Object)typeCaches.get((Object)p, (Object)p)));
        }

        static {
            typeCaches = new MapCache(pair -> {
                Optional<Type> optional = Arrays.stream(Type.values()).filter(x -> (pair.getFirst() == null || x.getCategory() == pair.getFirst()) && x.getPenalty() == ((Integer)pair.getSecond()).intValue()).findFirst();
                return optional.orElse(switch (((Category)((Object)((Object)pair.getFirst()))).ordinal()) {
                    case 0 -> ANY_TRAIN;
                    default -> null;
                });
            }, Pair::hashCode, ECachingPriority.LOW);
        }
    }

    public static enum Category {
        TRAINS,
        ROUTE;

    }
}

