/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.common.content.armorRenderer;

import com.dannbrown.deltaboxlib.common.content.armorRenderer.AbstractArmorModel;
import com.dannbrown.deltaboxlib.common.content.armorRenderer.ArmorModelSupplier;
import com.dannbrown.deltaboxlib.common.registrate.util.DeltaboxUtil;
import java.util.Locale;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\b\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001b\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001cR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u001dR\u0017\u0010\u001f\u001a\u00020\u001e8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u001e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lcom/dannbrown/deltaboxlib/common/content/armorRenderer/ArmorModelProvider;", "", "", "modId", "armorName", "Lnet/minecraft/world/entity/EquipmentSlot;", "slot", "Ljava/util/function/Supplier;", "Lnet/minecraft/client/model/geom/builders/LayerDefinition;", "layerDefinitionSupplier", "Lcom/dannbrown/deltaboxlib/common/content/armorRenderer/ArmorModelSupplier;", "armorModelSupplier", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lnet/minecraft/world/entity/EquipmentSlot;Ljava/util/function/Supplier;Lcom/dannbrown/deltaboxlib/common/content/armorRenderer/ArmorModelSupplier;)V", "Lnet/minecraft/resources/ResourceLocation;", "getTexture", "()Lnet/minecraft/resources/ResourceLocation;", "createLayer", "()Lnet/minecraft/client/model/geom/builders/LayerDefinition;", "Lcom/dannbrown/deltaboxlib/common/content/armorRenderer/AbstractArmorModel;", "Lnet/minecraft/world/entity/LivingEntity;", "createModel", "()Lcom/dannbrown/deltaboxlib/common/content/armorRenderer/AbstractArmorModel;", "Lnet/minecraft/world/entity/Entity;", "entity", "getArmorModel", "(Lnet/minecraft/world/entity/Entity;)Lcom/dannbrown/deltaboxlib/common/content/armorRenderer/AbstractArmorModel;", "Ljava/lang/String;", "Ljava/util/function/Supplier;", "Lcom/dannbrown/deltaboxlib/common/content/armorRenderer/ArmorModelSupplier;", "Lnet/minecraft/client/model/geom/ModelLayerLocation;", "layerLocation", "Lnet/minecraft/client/model/geom/ModelLayerLocation;", "getLayerLocation", "()Lnet/minecraft/client/model/geom/ModelLayerLocation;", "resourceLocations", "Lnet/minecraft/resources/ResourceLocation;", "armorModel", "Lcom/dannbrown/deltaboxlib/common/content/armorRenderer/AbstractArmorModel;", "deltaboxlib-forge"})
public final class ArmorModelProvider {
    @NotNull
    private final String modId;
    @NotNull
    private final Supplier<LayerDefinition> layerDefinitionSupplier;
    @NotNull
    private final ArmorModelSupplier armorModelSupplier;
    @NotNull
    private final ModelLayerLocation layerLocation;
    @NotNull
    private final ResourceLocation resourceLocations;
    @Nullable
    private AbstractArmorModel<LivingEntity> armorModel;

    public ArmorModelProvider(@NotNull String modId, @NotNull String armorName, @NotNull EquipmentSlot slot, @NotNull Supplier<LayerDefinition> layerDefinitionSupplier, @NotNull ArmorModelSupplier armorModelSupplier) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        Intrinsics.checkNotNullParameter((Object)armorName, (String)"armorName");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter(layerDefinitionSupplier, (String)"layerDefinitionSupplier");
        Intrinsics.checkNotNullParameter((Object)armorModelSupplier, (String)"armorModelSupplier");
        this.modId = modId;
        this.layerDefinitionSupplier = layerDefinitionSupplier;
        this.armorModelSupplier = armorModelSupplier;
        ResourceLocation resourceLocation = new ResourceLocation("minecraft:player");
        String string = slot.name();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        this.layerLocation = new ModelLayerLocation(resourceLocation, armorName + "_" + string2);
        this.resourceLocations = DeltaboxUtil.INSTANCE.resourceLocation(this.modId, "textures/armor/" + armorName + ".png");
    }

    @NotNull
    public final ModelLayerLocation getLayerLocation() {
        return this.layerLocation;
    }

    @NotNull
    public final ResourceLocation getTexture() {
        return this.resourceLocations;
    }

    @NotNull
    public final LayerDefinition createLayer() {
        LayerDefinition layerDefinition = this.layerDefinitionSupplier.get();
        Intrinsics.checkNotNullExpressionValue((Object)layerDefinition, (String)"get(...)");
        return layerDefinition;
    }

    @NotNull
    public final AbstractArmorModel<LivingEntity> createModel() {
        ModelPart modelPart = Minecraft.m_91087_().m_167973_().m_171103_(this.layerLocation);
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        return this.armorModelSupplier.create(modelPart);
    }

    @NotNull
    public final AbstractArmorModel<LivingEntity> getArmorModel(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (this.armorModel == null) {
            ModelPart modelPart = Minecraft.m_91087_().m_167973_().m_171103_(this.layerLocation);
            Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
            this.armorModel = this.armorModelSupplier.create(modelPart);
        }
        AbstractArmorModel<LivingEntity> abstractArmorModel = this.armorModel;
        Intrinsics.checkNotNull(abstractArmorModel);
        return abstractArmorModel;
    }
}

