/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.common.content.block;

import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0016\u0018\u0000 \\2\u00020\u0001:\u0001\\B1\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ/\u0010\u0015\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J/\u0010\u0017\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J/\u0010\u0019\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0018J'\u0010\u001b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ'\u0010\u001e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\"\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b%\u0010&J'\u0010+\u001a\u00020*2\u0016\u0010)\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010(\u0012\u0006\u0012\u0004\u0018\u00010\f0'H\u0014\u00a2\u0006\u0004\b+\u0010,J\u0017\u0010-\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b-\u0010.J/\u00102\u001a\u00020*2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020/2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u00101\u001a\u000200H\u0016\u00a2\u0006\u0004\b2\u00103J/\u00104\u001a\u00020*2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020/2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u00101\u001a\u000200H\u0016\u00a2\u0006\u0004\b4\u00103J/\u00108\u001a\u0002072\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u00106\u001a\u000205H\u0016\u00a2\u0006\u0004\b8\u00109J'\u0010<\u001a\u00020;2\u0006\u0010:\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b<\u0010=J?\u0010G\u001a\u00020F2\u0006\u0010>\u001a\u00020\f2\u0006\u0010:\u001a\u00020?2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010A\u001a\u00020@2\u0006\u0010C\u001a\u00020B2\u0006\u0010E\u001a\u00020DH\u0016\u00a2\u0006\u0004\bG\u0010HJ'\u0010J\u001a\u00020\u00142\u0006\u0010I\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\bJ\u0010KJ'\u0010M\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020L2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\bM\u0010NJ?\u0010Q\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010O\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010P\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\bQ\u0010RJ\u0017\u0010S\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\bS\u0010.J\u0017\u0010T\u001a\u00020\u00072\u0006\u0010:\u001a\u00020?H\u0014\u00a2\u0006\u0004\bT\u0010UJ/\u0010X\u001a\u00020*2\u0006\u0010:\u001a\u00020/2\u0006\u0010V\u001a\u0002002\u0006\u0010W\u001a\u00020\u00102\u0006\u0010>\u001a\u00020\fH\u0016\u00a2\u0006\u0004\bX\u0010YR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010ZR\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010[R\u0014\u0010\t\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010[\u00a8\u0006]"}, d2={"Lcom/dannbrown/deltaboxlib/common/content/block/CropLeavesBlock;", "Lnet/minecraft/world/level/block/CropBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "props", "Ljava/util/function/Supplier;", "Lnet/minecraft/world/level/ItemLike;", "itemToDrop", "", "flammability", "fireSpread", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;Ljava/util/function/Supplier;II)V", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/world/level/BlockGetter;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/core/Direction;", "direction", "", "isFlammable", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z", "getFlammability", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)I", "getFireSpreadSpeed", "world", "getLightBlock", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)I", "Lnet/minecraft/world/level/LevelAccessor;", "updateDistanceFromLogs", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", "getDistanceFromLog", "(Lnet/minecraft/world/level/block/state/BlockState;)I", "getMaxAge", "()I", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "getAgeProperty", "()Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "builder", "", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "isRandomlyTicking", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "Lnet/minecraft/server/level/ServerLevel;", "Lnet/minecraft/util/RandomSource;", "random", "randomTick", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "tick", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "context", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "pLevel", "Lnet/minecraft/world/item/ItemStack;", "getCloneItemStack", "(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/item/ItemStack;", "pState", "Lnet/minecraft/world/level/Level;", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "pHand", "Lnet/minecraft/world/phys/BlockHitResult;", "pHit", "Lnet/minecraft/world/InteractionResult;", "use", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "floor", "mayPlaceOn", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Z", "Lnet/minecraft/world/level/LevelReader;", "canSurvive", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z", "neighborState", "neighborPos", "updateShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", "isMature", "getBonemealAgeIncrease", "(Lnet/minecraft/world/level/Level;)I", "pRandom", "pPos", "performBonemeal", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/util/RandomSource;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Ljava/util/function/Supplier;", "I", "Companion", "deltaboxlib-forge"})
public class CropLeavesBlock
extends CropBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Supplier<ItemLike> itemToDrop;
    private final int flammability;
    private final int fireSpread;
    private static final int MAX_AGE = 3;
    private static final int MAX_DISTANCE = 7;
    @NotNull
    private static final IntegerProperty AGE;
    @NotNull
    private static final IntegerProperty DISTANCE;
    @NotNull
    private static final BooleanProperty WATERLOGGED;

    public CropLeavesBlock(@NotNull BlockBehaviour.Properties props, @NotNull Supplier<ItemLike> itemToDrop, int flammability, int fireSpread) {
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        Intrinsics.checkNotNullParameter(itemToDrop, (String)"itemToDrop");
        super(props);
        this.itemToDrop = itemToDrop;
        this.flammability = flammability;
        this.fireSpread = fireSpread;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(MAX_DISTANCE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public /* synthetic */ CropLeavesBlock(BlockBehaviour.Properties properties, Supplier supplier, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = 20;
        }
        if ((n3 & 8) != 0) {
            n2 = 5;
        }
        this(properties, supplier, n, n2);
    }

    public boolean isFlammable(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return true;
    }

    public int getFlammability(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return this.flammability;
    }

    public int getFireSpreadSpeed(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return this.fireSpread;
    }

    public int m_7753_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return 1;
    }

    private final BlockState updateDistanceFromLogs(BlockState state, LevelAccessor world, BlockPos pos) {
        int distance = MAX_DISTANCE;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            mutablePos.m_122159_((Vec3i)pos, direction);
            double d = distance;
            BlockState blockState = world.m_8055_((BlockPos)mutablePos);
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            double d2 = this.getDistanceFromLog(blockState) + 1;
            distance = (int)Math.min(d, d2);
            if (distance == 1) break;
        }
        Object object = state.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(distance));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    private final int getDistanceFromLog(BlockState state) {
        int n;
        if (state.m_204336_(BlockTags.f_13106_)) {
            n = 0;
        } else if (state.m_60734_() instanceof CropLeavesBlock || state.m_60734_() instanceof LeavesBlock) {
            Comparable comparable = state.m_61143_((Property)DISTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
            n = ((Number)((Object)comparable)).intValue();
        } else {
            n = MAX_DISTANCE;
        }
        return n;
    }

    public int m_7419_() {
        return 3;
    }

    @NotNull
    public IntegerProperty m_7959_() {
        return AGE;
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{AGE, DISTANCE, WATERLOGGED};
        builder.m_61104_(propertyArray);
    }

    public boolean m_6724_(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return true;
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        int i;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (world.m_45524_(pos, 0) >= 9 && (i = this.m_52305_(state)) < this.m_7419_() && random.m_188503_(100) % 25 == 0) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(i + 1)), 2);
        }
        Integer n = (Integer)state.m_61143_((Property)DISTANCE);
        int n2 = 7;
        if (n != null && n == n2) {
            CropBlock.m_49950_((BlockState)state, (Level)((Level)world), (BlockPos)pos);
            world.m_7471_(pos, false);
        }
    }

    public void m_213897_(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        world.m_7731_(pos, this.updateDistanceFromLogs(state, (LevelAccessor)world, pos), 3);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VoxelShape voxelShape = Shapes.m_83144_();
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"block(...)");
        return voxelShape;
    }

    @NotNull
    public ItemStack m_7397_(@NotNull BlockGetter pLevel, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new ItemStack(this.itemToDrop.get());
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pHand, (String)"pHand");
        Intrinsics.checkNotNullParameter((Object)pHit, (String)"pHit");
        if (!this.isMature(pState) && player.m_21120_(pHand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if (this.isMature(pState)) {
            Block.m_49840_((Level)pLevel, (BlockPos)pos, (ItemStack)new ItemStack(this.itemToDrop.get()));
            pLevel.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + pLevel.f_46441_.m_188501_() * 0.4f);
            BlockState blockState = (BlockState)pState.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(0));
            pLevel.m_7731_(pos, blockState, 2);
            pLevel.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)((Entity)player), (BlockState)blockState));
            InteractionResult interactionResult = InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"sidedSuccess(...)");
            return interactionResult;
        }
        InteractionResult interactionResult = super.m_6227_(pState, pLevel, pos, player, pHand, pHit);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"use(...)");
        return interactionResult;
    }

    protected boolean m_6266_(@NotNull BlockState floor, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)floor, (String)"floor");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return true;
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return true;
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
                Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
                Intrinsics.checkNotNullParameter((Object)world, (String)"world");
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
                int distance = this.getDistanceFromLog(neighborState) + 1;
                if (distance != 1) break block2;
                Integer n = (Integer)state.m_61143_((Property)DISTANCE);
                int n2 = distance;
                if (n != null && n == n2) break block3;
            }
            world.m_186460_(pos, (Block)this, 1);
        }
        return state;
    }

    private final boolean isMature(BlockState state) {
        Integer n = (Integer)state.m_61143_((Property)this.m_7959_());
        int n2 = this.m_7419_();
        return n != null && n == n2;
    }

    protected int m_7125_(@NotNull Level pLevel) {
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        return Mth.m_216271_((RandomSource)pLevel.f_46441_, (int)1, (int)2);
    }

    public void m_214148_(@NotNull ServerLevel pLevel, @NotNull RandomSource pRandom, @NotNull BlockPos pPos, @NotNull BlockState pState) {
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pRandom, (String)"pRandom");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        int i = this.m_52305_(pState) + this.m_7125_((Level)pLevel);
        int j = this.m_7419_();
        if (i > j) {
            i = j;
        }
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(i)), 2);
    }

    static {
        IntegerProperty integerProperty = BlockStateProperties.f_61407_;
        Intrinsics.checkNotNullExpressionValue((Object)integerProperty, (String)"AGE_3");
        AGE = integerProperty;
        IntegerProperty integerProperty2 = BlockStateProperties.f_61414_;
        Intrinsics.checkNotNullExpressionValue((Object)integerProperty2, (String)"DISTANCE");
        DISTANCE = integerProperty2;
        BooleanProperty booleanProperty = BlockStateProperties.f_61362_;
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"WATERLOGGED");
        WATERLOGGED = booleanProperty;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u00048\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\t\u0010\u0006\u001a\u0004\b\n\u0010\bR\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u0011\u0010\u000fR\u0017\u0010\u0013\u001a\u00020\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/dannbrown/deltaboxlib/common/content/block/CropLeavesBlock$Companion;", "", "<init>", "()V", "", "MAX_AGE", "I", "getMAX_AGE", "()I", "MAX_DISTANCE", "getMAX_DISTANCE", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "AGE", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "getAGE", "()Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "DISTANCE", "getDISTANCE", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "WATERLOGGED", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getWATERLOGGED", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "deltaboxlib-forge"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMAX_AGE() {
            return MAX_AGE;
        }

        public final int getMAX_DISTANCE() {
            return MAX_DISTANCE;
        }

        @NotNull
        public final IntegerProperty getAGE() {
            return AGE;
        }

        @NotNull
        public final IntegerProperty getDISTANCE() {
            return DISTANCE;
        }

        @NotNull
        public final BooleanProperty getWATERLOGGED() {
            return WATERLOGGED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

