/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.common.content.item;

import com.dannbrown.deltaboxlib.common.content.armorRenderer.ArmorModelProvider;
import com.dannbrown.deltaboxlib.common.registrate.AbstractDeltaboxRegistrate;
import com.dannbrown.deltaboxlib.common.registrate.registry.ArmorModelRegistry;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ7\u0010\u0014\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u001a\u001a\u00020\u00192\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001f\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lcom/dannbrown/deltaboxlib/common/content/item/CustomModelArmorItem;", "Lnet/minecraft/world/item/ArmorItem;", "Lcom/dannbrown/deltaboxlib/common/registrate/AbstractDeltaboxRegistrate;", "registrate", "", "armorSetName", "Lnet/minecraft/world/item/ArmorMaterial;", "material", "Lnet/minecraft/world/item/ArmorItem$Type;", "type", "Lnet/minecraft/world/item/Item$Properties;", "props", "<init>", "(Lcom/dannbrown/deltaboxlib/common/registrate/AbstractDeltaboxRegistrate;Ljava/lang/String;Lnet/minecraft/world/item/ArmorMaterial;Lnet/minecraft/world/item/ArmorItem$Type;Lnet/minecraft/world/item/Item$Properties;)V", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/world/entity/Entity;", "entity", "Lnet/minecraft/world/entity/EquipmentSlot;", "slot", "getArmorTexture", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/EquipmentSlot;Ljava/lang/String;)Ljava/lang/String;", "Ljava/util/function/Consumer;", "Lnet/minecraftforge/client/extensions/common/IClientItemExtensions;", "consumer", "", "initializeClient", "(Ljava/util/function/Consumer;)V", "Lcom/dannbrown/deltaboxlib/common/registrate/AbstractDeltaboxRegistrate;", "getRegistrate", "()Lcom/dannbrown/deltaboxlib/common/registrate/AbstractDeltaboxRegistrate;", "Ljava/lang/String;", "getArmorSetName", "()Ljava/lang/String;", "deltaboxlib-forge"})
public class CustomModelArmorItem
extends ArmorItem {
    @NotNull
    private final AbstractDeltaboxRegistrate registrate;
    @NotNull
    private final String armorSetName;

    public CustomModelArmorItem(@NotNull AbstractDeltaboxRegistrate registrate, @NotNull String armorSetName, @NotNull ArmorMaterial material, @NotNull ArmorItem.Type type2, @NotNull Item.Properties props) {
        Intrinsics.checkNotNullParameter((Object)registrate, (String)"registrate");
        Intrinsics.checkNotNullParameter((Object)armorSetName, (String)"armorSetName");
        Intrinsics.checkNotNullParameter((Object)material, (String)"material");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        super(material, type2, props.m_41487_(1));
        this.registrate = registrate;
        this.armorSetName = armorSetName;
    }

    @NotNull
    public final AbstractDeltaboxRegistrate getRegistrate() {
        return this.registrate;
    }

    @NotNull
    public final String getArmorSetName() {
        return this.armorSetName;
    }

    @NotNull
    public String getArmorTexture(@Nullable ItemStack stack, @Nullable Entity entity, @Nullable EquipmentSlot slot, @Nullable String type2) {
        ArmorModelRegistry armorModelRegistry = this.registrate.getArmorModelRegistry();
        EquipmentSlot equipmentSlot = slot;
        Intrinsics.checkNotNull((Object)equipmentSlot);
        ArmorModelProvider armorModelProvider = armorModelRegistry.getProviderForArmor(this.armorSetName, equipmentSlot);
        Intrinsics.checkNotNull((Object)armorModelProvider);
        String string = armorModelProvider.getTexture().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        consumer.accept(new IClientItemExtensions(this){
            private ArmorModelProvider armorModelProvider;
            private HumanoidModel<LivingEntity> model;
            final /* synthetic */ CustomModelArmorItem this$0;
            {
                this.this$0 = $receiver;
            }

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> defaultModel) {
                Intrinsics.checkNotNullParameter((Object)living, (String)"living");
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
                Intrinsics.checkNotNullParameter(defaultModel, (String)"defaultModel");
                ArmorModelProvider armorModelProvider = this.this$0.getRegistrate().getArmorModelRegistry().getProviderForArmor(this.this$0.getArmorSetName(), slot);
                Intrinsics.checkNotNull((Object)armorModelProvider);
                ArmorModelProvider provider = armorModelProvider;
                if (!Intrinsics.areEqual((Object)this.armorModelProvider, (Object)provider)) {
                    ArmorModelProvider armorModelProvider2 = this.armorModelProvider = provider;
                    Intrinsics.checkNotNull((Object)armorModelProvider2);
                    this.model = armorModelProvider2.createModel();
                }
                if (this.model == null) {
                    return defaultModel;
                }
                Intrinsics.checkNotNull(this.model);
                this.model.f_102610_ = living.m_6162_();
                Intrinsics.checkNotNull(this.model);
                this.model.f_102817_ = living.m_6144_();
                Intrinsics.checkNotNull(this.model);
                this.model.f_102609_ = defaultModel.f_102609_;
                float limbSwingAmount = 0.0f;
                float limbSwing = 0.0f;
                float partialTicks = 0.0f;
                if (!living.m_20159_() && living.m_6084_()) {
                    limbSwingAmount = living.f_267362_.m_267711_(partialTicks);
                    limbSwing = living.f_267362_.m_267590_(partialTicks);
                    if (living.m_6162_()) {
                        limbSwing *= 3.0f;
                    }
                    if (limbSwingAmount > 1.0f) {
                        limbSwingAmount = 1.0f;
                    }
                }
                HumanoidModel<LivingEntity> humanoidModel = this.model;
                Intrinsics.checkNotNull(humanoidModel);
                humanoidModel.m_6973_(living, limbSwing, limbSwingAmount, (float)living.f_19797_, 0.0f, 0.0f);
                HumanoidModel<LivingEntity> humanoidModel2 = this.model;
                Intrinsics.checkNotNull(humanoidModel2);
                return humanoidModel2;
            }
        });
    }
}

