/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.common.content.particle.trail;

import com.dannbrown.deltaboxlib.common.content.particle.trail.TrailParticleOption;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002\u001c\u001dBS\b\u0000\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0017H\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lcom/dannbrown/deltaboxlib/common/content/particle/trail/TrailParticle;", "Lnet/minecraft/client/particle/TextureSheetParticle;", "Lnet/minecraft/client/multiplayer/ClientLevel;", "level", "", "x", "y", "z", "xd", "yd", "zd", "Lnet/minecraft/world/phys/Vec3;", "target", "", "color", "<init>", "(Lnet/minecraft/client/multiplayer/ClientLevel;DDDDDDLnet/minecraft/world/phys/Vec3;I)V", "Lnet/minecraft/client/particle/ParticleRenderType;", "getRenderType", "()Lnet/minecraft/client/particle/ParticleRenderType;", "", "tick", "()V", "", "pTickDelta", "getLightColor", "(F)I", "Lnet/minecraft/world/phys/Vec3;", "Provider", "LongColor", "deltaboxlib-forge"})
public final class TrailParticle
extends TextureSheetParticle {
    @NotNull
    private final Vec3 target;

    public TrailParticle(@Nullable ClientLevel level, double x, double y, double z, double xd, double yd, double zd, @NotNull Vec3 target, int color) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        super(level, x, y, z, xd, yd, zd);
        int scaledColor = LongColor.INSTANCE.scaleRGB(color, 0.875f + this.f_107223_.m_188501_() * 0.25f, 0.875f + this.f_107223_.m_188501_() * 0.25f, 0.875f + this.f_107223_.m_188501_() * 0.25f);
        this.f_107227_ = (float)LongColor.INSTANCE.red(scaledColor) / 255.0f;
        this.f_107228_ = (float)LongColor.INSTANCE.green(scaledColor) / 255.0f;
        this.f_107229_ = (float)LongColor.INSTANCE.blue(scaledColor) / 255.0f;
        this.f_107663_ = 0.26f;
        this.target = target;
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        ParticleRenderType particleRenderType = ParticleRenderType.f_107430_;
        Intrinsics.checkNotNullExpressionValue((Object)particleRenderType, (String)"PARTICLE_SHEET_OPAQUE");
        return particleRenderType;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        int n = this.f_107224_;
        this.f_107224_ = n + 1;
        if (n >= this.f_107225_) {
            this.m_107274_();
        } else {
            int remainingTime = this.f_107225_ - this.f_107224_;
            double lerpFactor = 1.0 / (double)remainingTime;
            this.f_107212_ = Mth.m_14139_((double)lerpFactor, (double)this.f_107212_, (double)this.target.m_7096_());
            this.f_107213_ = Mth.m_14139_((double)lerpFactor, (double)this.f_107213_, (double)this.target.m_7098_());
            this.f_107214_ = Mth.m_14139_((double)lerpFactor, (double)this.f_107214_, (double)this.target.m_7094_());
        }
    }

    protected int m_6355_(float pTickDelta) {
        return 0xF000F0;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\u0007J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\u0007J-\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/dannbrown/deltaboxlib/common/content/particle/trail/TrailParticle$LongColor;", "", "<init>", "()V", "", "color", "red", "(I)I", "green", "blue", "", "scaleR", "scaleG", "scaleB", "scaleRGB", "(IFFF)I", "deltaboxlib-forge"})
    public static final class LongColor {
        @NotNull
        public static final LongColor INSTANCE = new LongColor();

        private LongColor() {
        }

        public final int red(int color) {
            return color >> 16 & 0xFF;
        }

        public final int green(int color) {
            return color >> 8 & 0xFF;
        }

        public final int blue(int color) {
            return color & 0xFF;
        }

        public final int scaleRGB(int color, float scaleR, float scaleG, float scaleB) {
            int r = (int)RangesKt.coerceIn((float)((float)this.red(color) * scaleR), (float)0.0f, (float)255.0f);
            int g = (int)RangesKt.coerceIn((float)((float)this.green(color) * scaleG), (float)0.0f, (float)255.0f);
            int b = (int)RangesKt.coerceIn((float)((float)this.blue(color) * scaleB), (float)0.0f, (float)255.0f);
            return r << 16 | g << 8 | b;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006JO\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/dannbrown/deltaboxlib/common/content/particle/trail/TrailParticle$Provider;", "Lnet/minecraft/client/particle/ParticleProvider;", "Lcom/dannbrown/deltaboxlib/common/content/particle/trail/TrailParticleOption;", "Lnet/minecraft/client/particle/SpriteSet;", "sprite", "<init>", "(Lnet/minecraft/client/particle/SpriteSet;)V", "option", "Lnet/minecraft/client/multiplayer/ClientLevel;", "level", "", "x", "y", "z", "xd", "yd", "zd", "Lnet/minecraft/client/particle/Particle;", "createParticle", "(Lcom/dannbrown/deltaboxlib/common/content/particle/trail/TrailParticleOption;Lnet/minecraft/client/multiplayer/ClientLevel;DDDDDD)Lnet/minecraft/client/particle/Particle;", "Lnet/minecraft/client/particle/SpriteSet;", "deltaboxlib-forge"})
    public static final class Provider
    implements ParticleProvider<TrailParticleOption> {
        @NotNull
        private final SpriteSet sprite;

        public Provider(@NotNull SpriteSet sprite) {
            Intrinsics.checkNotNullParameter((Object)sprite, (String)"sprite");
            this.sprite = sprite;
        }

        @NotNull
        public Particle createParticle(@NotNull TrailParticleOption option, @NotNull ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            TrailParticle particle = new TrailParticle(level, x, y, z, xd, yd, zd, option.target(), option.color());
            particle.m_108335_(this.sprite);
            particle.m_107257_(option.duration());
            return (Particle)particle;
        }
    }
}

