/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.common.content.worldgen.decorator;

import com.dannbrown.deltaboxlib.common.init.DeltaboxPlacerTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.AttachedToLeavesDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fBE\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0013\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\r\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/dannbrown/deltaboxlib/common/content/worldgen/decorator/DeltaVineDecorator;", "Lnet/minecraft/world/level/levelgen/feature/treedecorators/AttachedToLeavesDecorator;", "", "probability", "", "exclusionRadiusXZ", "exclusionRadiusY", "Lnet/minecraft/world/level/levelgen/feature/stateproviders/BlockStateProvider;", "blockProvider", "requiredEmptyBlocks", "", "Lnet/minecraft/core/Direction;", "directions", "tipBlockProvider", "<init>", "(FIILnet/minecraft/world/level/levelgen/feature/stateproviders/BlockStateProvider;ILjava/util/List;Lnet/minecraft/world/level/levelgen/feature/stateproviders/BlockStateProvider;)V", "Lnet/minecraft/world/level/levelgen/feature/treedecorators/TreeDecoratorType;", "type", "()Lnet/minecraft/world/level/levelgen/feature/treedecorators/TreeDecoratorType;", "Lnet/minecraft/world/level/levelgen/feature/treedecorators/TreeDecorator$Context;", "context", "", "place", "(Lnet/minecraft/world/level/levelgen/feature/treedecorators/TreeDecorator$Context;)V", "Lnet/minecraft/core/BlockPos;", "pos", "direction", "", "hasRequiredEmptyBlocks", "(Lnet/minecraft/world/level/levelgen/feature/treedecorators/TreeDecorator$Context;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z", "Lnet/minecraft/world/level/levelgen/feature/stateproviders/BlockStateProvider;", "Companion", "deltaboxlib-forge"})
@SourceDebugExtension(value={"SMAP\nDeltaVineDecorator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeltaVineDecorator.kt\ncom/dannbrown/deltaboxlib/common/content/worldgen/decorator/DeltaVineDecorator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1557#2:119\n1628#2,3:120\n1734#2,3:123\n*S KotlinDebug\n*F\n+ 1 DeltaVineDecorator.kt\ncom/dannbrown/deltaboxlib/common/content/worldgen/decorator/DeltaVineDecorator\n*L\n96#1:119\n96#1:120,3\n115#1:123,3\n*E\n"})
public final class DeltaVineDecorator
extends AttachedToLeavesDecorator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockStateProvider tipBlockProvider;
    @NotNull
    private static final Codec<DeltaVineDecorator> CODEC;

    public DeltaVineDecorator(float probability, int exclusionRadiusXZ, int exclusionRadiusY, @NotNull BlockStateProvider blockProvider, int requiredEmptyBlocks, @NotNull List<Direction> directions, @NotNull BlockStateProvider tipBlockProvider) {
        Intrinsics.checkNotNullParameter((Object)blockProvider, (String)"blockProvider");
        Intrinsics.checkNotNullParameter(directions, (String)"directions");
        Intrinsics.checkNotNullParameter((Object)tipBlockProvider, (String)"tipBlockProvider");
        super(probability, exclusionRadiusXZ, exclusionRadiusY, blockProvider, requiredEmptyBlocks, directions);
        this.tipBlockProvider = tipBlockProvider;
    }

    @NotNull
    protected TreeDecoratorType<?> m_6663_() {
        TreeDecoratorType<? extends TreeDecorator> treeDecoratorType = DeltaboxPlacerTypes.INSTANCE.getVINE_DECORATOR().get();
        Intrinsics.checkNotNullExpressionValue(treeDecoratorType, (String)"get(...)");
        return treeDecoratorType;
    }

    /*
     * WARNING - void declaration
     */
    public void m_214187_(@NotNull TreeDecorator.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Set placedPositions = new LinkedHashSet();
        RandomSource random = context.m_226067_();
        for (BlockPos leafPos : Util.m_214611_((ObjectArrayList)context.m_226069_(), (RandomSource)random)) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Direction direction;
            BlockPos vinePos = leafPos.m_121945_(direction = (Direction)Util.m_214621_((List)this.f_225985_, (RandomSource)random));
            if (placedPositions.contains(vinePos) || !(random.m_188501_() < this.f_225980_)) continue;
            Intrinsics.checkNotNull((Object)leafPos);
            Intrinsics.checkNotNull((Object)direction);
            if (!this.hasRequiredEmptyBlocks(context, leafPos, direction)) continue;
            BlockPos minBound = vinePos.m_7918_(-this.f_225981_, -this.f_225982_, -this.f_225981_);
            BlockPos maxBound = vinePos.m_7918_(this.f_225981_, this.f_225982_, this.f_225981_);
            Intrinsics.checkNotNullExpressionValue((Object)BlockPos.m_121940_((BlockPos)minBound, (BlockPos)maxBound), (String)"betweenClosed(...)");
            Set set = placedPositions;
            boolean $i$f$map = false;
            void var12_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BlockPos blockPos = (BlockPos)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.m_7949_());
            }
            set.addAll((List)destination$iv$iv);
            int vineLength = random.m_188503_(3) + 1;
            for (int i = 0; i < vineLength; ++i) {
                BlockPos stackedPos = vinePos.m_6625_(i);
                context.m_226061_(stackedPos, this.f_225983_.m_213972_(random, stackedPos));
            }
            BlockPos tipPos = vinePos.m_6625_(vineLength);
            context.m_226061_(tipPos, this.tipBlockProvider.m_213972_(random, tipPos));
        }
    }

    private final boolean hasRequiredEmptyBlocks(TreeDecorator.Context context, BlockPos pos, Direction direction) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = (Iterable)new IntRange(1, this.f_225984_);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (context.m_226059_(pos.m_5484_(direction, it))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final Float CODEC$lambda$10$lambda$2(DeltaVineDecorator it) {
        return Float.valueOf(it.f_225980_);
    }

    private static final Integer CODEC$lambda$10$lambda$3(DeltaVineDecorator it) {
        return it.f_225981_;
    }

    private static final Integer CODEC$lambda$10$lambda$4(DeltaVineDecorator it) {
        return it.f_225982_;
    }

    private static final BlockStateProvider CODEC$lambda$10$lambda$5(DeltaVineDecorator it) {
        return it.f_225983_;
    }

    private static final Integer CODEC$lambda$10$lambda$6(DeltaVineDecorator it) {
        return it.f_225984_;
    }

    private static final List CODEC$lambda$10$lambda$7(DeltaVineDecorator it) {
        return it.f_225985_;
    }

    private static final BlockStateProvider CODEC$lambda$10$lambda$8(DeltaVineDecorator it) {
        return it.tipBlockProvider;
    }

    private static final DeltaVineDecorator CODEC$lambda$10$lambda$9(Float probability, Integer exclusionRadiusXZ, Integer exclusionRadiusY, BlockStateProvider blockProvider, Integer requiredEmptyBlocks, List directions, BlockStateProvider tipBlockProvider) {
        Intrinsics.checkNotNull((Object)probability);
        float f = probability.floatValue();
        Intrinsics.checkNotNull((Object)exclusionRadiusXZ);
        int n = exclusionRadiusXZ;
        Intrinsics.checkNotNull((Object)exclusionRadiusY);
        int n2 = exclusionRadiusY;
        Intrinsics.checkNotNull((Object)blockProvider);
        Intrinsics.checkNotNull((Object)requiredEmptyBlocks);
        int n3 = requiredEmptyBlocks;
        Intrinsics.checkNotNull((Object)directions);
        Intrinsics.checkNotNull((Object)tipBlockProvider);
        return new DeltaVineDecorator(f, n, n2, blockProvider, n3, directions, tipBlockProvider);
    }

    private static final App CODEC$lambda$10(RecordCodecBuilder.Instance instance) {
        return instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(DeltaVineDecorator::CODEC$lambda$10$lambda$2), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_xz").forGetter(DeltaVineDecorator::CODEC$lambda$10$lambda$3), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_y").forGetter(DeltaVineDecorator::CODEC$lambda$10$lambda$4), (App)BlockStateProvider.f_68747_.fieldOf("block_provider").forGetter(DeltaVineDecorator::CODEC$lambda$10$lambda$5), (App)Codec.intRange((int)1, (int)16).fieldOf("required_empty_blocks").forGetter(DeltaVineDecorator::CODEC$lambda$10$lambda$6), (App)ExtraCodecs.m_144637_((Codec)Direction.f_175356_.listOf()).fieldOf("directions").forGetter(DeltaVineDecorator::CODEC$lambda$10$lambda$7), (App)BlockStateProvider.f_68747_.fieldOf("tip_block_provider").forGetter(DeltaVineDecorator::CODEC$lambda$10$lambda$8)).apply((Applicative)instance, DeltaVineDecorator::CODEC$lambda$10$lambda$9);
    }

    static {
        Codec codec = RecordCodecBuilder.create(DeltaVineDecorator::CODEC$lambda$10);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        CODEC = codec;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/dannbrown/deltaboxlib/common/content/worldgen/decorator/DeltaVineDecorator$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/Codec;", "Lcom/dannbrown/deltaboxlib/common/content/worldgen/decorator/DeltaVineDecorator;", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "deltaboxlib-forge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<DeltaVineDecorator> getCODEC() {
            return CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

