/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.common.registrate.registry;

import com.dannbrown.deltaboxlib.common.registrate.builders.BlockBuilder;
import com.dannbrown.deltaboxlib.common.registrate.registry.ItemEntry;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\b\u0018\u0000 **\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0003:\u0001*B%\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tB\u0017\b\u0016\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0004\b\b\u0010\fJ\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0011\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0018\u0010\u0018\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004H\u00c2\u0003\u00a2\u0006\u0004\b\u0018\u0010\u000eJ\u0016\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006H\u00c2\u0003\u00a2\u0006\u0004\b\u0019\u0010\u0017J8\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00042\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001a\u0010\u001e\u001a\u00020\u001d2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0010\u0010!\u001a\u00020 H\u00d6\u0001\u00a2\u0006\u0004\b!\u0010\"J\u0010\u0010$\u001a\u00020#H\u00d6\u0001\u00a2\u0006\u0004\b$\u0010%R\u001c\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010&R\u001a\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010'R\u001e\u0010(\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)\u00a8\u0006+"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/registry/BlockEntry;", "Lnet/minecraft/world/level/block/Block;", "T", "", "Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilder;", "builder", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ItemEntry;", "itemEntry", "<init>", "(Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilder;Lcom/dannbrown/deltaboxlib/common/registrate/registry/ItemEntry;)V", "Ljava/util/function/Supplier;", "block", "(Ljava/util/function/Supplier;)V", "getBuilder", "()Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilder;", "get", "()Lnet/minecraft/world/level/block/Block;", "supplier", "()Ljava/util/function/Supplier;", "Lnet/minecraft/world/item/Item;", "getItem", "()Lnet/minecraft/world/item/Item;", "getItemEntry", "()Lcom/dannbrown/deltaboxlib/common/registrate/registry/ItemEntry;", "component1", "component2", "copy", "(Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilder;Lcom/dannbrown/deltaboxlib/common/registrate/registry/ItemEntry;)Lcom/dannbrown/deltaboxlib/common/registrate/registry/BlockEntry;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lcom/dannbrown/deltaboxlib/common/registrate/builders/BlockBuilder;", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/ItemEntry;", "setupBlock", "Ljava/util/function/Supplier;", "Companion", "deltaboxlib-forge"})
public final class BlockEntry<T extends Block> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final BlockBuilder<T> builder;
    @Nullable
    private final ItemEntry<?> itemEntry;
    @Nullable
    private Supplier<T> setupBlock;

    public BlockEntry(@Nullable BlockBuilder<T> builder, @Nullable ItemEntry<?> itemEntry) {
        this.builder = builder;
        this.itemEntry = itemEntry;
    }

    public BlockEntry(@NotNull Supplier<T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this(null, null);
        this.setupBlock = block;
    }

    @NotNull
    public final BlockBuilder<T> getBuilder() {
        if (this.builder == null) {
            throw new NoSuchFieldError("Cannot get the builder from an external block entry.");
        }
        return this.builder;
    }

    @NotNull
    public final T get() {
        Block block;
        if (this.setupBlock != null) {
            Supplier<T> supplier = this.setupBlock;
            Intrinsics.checkNotNull(supplier);
            T t = supplier.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            block = (Block)t;
        } else if (this.builder != null) {
            T t = this.builder.getBlock().get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            block = (Block)t;
        } else {
            throw new NoSuchFieldError("This block entry is invalid");
        }
        return (T)block;
    }

    @NotNull
    public final Supplier<T> supplier() {
        Supplier<T> supplier;
        if (this.setupBlock != null) {
            Supplier<T> supplier2 = this.setupBlock;
            supplier = supplier2;
            Intrinsics.checkNotNull(supplier2);
        } else if (this.builder != null) {
            supplier = this.builder.getBlock();
        } else {
            throw new NoSuchFieldError("This block entry is invalid");
        }
        return supplier;
    }

    @NotNull
    public final Item getItem() {
        if (this.itemEntry == null) {
            throw new NoSuchFieldError("Cannot get the item from an external block entry.");
        }
        return this.itemEntry.get();
    }

    @NotNull
    public final ItemEntry<?> getItemEntry() {
        if (this.itemEntry == null) {
            throw new NoSuchFieldError("Cannot get the item from an external block entry.");
        }
        return this.itemEntry;
    }

    private final BlockBuilder<T> component1() {
        return this.builder;
    }

    private final ItemEntry<?> component2() {
        return this.itemEntry;
    }

    @NotNull
    public final BlockEntry<T> copy(@Nullable BlockBuilder<T> builder, @Nullable ItemEntry<?> itemEntry) {
        return new BlockEntry<T>(builder, itemEntry);
    }

    public static /* synthetic */ BlockEntry copy$default(BlockEntry blockEntry, BlockBuilder blockBuilder, ItemEntry itemEntry, int n, Object object) {
        if ((n & 1) != 0) {
            blockBuilder = blockEntry.builder;
        }
        if ((n & 2) != 0) {
            itemEntry = blockEntry.itemEntry;
        }
        return blockEntry.copy(blockBuilder, itemEntry);
    }

    @NotNull
    public String toString() {
        return "BlockEntry(builder=" + this.builder + ", itemEntry=" + this.itemEntry + ")";
    }

    public int hashCode() {
        int result = this.builder == null ? 0 : this.builder.hashCode();
        result = result * 31 + (this.itemEntry == null ? 0 : this.itemEntry.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BlockEntry)) {
            return false;
        }
        BlockEntry blockEntry = (BlockEntry)other;
        if (!Intrinsics.areEqual(this.builder, blockEntry.builder)) {
            return false;
        }
        return Intrinsics.areEqual(this.itemEntry, blockEntry.itemEntry);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\u0004\b\u0007\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/registry/BlockEntry$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/level/block/Block;", "block", "Lcom/dannbrown/deltaboxlib/common/registrate/registry/BlockEntry;", "from", "(Lnet/minecraft/world/level/block/Block;)Lcom/dannbrown/deltaboxlib/common/registrate/registry/BlockEntry;", "Ljava/util/function/Supplier;", "(Ljava/util/function/Supplier;)Lcom/dannbrown/deltaboxlib/common/registrate/registry/BlockEntry;", "deltaboxlib-forge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BlockEntry<?> from(@NotNull Block block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            return new BlockEntry<Block>(() -> Companion.from$lambda$0(block));
        }

        @NotNull
        public final BlockEntry<?> from(@NotNull Supplier<Block> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            return new BlockEntry<Block>(block);
        }

        private static final Block from$lambda$0(Block $block) {
            return $block;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

