/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.common.registrate.registry;

import com.mojang.serialization.Codec;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J9\u0010\r\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u00022\u0014\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ9\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u00100\u000b2\u0006\u0010\u0006\u001a\u00020\u00022\u0014\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\b0\u0007\u00a2\u0006\u0004\b\u0011\u0010\u000eJ9\u0010\u0014\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u00130\u000b2\u0006\u0010\u0006\u001a\u00020\u00022\u0014\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00120\b0\u0007\u00a2\u0006\u0004\b\u0014\u0010\u000eJ\r\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017RH\u0010\u001a\u001a6\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0019*\b\u0012\u0002\b\u0003\u0018\u00010\u00100\u0010 \u0019*\u001a\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0019*\b\u0012\u0002\b\u0003\u0018\u00010\u00100\u0010\u0018\u00010\u00180\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bRH\u0010\u001c\u001a6\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0019*\b\u0012\u0002\b\u0003\u0018\u00010\f0\f \u0019*\u001a\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0019*\b\u0012\u0002\b\u0003\u0018\u00010\f0\f\u0018\u00010\u00180\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001bRH\u0010\u001d\u001a6\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0019*\b\u0012\u0002\b\u0003\u0018\u00010\u00130\u0013 \u0019*\u001a\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0019*\b\u0012\u0002\b\u0003\u0018\u00010\u00130\u0013\u0018\u00010\u00180\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001bR\"\u0010\u001f\u001a\u00020\u001e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001f\u0010!\"\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/registry/PlacerTypeRegistry;", "", "", "modId", "<init>", "(Ljava/lang/String;)V", "id", "Ljava/util/function/Supplier;", "Lcom/mojang/serialization/Codec;", "Lnet/minecraft/world/level/levelgen/feature/trunkplacers/TrunkPlacer;", "codec", "Ldev/architectury/registry/registries/RegistrySupplier;", "Lnet/minecraft/world/level/levelgen/feature/trunkplacers/TrunkPlacerType;", "registerTrunk", "(Ljava/lang/String;Ljava/util/function/Supplier;)Ldev/architectury/registry/registries/RegistrySupplier;", "Lnet/minecraft/world/level/levelgen/feature/foliageplacers/FoliagePlacer;", "Lnet/minecraft/world/level/levelgen/feature/foliageplacers/FoliagePlacerType;", "registerFoliage", "Lnet/minecraft/world/level/levelgen/feature/treedecorators/TreeDecorator;", "Lnet/minecraft/world/level/levelgen/feature/treedecorators/TreeDecoratorType;", "registerTreeDecorator", "", "build", "()V", "Ldev/architectury/registry/registries/DeferredRegister;", "kotlin.jvm.PlatformType", "foliageTypes", "Ldev/architectury/registry/registries/DeferredRegister;", "trunkTypes", "treeDecorators", "", "isRegistered", "Z", "()Z", "setRegistered", "(Z)V", "deltaboxlib-forge"})
public final class PlacerTypeRegistry {
    private final DeferredRegister<FoliagePlacerType<?>> foliageTypes;
    private final DeferredRegister<TrunkPlacerType<?>> trunkTypes;
    private final DeferredRegister<TreeDecoratorType<?>> treeDecorators;
    private boolean isRegistered;

    public PlacerTypeRegistry(@NotNull String modId) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        this.foliageTypes = DeferredRegister.create((String)modId, (ResourceKey)Registries.f_256905_);
        this.trunkTypes = DeferredRegister.create((String)modId, (ResourceKey)Registries.f_256963_);
        this.treeDecorators = DeferredRegister.create((String)modId, (ResourceKey)Registries.f_256845_);
    }

    public final boolean isRegistered() {
        return this.isRegistered;
    }

    public final void setRegistered(boolean bl) {
        this.isRegistered = bl;
    }

    @NotNull
    public final RegistrySupplier<TrunkPlacerType<? extends TrunkPlacer>> registerTrunk(@NotNull String id, @NotNull Supplier<Codec<? extends TrunkPlacer>> codec) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        RegistrySupplier registrySupplier = this.trunkTypes.register(id, () -> PlacerTypeRegistry.registerTrunk$lambda$0(codec));
        Intrinsics.checkNotNullExpressionValue((Object)registrySupplier, (String)"register(...)");
        return registrySupplier;
    }

    @NotNull
    public final RegistrySupplier<FoliagePlacerType<? extends FoliagePlacer>> registerFoliage(@NotNull String id, @NotNull Supplier<Codec<? extends FoliagePlacer>> codec) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        RegistrySupplier registrySupplier = this.foliageTypes.register(id, () -> PlacerTypeRegistry.registerFoliage$lambda$1(codec));
        Intrinsics.checkNotNullExpressionValue((Object)registrySupplier, (String)"register(...)");
        return registrySupplier;
    }

    @NotNull
    public final RegistrySupplier<TreeDecoratorType<? extends TreeDecorator>> registerTreeDecorator(@NotNull String id, @NotNull Supplier<Codec<? extends TreeDecorator>> codec) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        RegistrySupplier registrySupplier = this.treeDecorators.register(id, () -> PlacerTypeRegistry.registerTreeDecorator$lambda$2(codec));
        Intrinsics.checkNotNullExpressionValue((Object)registrySupplier, (String)"register(...)");
        return registrySupplier;
    }

    public final void build() {
        if (this.isRegistered) {
            return;
        }
        this.isRegistered = true;
        this.trunkTypes.register();
        this.foliageTypes.register();
        this.treeDecorators.register();
    }

    private static final TrunkPlacerType registerTrunk$lambda$0(Supplier $codec) {
        return new TrunkPlacerType((Codec)$codec.get());
    }

    private static final FoliagePlacerType registerFoliage$lambda$1(Supplier $codec) {
        return new FoliagePlacerType((Codec)$codec.get());
    }

    private static final TreeDecoratorType registerTreeDecorator$lambda$2(Supplier $codec) {
        return new TreeDecoratorType((Codec)$codec.get());
    }
}

