/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.common.registrate.registry;

import com.dannbrown.deltaboxlib.common.registrate.providers.trades.VillagerTradeCodec;
import com.dannbrown.deltaboxlib.common.registrate.providers.trades.WandererTradeCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u0010\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001b\u0010\u0012\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e\u00a2\u0006\u0004\b\u0015\u0010\u0014R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/registry/TradeRegistry;", "", "", "modId", "<init>", "(Ljava/lang/String;)V", "Lcom/dannbrown/deltaboxlib/common/registrate/providers/trades/VillagerTradeCodec;", "trade", "", "addTrade", "(Lcom/dannbrown/deltaboxlib/common/registrate/providers/trades/VillagerTradeCodec;)V", "Lcom/dannbrown/deltaboxlib/common/registrate/providers/trades/WandererTradeCodec;", "addWanderer", "(Lcom/dannbrown/deltaboxlib/common/registrate/providers/trades/WandererTradeCodec;)V", "", "trades", "updateTrades", "(Ljava/util/List;)V", "updateWanderer", "getTrades", "()Ljava/util/List;", "getWandererTrades", "TRADES", "Ljava/util/List;", "WANDERER_TRADES", "deltaboxlib-forge"})
public final class TradeRegistry {
    @NotNull
    private final List<VillagerTradeCodec> TRADES;
    @NotNull
    private final List<WandererTradeCodec> WANDERER_TRADES;

    public TradeRegistry(@NotNull String modId) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        this.TRADES = new ArrayList();
        this.WANDERER_TRADES = new ArrayList();
    }

    public final void addTrade(@NotNull VillagerTradeCodec trade) {
        Intrinsics.checkNotNullParameter((Object)trade, (String)"trade");
        this.TRADES.add(trade);
    }

    public final void addWanderer(@NotNull WandererTradeCodec trade) {
        Intrinsics.checkNotNullParameter((Object)trade, (String)"trade");
        this.WANDERER_TRADES.add(trade);
    }

    public final void updateTrades(@NotNull List<VillagerTradeCodec> trades) {
        Intrinsics.checkNotNullParameter(trades, (String)"trades");
        this.TRADES.clear();
        this.TRADES.addAll((Collection<VillagerTradeCodec>)trades);
    }

    public final void updateWanderer(@NotNull List<WandererTradeCodec> trades) {
        Intrinsics.checkNotNullParameter(trades, (String)"trades");
        this.WANDERER_TRADES.clear();
        this.WANDERER_TRADES.addAll((Collection<WandererTradeCodec>)trades);
    }

    @NotNull
    public final List<VillagerTradeCodec> getTrades() {
        return this.TRADES;
    }

    @NotNull
    public final List<WandererTradeCodec> getWandererTrades() {
        return this.WANDERER_TRADES;
    }
}

