/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.common.registrate.registry;

import com.dannbrown.deltaboxlib.mixin.woodType.WoodTypeMixin;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00070\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0019\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b0\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0010R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00070\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b0\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/registry/WoodTypeRegistry;", "", "", "modId", "<init>", "(Ljava/lang/String;)V", "name", "Lnet/minecraft/world/level/block/state/properties/BlockSetType;", "addBlockSet", "(Ljava/lang/String;)Lnet/minecraft/world/level/block/state/properties/BlockSetType;", "blockSet", "Lnet/minecraft/world/level/block/state/properties/WoodType;", "addWoodType", "(Ljava/lang/String;Lnet/minecraft/world/level/block/state/properties/BlockSetType;)Lnet/minecraft/world/level/block/state/properties/WoodType;", "", "getAllBlockSets", "()Ljava/util/Map;", "getAllWoodTypes", "Ljava/lang/String;", "getModId", "()Ljava/lang/String;", "", "blocksets", "Ljava/util/Map;", "woodTypes", "deltaboxlib-forge"})
public final class WoodTypeRegistry {
    @NotNull
    private final String modId;
    @NotNull
    private final Map<String, BlockSetType> blocksets;
    @NotNull
    private final Map<String, WoodType> woodTypes;

    public WoodTypeRegistry(@NotNull String modId) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        this.modId = modId;
        this.blocksets = new LinkedHashMap();
        this.woodTypes = new LinkedHashMap();
    }

    @NotNull
    public final String getModId() {
        return this.modId;
    }

    @NotNull
    public final BlockSetType addBlockSet(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        BlockSetType newBlockSet = new BlockSetType(this.modId + ":" + name);
        this.blocksets.put(name, newBlockSet);
        return newBlockSet;
    }

    @NotNull
    public final WoodType addWoodType(@NotNull String name, @NotNull BlockSetType blockSet) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)blockSet, (String)"blockSet");
        WoodType newWoodType = WoodTypeMixin.invokeRegister(new WoodType(this.modId + ":" + name, blockSet));
        this.woodTypes.put(name, newWoodType);
        Intrinsics.checkNotNull((Object)newWoodType);
        return newWoodType;
    }

    @NotNull
    public final Map<String, BlockSetType> getAllBlockSets() {
        return this.blocksets;
    }

    @NotNull
    public final Map<String, WoodType> getAllWoodTypes() {
        return this.woodTypes;
    }
}

