/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.common.registrate.util;

import com.dannbrown.deltaboxlib.common.registrate.util.DeltaboxUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.management.BadAttributeValueExpException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 $2\u00020\u0001:\u0002%$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0017\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0007B\u001d\b\u0016\u0012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\t\u00a2\u0006\u0004\b\u0002\u0010\u000bB\u001d\b\u0016\u0012\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\b\"\u00020\f\u00a2\u0006\u0004\b\u0002\u0010\rJ\r\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0013\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u0011\u00a2\u0006\u0004\b\u0016\u0010\u0013J\r\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u001aR\u001e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u001bR\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001aR\"\u0010\u001e\u001a\u00020\u001d8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006&"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/util/DataIngredient;", "", "<init>", "()V", "Lnet/minecraft/tags/TagKey;", "Lnet/minecraft/world/item/Item;", "_tag", "(Lnet/minecraft/tags/TagKey;)V", "", "Lnet/minecraft/world/level/ItemLike;", "_items", "([Lnet/minecraft/world/level/ItemLike;)V", "Lnet/minecraft/world/item/ItemStack;", "([Lnet/minecraft/world/item/ItemStack;)V", "Lnet/minecraft/world/item/crafting/Ingredient;", "ingredient", "()Lnet/minecraft/world/item/crafting/Ingredient;", "", "items", "()Ljava/util/List;", "tag", "()Lnet/minecraft/tags/TagKey;", "itemStacks", "Lnet/minecraft/advancements/critereon/InventoryChangeTrigger$TriggerInstance;", "getTrigger", "()Lnet/minecraft/advancements/critereon/InventoryChangeTrigger$TriggerInstance;", "Ljava/util/List;", "Lnet/minecraft/tags/TagKey;", "itemstacks", "Lcom/dannbrown/deltaboxlib/common/registrate/util/DataIngredient$Type;", "type", "Lcom/dannbrown/deltaboxlib/common/registrate/util/DataIngredient$Type;", "getType", "()Lcom/dannbrown/deltaboxlib/common/registrate/util/DataIngredient$Type;", "setType", "(Lcom/dannbrown/deltaboxlib/common/registrate/util/DataIngredient$Type;)V", "Companion", "Type", "deltaboxlib-forge"})
@SourceDebugExtension(value={"SMAP\nDataIngredient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataIngredient.kt\ncom/dannbrown/deltaboxlib/common/registrate/util/DataIngredient\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,126:1\n37#2,2:127\n37#2,2:129\n37#2,2:131\n37#2,2:133\n*S KotlinDebug\n*F\n+ 1 DataIngredient.kt\ncom/dannbrown/deltaboxlib/common/registrate/util/DataIngredient\n*L\n46#1:127,2\n48#1:129,2\n65#1:131,2\n67#1:133,2\n*E\n"})
public final class DataIngredient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<ItemLike> items;
    @Nullable
    private TagKey<Item> tag;
    @NotNull
    private List<ItemStack> itemstacks;
    public Type type;

    public DataIngredient() {
        this.items = new ArrayList();
        this.itemstacks = new ArrayList();
    }

    @NotNull
    public final Type getType() {
        Type type2 = this.type;
        if (type2 != null) {
            return type2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"type");
        return null;
    }

    public final void setType(@NotNull Type type2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"<set-?>");
        this.type = type2;
    }

    public DataIngredient(@NotNull TagKey<Item> _tag) {
        Intrinsics.checkNotNullParameter(_tag, (String)"_tag");
        this();
        this.tag = _tag;
        this.setType(Type.TAG);
    }

    public DataIngredient(ItemLike ... _items) {
        Intrinsics.checkNotNullParameter((Object)_items, (String)"_items");
        this();
        CollectionsKt.addAll((Collection)this.items, (Object[])_items);
        this.setType(Type.ITEM);
    }

    public DataIngredient(ItemStack ... _items) {
        Intrinsics.checkNotNullParameter((Object)_items, (String)"_items");
        this();
        CollectionsKt.addAll((Collection)this.itemstacks, (Object[])_items);
        this.setType(Type.ITEMSTACK);
    }

    @NotNull
    public final Ingredient ingredient() {
        Ingredient ingredient;
        if (!((Collection)this.items).isEmpty()) {
            Collection $this$toTypedArray$iv = this.items;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ItemLike[] itemLikeArray = thisCollection$iv.toArray(new ItemLike[0]);
            Ingredient ingredient2 = Ingredient.m_43929_((ItemLike[])Arrays.copyOf(itemLikeArray, itemLikeArray.length));
            ingredient = ingredient2;
            Intrinsics.checkNotNullExpressionValue((Object)ingredient2, (String)"of(...)");
        } else if (this.tag != null) {
            TagKey<Item> tagKey = this.tag;
            Intrinsics.checkNotNull(tagKey);
            Ingredient ingredient3 = Ingredient.m_204132_(tagKey);
            ingredient = ingredient3;
            Intrinsics.checkNotNullExpressionValue((Object)ingredient3, (String)"of(...)");
        } else if (!((Collection)this.itemstacks).isEmpty()) {
            Collection $this$toTypedArray$iv = this.itemstacks;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ItemStack[] itemStackArray = thisCollection$iv.toArray(new ItemStack[0]);
            Ingredient ingredient4 = Ingredient.m_43927_((ItemStack[])Arrays.copyOf(itemStackArray, itemStackArray.length));
            ingredient = ingredient4;
            Intrinsics.checkNotNullExpressionValue((Object)ingredient4, (String)"of(...)");
        } else {
            Ingredient ingredient5 = Ingredient.f_43901_;
            ingredient = ingredient5;
            Intrinsics.checkNotNullExpressionValue((Object)ingredient5, (String)"EMPTY");
        }
        return ingredient;
    }

    @NotNull
    public final List<ItemLike> items() {
        return this.items;
    }

    @Nullable
    public final TagKey<Item> tag() {
        return this.tag;
    }

    @NotNull
    public final List<ItemStack> itemStacks() {
        return this.itemstacks;
    }

    @NotNull
    public final InventoryChangeTrigger.TriggerInstance getTrigger() {
        InventoryChangeTrigger.TriggerInstance triggerInstance;
        if (!((Collection)this.items).isEmpty()) {
            Collection $this$toTypedArray$iv = this.items;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ItemLike[] itemLikeArray = thisCollection$iv.toArray(new ItemLike[0]);
            triggerInstance = Companion.getTriggerFromItems(Arrays.copyOf(itemLikeArray, itemLikeArray.length));
        } else if (this.tag != null) {
            TagKey<Item> tagKey = this.tag;
            Intrinsics.checkNotNull(tagKey);
            triggerInstance = Companion.getTriggerFromTag(tagKey);
        } else if (!((Collection)this.itemstacks).isEmpty()) {
            Collection $this$toTypedArray$iv = this.itemstacks;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ItemStack[] itemStackArray = thisCollection$iv.toArray(new ItemStack[0]);
            triggerInstance = Companion.getTriggerFromItemStacks(Arrays.copyOf(itemStackArray, itemStackArray.length));
        } else {
            throw new BadAttributeValueExpException((Object)"DataIngredient is empty, can't create a trigger");
        }
        return triggerInstance;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\b\u001a\u00020\u00072\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ!\u0010\f\u001a\u00020\u00072\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0004\"\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u0011\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001b\u0010\u0014\u001a\u00020\u00132\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0014\u0010\u0015J;\u0010\u001f\u001a\u00020\u001e\"\b\b\u0000\u0010\u0017*\u00020\u00162\u0006\u0010\u0018\u001a\u00028\u00002\u0012\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00192\u0006\u0010\u001d\u001a\u00020\u0013\u00a2\u0006\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/util/DataIngredient$Companion;", "", "<init>", "()V", "", "Lnet/minecraft/world/level/ItemLike;", "items", "Lnet/minecraft/advancements/critereon/InventoryChangeTrigger$TriggerInstance;", "getTriggerFromItems", "([Lnet/minecraft/world/level/ItemLike;)Lnet/minecraft/advancements/critereon/InventoryChangeTrigger$TriggerInstance;", "Lnet/minecraft/world/item/ItemStack;", "itemstacks", "getTriggerFromItemStacks", "([Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/advancements/critereon/InventoryChangeTrigger$TriggerInstance;", "Lnet/minecraft/tags/TagKey;", "Lnet/minecraft/world/item/Item;", "tag", "getTriggerFromTag", "(Lnet/minecraft/tags/TagKey;)Lnet/minecraft/advancements/critereon/InventoryChangeTrigger$TriggerInstance;", "", "getTagCriterionName", "(Lnet/minecraft/tags/TagKey;)Ljava/lang/String;", "Lnet/minecraft/data/recipes/RecipeBuilder;", "T", "builder", "", "Ljava/util/function/Supplier;", "Lcom/dannbrown/deltaboxlib/common/registrate/util/DataIngredient;", "ingredients", "recipeName", "", "addIngredientsRecipeCriterions", "(Lnet/minecraft/data/recipes/RecipeBuilder;Ljava/util/List;Ljava/lang/String;)V", "deltaboxlib-forge"})
    @SourceDebugExtension(value={"SMAP\nDataIngredient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataIngredient.kt\ncom/dannbrown/deltaboxlib/common/registrate/util/DataIngredient$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n11165#2:127\n11500#2,3:128\n11165#2:133\n11500#2,3:134\n37#3,2:131\n37#3,2:137\n37#3,2:143\n1557#4:139\n1628#4,3:140\n*S KotlinDebug\n*F\n+ 1 DataIngredient.kt\ncom/dannbrown/deltaboxlib/common/registrate/util/DataIngredient$Companion\n*L\n73#1:127\n73#1:128,3\n77#1:133\n77#1:134,3\n73#1:131,2\n77#1:137,2\n112#1:143,2\n109#1:139\n109#1:140,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final InventoryChangeTrigger.TriggerInstance getTriggerFromItems(ItemLike ... items) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)items, (String)"items");
            ItemLike[] $this$map$iv = items;
            boolean $i$f$map = false;
            ItemLike[] itemLikeArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var11_10 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.m_5456_());
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Item[] itemArray = thisCollection$iv.toArray(new Item[0]);
            InventoryChangeTrigger.TriggerInstance triggerInstance = InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])((ItemLike[])Arrays.copyOf(itemArray, itemArray.length)));
            Intrinsics.checkNotNullExpressionValue((Object)triggerInstance, (String)"hasItems(...)");
            return triggerInstance;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final InventoryChangeTrigger.TriggerInstance getTriggerFromItemStacks(ItemStack ... itemstacks) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)itemstacks, (String)"itemstacks");
            ItemStack[] $this$map$iv = itemstacks;
            boolean $i$f$map = false;
            ItemStack[] itemStackArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var11_10 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.m_41720_());
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Item[] itemArray = thisCollection$iv.toArray(new Item[0]);
            InventoryChangeTrigger.TriggerInstance triggerInstance = InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])((ItemLike[])Arrays.copyOf(itemArray, itemArray.length)));
            Intrinsics.checkNotNullExpressionValue((Object)triggerInstance, (String)"hasItems(...)");
            return triggerInstance;
        }

        @NotNull
        public final InventoryChangeTrigger.TriggerInstance getTriggerFromTag(@NotNull TagKey<Item> tag) {
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
            ItemPredicate[] itemPredicateArray = new ItemPredicate[]{new ItemPredicate(tag, null, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, EnchantmentPredicate.f_30465_, EnchantmentPredicate.f_30465_, null, NbtPredicate.f_57471_)};
            InventoryChangeTrigger.TriggerInstance triggerInstance = InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])itemPredicateArray);
            Intrinsics.checkNotNullExpressionValue((Object)triggerInstance, (String)"hasItems(...)");
            return triggerInstance;
        }

        @NotNull
        public final String getTagCriterionName(@NotNull TagKey<Item> tag) {
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
            String string = tag.f_203868_().m_135815_();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String tagname = DeltaboxUtil.INSTANCE.asId(StringsKt.replace$default((String)string, (String)"/", (String)"_", (boolean)false, (int)4, null));
            return "has_" + tag.f_203868_().m_135827_() + "_" + tagname;
        }

        /*
         * WARNING - void declaration
         */
        public final <T extends RecipeBuilder> void addIngredientsRecipeCriterions(@NotNull T builder, @NotNull List<? extends Supplier<DataIngredient>> ingredients, @NotNull String recipeName) {
            Intrinsics.checkNotNullParameter(builder, (String)"builder");
            Intrinsics.checkNotNullParameter(ingredients, (String)"ingredients");
            Intrinsics.checkNotNullParameter((Object)recipeName, (String)"recipeName");
            List itemIngredients = new ArrayList();
            for (Supplier<DataIngredient> supplier : ingredients) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                if (supplier.get().getType() == Type.ITEM) {
                    itemIngredients.addAll((Collection)supplier.get().items());
                }
                if (supplier.get().getType() != Type.ITEMSTACK) continue;
                Iterable iterable = supplier.get().itemStacks();
                List list = itemIngredients;
                boolean $i$f$map = false;
                void var9_17 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ItemStack itemStack = (ItemStack)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.m_41720_());
                }
                list.addAll((List)destination$iv$iv);
            }
            if (!((Collection)itemIngredients).isEmpty()) {
                Collection collection = itemIngredients;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = collection;
                ItemLike[] itemLikeArray = thisCollection$iv.toArray(new ItemLike[0]);
                builder.m_126132_("has_ingredients", (CriterionTriggerInstance)Companion.getTriggerFromItems(Arrays.copyOf(itemLikeArray, itemLikeArray.length)));
            }
            for (Supplier<DataIngredient> supplier : ingredients) {
                RecipeBuilder recipeBuilder;
                TagKey<Item> tag;
                if (supplier.get().getType() != Type.TAG || supplier.get().tag() == null) continue;
                try {
                    recipeBuilder = builder.m_126132_(Companion.getTagCriterionName(tag), (CriterionTriggerInstance)Companion.getTriggerFromTag(tag));
                }
                catch (Throwable e) {
                    System.out.println((Object)("Possible duplicate criterion '" + Companion.getTagCriterionName(tag) + "' for recipe '" + recipeName + "', skipping..."));
                    recipeBuilder = Unit.INSTANCE;
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/dannbrown/deltaboxlib/common/registrate/util/DataIngredient$Type;", "", "<init>", "(Ljava/lang/String;I)V", "ITEM", "TAG", "ITEMSTACK", "deltaboxlib-forge"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type ITEM = new Type();
        public static final /* enum */ Type TAG = new Type();
        public static final /* enum */ Type ITEMSTACK = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.ITEM, Type.TAG, Type.ITEMSTACK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

