/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib;

import com.google.common.base.Suppliers;
import com.google.gson.Gson;
import com.mojang.brigadier.CommandDispatcher;
import de.mrjulsen.mcdragonlib.DragonLibCrossPlatform;
import de.mrjulsen.mcdragonlib.client.DLOverlayManager;
import de.mrjulsen.mcdragonlib.commands.DebugCommand;
import de.mrjulsen.mcdragonlib.internal.ClientWrapper;
import de.mrjulsen.mcdragonlib.internal.DragonLibBlock;
import de.mrjulsen.mcdragonlib.internal.DragonLibBlockEntity;
import de.mrjulsen.mcdragonlib.internal.DragonLibBlockEntityRenderer;
import de.mrjulsen.mcdragonlib.network.DLNetworkManager;
import de.mrjulsen.mcdragonlib.network.NetworkDirection;
import de.mrjulsen.mcdragonlib.network.NetworkPacketType;
import de.mrjulsen.mcdragonlib.network.builtin.WritableSignPacketData;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.ScheduledTask;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.platform.Mod;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.utils.Env;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DragonLib {
    public static final String MODID = "dragonlib";
    public static final String MOD_NAME = "DragonLib";
    public static final String MRJULSEN_DISCORD = "https://server.mrjulsen.net";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"DragonLib");
    public static final Random RANDOM = new Random();
    public static final Gson GSON = new Gson();
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat();
    public static final float BLOCK_PIXEL = 0.0625f;
    public static final ResourceLocation DRAGONLIB_UI = DLUtils.resourceLocation("dragonlib", "textures/gui/ui.png");
    public static final ResourceLocation VANILLA_WIDGETS = DLUtils.resourceLocation("minecraft:textures/gui/widgets.png");
    public static final DLColor VANILLA_UI_FONT_COLOR = DLColor.fromInt(-12566464);
    public static final DLColor VANILLA_BUTTON_ACTIVE_FONT_COLOR = DLColor.WHITE;
    public static final DLColor VANILLA_BUTTON_DISABLED_FONT_COLOR = DLColor.fromInt(-6381922);
    public static final DLColor VANILLA_BUTTON_HIGHLIGHTED_FONT_COLOR = DLColor.fromInt(-96);
    public static final DLColor WINDOW_COLOR_DARK = DLColor.fromInt(-13619152);
    public static final DLColor BUTTON_COLOR_DEFAULT_DARK = DLColor.fromInt(-12040120);
    public static final DLColor BUTTON_COLOR_DEFAULT_LIGHT = DLColor.fromInt(-7829368);
    public static final DLColor BUTTON_COLOR_PRIMARY = DLColor.fromInt(-15371546);
    public static final DLColor BUTTON_COLOR_ACCEPT = DLColor.fromInt(-15879603);
    public static final DLColor BUTTON_COLOR_CANCEL = DLColor.fromInt(-1556915);
    public static final DLColor BUTTON_COLOR_CAUTION = DLColor.fromInt(-1524418);
    public static final Supplier<RegistrarManager> MANAGER = Suppliers.memoize(() -> RegistrarManager.get((String)MODID));
    private static final Registrar<Item> ITEMS = MANAGER.get().get(Registries.f_256913_);
    private static final Registrar<Block> BLOCKS = MANAGER.get().get(Registries.f_256747_);
    private static final Registrar<BlockEntityType<?>> BLOCK_ENTITIES = MANAGER.get().get(Registries.f_256922_);
    public static final RegistrySupplier<Block> DRAGON_BLOCK = DragonLib.registerBlock("dragon", () -> new DragonLibBlock(BlockBehaviour.Properties.m_284310_().m_60978_(1.5f)));
    public static final RegistrySupplier<BlockEntityType<DragonLibBlockEntity>> DRAGONLIB_BLOCK_ENTITY = BLOCK_ENTITIES.register(DLUtils.resourceLocation("dragonlib", "dragonlib_block_entity"), () -> BlockEntityType.Builder.m_155273_(DragonLibBlockEntity::new, (Block[])new Block[]{(Block)DRAGON_BLOCK.get()}).m_58966_(null));
    public static final DLNetworkManager DRAGONLIB_NETWORK = new DLNetworkManager(DLUtils.resourceLocation("dragonlib", "network"), "14");
    public static final NetworkPacketType.Send<NetworkDirection.C2S, WritableSignPacketData> UPDATE_SIGN_TEXT = DRAGONLIB_NETWORK.registerSendOnlyPacket("update_writable_sign", NetworkDirection.C2S, WritableSignPacketData::handler, WritableSignPacketData::new);
    private static MinecraftServer currentServer;
    private static boolean initialized;
    public static ShaderInstance EXAMPLE_SHADER;

    private static <T extends Block, I extends BlockItem> RegistrySupplier<T> registerBlock(String name, Supplier<T> block) {
        RegistrySupplier toReturn = BLOCKS.register(DLUtils.resourceLocation(MODID, name), block);
        DragonLib.registerBlockItem(name, toReturn, DragonLibBlock.DragonLibItem.class);
        return toReturn;
    }

    private static <T extends Block, I extends BlockItem> RegistrySupplier<Item> registerBlockItem(String name, RegistrySupplier<T> block, Class<I> blockItemClass) {
        return ITEMS.register(DLUtils.resourceLocation(MODID, name), () -> {
            try {
                return (Item)blockItemClass.getDeclaredConstructor(Block.class, Item.Properties.class).newInstance(block.get(), new Item.Properties());
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.error("Unable to register block item '" + name + "'.", (Throwable)e);
                return new BlockItem((Block)block.get(), new Item.Properties());
            }
        });
    }

    public static void init() {
        if (initialized) {
            throw new IllegalAccessError("Prohibited to init DragonLib manually!");
        }
        initialized = true;
        DragonLibCrossPlatform.registerConfig();
        if (Platform.getEnv() == Dist.CLIENT) {
            ClientLifecycleEvent.CLIENT_SETUP.register(mc -> BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)DRAGONLIB_BLOCK_ENTITY.get()), DragonLibBlockEntityRenderer::new));
            DLOverlayManager.init();
        }
        TickEvent.Server.SERVER_POST.register(server -> ScheduledTask.runScheduledTasks());
        LifecycleEvent.SERVER_STARTED.register(server -> {
            currentServer = server;
        });
        LifecycleEvent.SERVER_STOPPED.register(server -> {
            currentServer = null;
        });
        LifecycleEvent.SERVER_STOPPING.register(server -> ScheduledTask.cancelAllTasks());
        CommandRegistrationEvent.EVENT.register((dispatcher, context, selection) -> DebugCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, selection));
        DragonLib.printDraconicWelcomeMessage();
    }

    public static boolean hasServer() {
        return currentServer != null;
    }

    public static Optional<MinecraftServer> getCurrentServer() {
        return Optional.ofNullable(currentServer);
    }

    public static Level getPhysicalLevel() {
        return DragonLib.hasServer() ? DragonLib.getCurrentServer().get().m_129783_() : ClientWrapper.getClientLevel();
    }

    public static long getCurrentWorldTime() {
        Level level = DragonLib.getPhysicalLevel();
        return level == null ? 0L : level.m_46468_();
    }

    private static final void printDraconicWelcomeMessage() {
        String[] dragonTypes = new String[]{"Dragon", "Fire Dragon", "Ice Dragon", "Lightning Dragon", "Mountain Dragon", "Poison Dragon", "Drake", "Wyvern", "MrJulsen", "Toothless", "Drogon", "Smaug", "Ender Dragon", "Do you think dragons exist?", "Here be Dragons!"};
        LOGGER.info("Starting the setup of DragonLib...");
        new Thread(() -> {
            Mod mod = Platform.getMod((String)MODID);
            ArrayList<Object> lines = new ArrayList<String>();
            String border = "+++ \ud83d\udc09 +++";
            lines.add(border);
            lines.add(String.format("Loaded %s v%s by MrJulsen!", mod.getName(), mod.getVersion()));
            Object[] objectArray = new Object[5];
            Object object = Platform.isForge() ? "Forge" : (objectArray[0] = Platform.isFabric() ? "Fabric" : "");
            objectArray[1] = Platform.getEnvironment() == Env.CLIENT ? "Client" : (Platform.getEnvironment() == Env.SERVER ? "Server" : "?");
            objectArray[2] = Platform.getMinecraftVersion();
            objectArray[3] = DragonLib.getModloaderVersion();
            objectArray[4] = Platform.isDevelopmentEnvironment() ? " (Dev)" : "";
            lines.add(String.format("Minecraft %s %s %s%s%s", objectArray));
            lines.add("");
            lines.add(String.format("Discord: %s", MRJULSEN_DISCORD));
            lines.add(String.format("GitHub: %s", mod.getHomepage().orElse("unknown")));
            lines.add(String.format("Bug Reports: %s", mod.getIssueTracker().orElse("unknown")));
            lines.add(border);
            int width = lines.stream().mapToInt(String::length).max().getAsInt() + 4;
            lines = new ArrayList<String>(lines.stream().map(x -> DragonLib.centerStringInArea(x, width)).toList());
            lines.add(1, DragonLib.lineOf('-', width));
            lines.add(lines.size() - 1, DragonLib.lineOf('-', width));
            lines.forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
        }, dragonTypes[RANDOM.nextInt(dragonTypes.length)]).start();
    }

    private static final String centerStringInArea(String text, int width) {
        if (text.isBlank()) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text);
        int verLength = sb.length();
        for (int i = 0; i < (width - verLength) / 2; ++i) {
            sb.insert(0, " ");
            sb.append(" ");
        }
        return sb.toString();
    }

    private static final String lineOf(char c, int width) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < width; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    private static String getModloaderVersion() {
        if (Platform.isForge()) {
            return Platform.getOptionalMod((String)"forge").map(x -> "-" + x.getVersion()).orElse("");
        }
        if (Platform.isFabric()) {
            return Platform.getOptionalMod((String)"fabric").map(x -> "-" + x.getVersion()).orElse("");
        }
        return "";
    }

    static {
        initialized = false;
    }
}

