/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.builtin;

import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindow;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLColorPicker;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLComboBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLCycleButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLNumberPicker;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.EAlign;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.INumberFormatAdapter;
import de.mrjulsen.mcdragonlib.client.render.DefaultGuiTextures;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.data.ITranslatableEnum;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.properties.ColorProperty;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.FormattedText;

public class DLColorPickerWindow
extends DLWindow {
    private static final int WINDOW_PADDING = 8;
    private final DLColorPicker picker;
    private final DLComboBox<ColorSpace> colorSpace;
    private final DLNumberPicker r;
    private final DLNumberPicker g;
    private final DLNumberPicker b;
    private final DLNumberPicker a;
    private final DLNumberPicker hex;
    private boolean skipValueUpdate = false;
    private final boolean showAlpha;
    private final DLColor initialColor;

    public DLColorPickerWindow(DLWindowManager manager, boolean showAlpha, DLColor initialColor, Consumer<DLColor> onAccept) {
        super(manager);
        this.showAlpha = showAlpha;
        this.initialColor = initialColor;
        this.movable.set(true);
        this.windowSpawnPosition.set(DLWindow.WindowPosition.PARENT_CENTER);
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        this.picker = new DLColorPicker(8, 16 + 9, 120, 120 + 14 * (showAlpha ? 2 : 1));
        this.picker.sliderAlign.set(EAlign.BOTTOM);
        this.picker.showAlphaSlider.set(false);
        this.picker.color.set(initialColor.isUndefined() ? DLColor.WHITE : initialColor);
        this.addComponent(this.picker);
        this.colorSpace = new DLComboBox(this.picker.x() + this.picker.width() + 5, this.picker.y() + 30, 60, 16);
        this.colorSpace.items.addAll(ColorSpace.values());
        this.colorSpace.addEventListener(DLCycleButton.SelectedItemChanged.class, (s, e) -> {
            this.updateInputBoxes();
            return false;
        });
        this.addComponent(this.colorSpace);
        this.r = new DLNumberPicker(this.colorSpace.x(), this.colorSpace.y() + this.colorSpace.height() + 2, this.colorSpace.width(), this.colorSpace.height());
        this.r.showButtons.set(false);
        this.r.max.set(255.0);
        this.r.format.set(new INumberFormatAdapter.DecimalNumberFormat(0));
        this.r.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
            if (this.skipValueUpdate) {
                return false;
            }
            this.skipValueUpdate = true;
            DLColor color = this.picker.color.get();
            ((Optional)this.colorSpace.selectedItem.get()).ifPresent(c -> {
                ColorProperty colorProperty = this.picker.color;
                colorProperty.set(switch (c.ordinal()) {
                    case 1 -> DLColor.fromHsv(((Double)this.r.value.get()).floatValue(), color.getSaturation(), color.getBrightness()).withAlpha(color.getAlpha());
                    default -> DLColor.of(color.getAlpha(), (int)e.value(), color.getGreen(), color.getBlue());
                });
            });
            this.skipValueUpdate = false;
            return false;
        });
        this.addComponent(this.r);
        this.g = new DLNumberPicker(this.r.x(), this.r.y() + this.r.height() + 2, this.r.width(), this.r.height());
        this.g.showButtons.set(false);
        this.g.max.set(255.0);
        this.g.format.set(new INumberFormatAdapter.DecimalNumberFormat(0));
        this.g.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
            if (this.skipValueUpdate) {
                return false;
            }
            this.skipValueUpdate = true;
            DLColor color = this.picker.color.get();
            ((Optional)this.colorSpace.selectedItem.get()).ifPresent(c -> {
                ColorProperty colorProperty = this.picker.color;
                colorProperty.set(switch (c.ordinal()) {
                    case 1 -> DLColor.fromHsv(color.getHue(), ((Double)this.g.value.get()).floatValue() / 100.0f, color.getBrightness()).withAlpha(color.getAlpha());
                    default -> DLColor.of(color.getAlpha(), color.getRed(), (int)e.value(), color.getBlue());
                });
            });
            this.skipValueUpdate = false;
            return false;
        });
        this.addComponent(this.g);
        this.b = new DLNumberPicker(this.g.x(), this.g.y() + this.g.height() + 2, this.g.width(), this.g.height());
        this.b.showButtons.set(false);
        this.b.max.set(255.0);
        this.b.format.set(new INumberFormatAdapter.DecimalNumberFormat(0));
        this.b.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
            if (this.skipValueUpdate) {
                return false;
            }
            this.skipValueUpdate = true;
            DLColor color = this.picker.color.get();
            ((Optional)this.colorSpace.selectedItem.get()).ifPresent(c -> {
                ColorProperty colorProperty = this.picker.color;
                colorProperty.set(switch (c.ordinal()) {
                    case 1 -> DLColor.fromHsv(color.getHue(), color.getSaturation(), ((Double)this.b.value.get()).floatValue() / 100.0f).withAlpha(color.getAlpha());
                    default -> DLColor.of(color.getAlpha(), color.getGreen(), color.getGreen(), (int)e.value());
                });
            });
            this.skipValueUpdate = false;
            return false;
        });
        this.addComponent(this.b);
        this.a = new DLNumberPicker(this.b.x(), this.b.y() + this.b.height() + 2, this.b.width(), this.b.height());
        if (showAlpha) {
            this.a.showButtons.set(false);
            this.a.max.set(100.0);
            this.a.format.set(new INumberFormatAdapter.UnitNumberFormat(0, "%"));
            this.a.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
                if (this.skipValueUpdate) {
                    return false;
                }
                this.skipValueUpdate = true;
                DLColor color = this.picker.color.get();
                this.picker.color.set(color.withAlpha((int)(e.value() / 100.0 * 255.0)));
                this.skipValueUpdate = false;
                return false;
            });
            this.addComponent(this.a);
        }
        this.hex = new DLNumberPicker(this.b.x(), this.picker.y() + this.picker.height() - this.b.height(), this.b.width(), this.b.height());
        this.hex.showButtons.set(false);
        this.hex.min.set(-2.147483648E9);
        this.hex.max.set(2.147483647E9);
        this.hex.format.set(new INumberFormatAdapter.HexARGBColorFormat(showAlpha));
        this.hex.addEventListener(DLNumberPicker.ValueChangedEvent.class, (s, e) -> {
            if (this.skipValueUpdate) {
                return false;
            }
            this.skipValueUpdate = true;
            this.picker.color.set(DLColor.fromInt(((Double)this.hex.value.get()).intValue()));
            this.skipValueUpdate = false;
            return false;
        });
        this.addComponent(this.hex);
        int windowWidth = 8 + this.colorSpace.x() + this.colorSpace.width();
        DLButton doneBtn = new DLButton(8, this.picker.y() + this.picker.height() + 8, windowWidth / 2 - 8 - 2, 16);
        doneBtn.text.set(CommonComponents.f_130655_);
        doneBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            onAccept.accept(this.picker.color.get());
            manager.closeWindow(this);
            return false;
        });
        this.addComponent(doneBtn);
        DLButton cancelBtn = new DLButton(windowWidth / 2 + 2, this.picker.y() + this.picker.height() + 8, windowWidth / 2 - 8 - 2, 16);
        cancelBtn.text.set(CommonComponents.f_130656_);
        cancelBtn.addEventListener(DLGuiStandardEvents.ClickEvent.class, (s, e) -> {
            manager.closeWindow(this);
            return false;
        });
        this.addComponent(cancelBtn);
        this.setSize(windowWidth, doneBtn.y() + doneBtn.height() + 8);
        this.picker.addEventListener(DLColorPicker.ColorChangedEvent.class, (s, e) -> {
            this.skipValueUpdate = true;
            this.updateInputBoxes();
            this.skipValueUpdate = false;
            return false;
        });
        this.updateInputBoxes();
    }

    private void updateInputBoxes() {
        ((Optional)this.colorSpace.selectedItem.get()).ifPresent(x -> {
            switch (x.ordinal()) {
                case 1: {
                    this.r.max.set(360.0);
                    this.r.value.set(Double.valueOf(this.picker.color.get().getHue()));
                    this.g.max.set(100.0);
                    this.g.value.set((double)this.picker.color.get().getSaturation() * 100.0);
                    this.b.max.set(100.0);
                    this.b.value.set((double)this.picker.color.get().getBrightness() * 100.0);
                    break;
                }
                default: {
                    this.r.max.set(255.0);
                    this.r.value.set(Double.valueOf(this.picker.color.get().getRed()));
                    this.g.max.set(255.0);
                    this.g.value.set(Double.valueOf(this.picker.color.get().getGreen()));
                    this.b.max.set(255.0);
                    this.b.value.set(Double.valueOf(this.picker.color.get().getBlue()));
                }
            }
        });
        this.a.value.set((double)this.picker.color.get().getAlphaF() * 100.0);
        this.hex.value.set(Double.valueOf(this.picker.color.get().getAsARGB()));
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        DefaultGuiTextures.DRAGONLIB_UI.getSprite("window_rounded").render(graphics, 0, 0, this.width(), this.height());
        DefaultGuiTextures.DRAGONLIB_UI.getSprite("slot").render(graphics, this.picker.x() + this.picker.width() + 5, this.picker.y(), 60, 24);
        if (this.showAlpha) {
            DefaultGuiTextures.DRAGONLIB_UI.getSprite("transparency").render(graphics, this.picker.x() + this.picker.width() + 6, this.picker.y() + 1, 58, 22);
        }
        if (this.initialColor.isUndefined()) {
            GuiUtils.fill(graphics, this.picker.x() + this.picker.width() + 6, this.picker.y() + 1, 58, 22, this.picker.color.get());
        } else {
            GuiUtils.fill(graphics, this.picker.x() + this.picker.width() + 6, this.picker.y() + 1, 29, 22, this.picker.color.get());
            GuiUtils.fill(graphics, this.picker.x() + this.picker.width() + 6 + 29, this.picker.y() + 1, 29, 22, this.initialColor);
        }
        GuiUtils.drawString(graphics, graphics.defaultFont(), 8, 8, (FormattedText)TextUtils.translate("gui.dragonlib.colorpicker.title"), DragonLib.VANILLA_UI_FONT_COLOR, ETextAlignment.LEFT, false);
    }

    private static enum ColorSpace implements ITranslatableEnum
    {
        RGB("rgb"),
        HSV("hsv");

        private final String name;

        private ColorSpace(String name) {
            this.name = name;
        }

        @Override
        public ITranslatableEnum.Data getTranslationData() {
            return new ITranslatableEnum.Data("dragonlib", "color_space", this.m_7912_());
        }

        public String toString() {
            return this.name;
        }
    }
}

