/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.events;

import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.LayoutResult;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.RenderLayer;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.events.IEvent;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.mutable.MutableBoolean;

public final class DLGuiStandardEvents {
    private DLGuiStandardEvents() {
    }

    @IEvent.NotCancellable
    public record CloseEvent() implements IEvent
    {
    }

    public record RenderOnScreenEvent(DLGuiGraphics graphics, double mouseX, double mouseY) implements IEvent
    {
    }

    public record RenderPostEvent(DLGuiGraphics graphics, double mouseX, double mouseY, RenderLayer layer, Rectangle renderBounds) implements IEvent
    {
    }

    public record RenderEvent(DLGuiGraphics graphics, double mouseX, double mouseY, RenderLayer layer, Rectangle renderBounds) implements IEvent
    {
    }

    public record RenderPreEvent(DLGuiGraphics graphics, double mouseX, double mouseY, RenderLayer layer, Rectangle renderBounds) implements IEvent
    {
    }

    @IEvent.NotCancellable
    public record WindowManagerChangeEvent(DLWindowManager oldWindowManager, DLWindowManager newWindowManager) implements IEvent
    {
    }

    public record ParentChangedEvent(Optional<DLGuiComponent> oldParent, Optional<DLGuiComponent> newParent) implements IEvent
    {
    }

    public record ComponentsClearEvent(IEvent.Phase order, MutableBoolean cancel) implements IEvent
    {
    }

    @IEvent.NotCancellable
    public record ComponentLayoutUpdatedEvent(LayoutResult layoutResult) implements IEvent
    {
    }

    @IEvent.NotCancellable
    public record ScreenLayoutUpdatedEvent(IEvent.Phase order) implements IEvent
    {
    }

    public record MovableChangedEvent(boolean movable) implements IEvent
    {
    }

    public record ResizableChangedEvent(boolean resizable) implements IEvent
    {
    }

    public record EnabledChangedEvent(boolean enabled) implements IEvent
    {
    }

    public record VisibilityChangedEvent(boolean visible) implements IEvent
    {
    }

    public record DragAndDropFilesEvent(List<Path> paths, double mouseX, double mouseY) implements IEvent
    {
    }

    public record DropComponentEvent(DLGuiComponent other, double mouseX, double mouseY) implements IEvent
    {
    }

    public record DraggingOverEvent(List<DLGuiComponent> other, double mouseX, double mouseY, int button) implements IEvent
    {
    }

    public record DragComponentOverEndEvent(List<DLGuiComponent> other, double mouseX, double mouseY, int button) implements IEvent
    {
    }

    public record DragComponentOverEvent(List<DLGuiComponent> other, double mouseX, double mouseY, int button) implements IEvent
    {
    }

    public record DragComponentOverBeginEvent(List<DLGuiComponent> other, double mouseX, double mouseY, int button) implements IEvent
    {
    }

    public record DragComponentEndEvent(double mouseX, double mouseY, int button, int newX, int newY, List<DLGuiComponent> draggedOverComponents, MutableBoolean cancel) implements IEvent
    {
    }

    public record DragComponentEvent(double mouseX, double mouseY, int button, int newX, int newY, double dragX, double dragY, List<DLGuiComponent> draggedOverComponents) implements IEvent
    {
    }

    public record DragComponentBeginEvent(double mouseX, double mouseY, int button, List<DLGuiComponent> draggedOverComponents) implements IEvent
    {
    }

    public record ComponentPosAndSizeChanged(int oldX, int newX, int oldY, int newY, int oldWidth, int newWidth, int oldHeight, int newHeight) implements IEvent
    {
        public boolean widthChanged() {
            return this.oldWidth != this.newWidth;
        }

        public boolean heightChanged() {
            return this.oldHeight != this.newHeight;
        }

        public boolean xChanged() {
            return this.oldX != this.newX;
        }

        public boolean yChanged() {
            return this.oldY != this.newY;
        }

        public boolean positionChanged() {
            return this.xChanged() || this.yChanged();
        }

        public boolean sizeChanged() {
            return this.widthChanged() || this.heightChanged();
        }
    }

    public record ResizeEndEvent(double mouseX, double mouseY, int newX, int newY, int newWidth, int newHeight, MutableBoolean cancel) implements IEvent
    {
    }

    public record ResizeEvent(double mouseX, double mouseY, int newX, int newY, int newWidth, int newHeight) implements IEvent
    {
    }

    public record ResizeBeginEvent(double mouseX, double mouseY) implements IEvent
    {
    }

    public record CharTypeEvent(char codePoint, int modifiers) implements IEvent
    {
    }

    public record KeyReleaseEvent(int keyCode, int scanCode, int modifiers) implements IEvent
    {
    }

    public record KeyPressEvent(int keyCode, int scanCode, int modifiers) implements IEvent
    {
    }

    public record DragEndEvent(double mouseX, double mouseY, int button, double screenMouseOriginX, double screenMouseOriginY, double localMouseOriginX, double localMouseOriginY) implements IEvent
    {
    }

    public record DragEvent(double mouseX, double mouseY, int button, double screenMouseOriginX, double screenMouseOriginY, double localMouseOriginX, double localMouseOriginY, double dragX, double dragY) implements IEvent
    {
    }

    public record DragBeginEvent(double mouseX, double mouseY, int button) implements IEvent
    {
    }

    public record FocusChangedEvent(boolean focus) implements IEvent
    {
    }

    public record ComponentRemovedEvent(DLGuiComponent child) implements IEvent
    {
    }

    public record ComponentAddedEvent(DLGuiComponent child) implements IEvent
    {
    }

    public record TickEvent() implements IEvent
    {
    }

    public record ScrollEvent(double mouseX, double mouseY, double deltaX, double deltaY) implements IEvent
    {
    }

    public record MultiClickEvent(double mouseX, double mouseY, int button, byte clickCount) implements IEvent
    {
    }

    public record RightClickEvent(double mouseX, double mouseY) implements IEvent
    {
    }

    public record ClickEvent(double mouseX, double mouseY) implements IEvent
    {
    }

    public record MousePressedEvent(double mouseX, double mouseY, int button) implements IEvent
    {
    }

    public record MouseReleaseEvent(double mouseX, double mouseY, int button) implements IEvent
    {
    }

    public record MouseMoveEvent(double mouseX, double mouseY) implements IEvent
    {
    }

    public record MouseLeaveEvent(double mouseX, double mouseY) implements IEvent
    {
    }

    public record MouseEnterEvent(double mouseX, double mouseY) implements IEvent
    {
    }

    public record MouseHoldDownEvent(double mouseX, double mouseY, int button, int ticks) implements IEvent
    {
    }

    public record MouseDownEvent(double mouseX, double mouseY, int button) implements IEvent
    {
    }
}

