/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.base;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.systems.RenderSystem;
import de.mrjulsen.mcdragonlib.annotations.SupportsEvents;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindow;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.IGuiManagementComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.ModalId;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.ModalWindowStack;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.WindowBuilder;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.CursorType;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.EAlign;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.HitResult;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.RenderLayer;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.events.EventListenerWrapper;
import de.mrjulsen.mcdragonlib.events.IEvent;
import de.mrjulsen.mcdragonlib.events.IEventDispatcher;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.apache.commons.lang3.mutable.MutableBoolean;

@SupportsEvents(value={DLGuiStandardEvents.ClickEvent.class, DLGuiStandardEvents.RightClickEvent.class, DLGuiStandardEvents.MousePressedEvent.class, DLGuiStandardEvents.MouseReleaseEvent.class, DLGuiStandardEvents.MouseMoveEvent.class, DLGuiStandardEvents.ScrollEvent.class, DLGuiStandardEvents.TickEvent.class, DLGuiStandardEvents.KeyPressEvent.class, DLGuiStandardEvents.KeyReleaseEvent.class, DLGuiStandardEvents.CharTypeEvent.class, DLGuiStandardEvents.RenderEvent.class})
public class DLWindowManager
implements IEventDispatcher<DLWindowManager>,
MenuAccess<AbstractContainerMenu> {
    public static final int DRAG_THRESHOLD = 5;
    private final Map<Class<? extends IEvent>, PriorityQueue<EventListenerWrapper<?>>> eventListeners = new HashMap();
    private DLGuiComponent focusedComponent = null;
    private final Set<DLGuiComponent> mouseDownComponents = new HashSet<DLGuiComponent>();
    private final Set<HitResult.ComponentHitContext> draggingComponents = new HashSet<HitResult.ComponentHitContext>();
    private final List<DLGuiComponent> dragOverComponents = new LinkedList<DLGuiComponent>();
    private final Queue<HitResult.ComponentHitContext> renderInputOverlayComponents = new ConcurrentLinkedQueue<HitResult.ComponentHitContext>();
    private final ConcurrentLinkedDeque<ModalWindowStack> windows = new ConcurrentLinkedDeque();
    private final PriorityQueue<IGuiManagementComponent> managementComponents = new PriorityQueue();
    private final Queue<Runnable> delayedTasks = new ConcurrentLinkedQueue<Runnable>();
    private boolean initialized = false;
    private final AbstractContainerMenu menu;
    private final WindowBuilder<? extends DLWindow> initialWindowBuilder;
    private final Consumer<DLWindowManager> close;
    private boolean closeOnEscape = true;
    private boolean isPauseScreen = true;
    private boolean showPreviousScreenOnClose = true;
    private double width;
    private double height;
    private boolean isDragging = false;
    private boolean isMouseDown = false;
    private int mouseDownButton = -1;
    private double mouseDownX;
    private double mouseDownY;
    private boolean specialDragAction = false;
    private boolean updatingLayout = false;
    private DLWindow focusedWindow;
    private boolean updateFocusLocked = false;

    @Override
    public Map<Class<? extends IEvent>, PriorityQueue<EventListenerWrapper<?>>> getEventListeners() {
        return this.eventListeners;
    }

    public <T extends DLWindow> DLWindowManager(AbstractContainerMenu menu, WindowBuilder<T> windowBuilder, double width, double height, Consumer<DLWindowManager> close) {
        this.menu = menu;
        this.close = close;
        this.width = width;
        this.height = height;
        this.initialWindowBuilder = windowBuilder;
    }

    public <T extends IGuiManagementComponent> T addManager(Function<DLWindowManager, T> factory) {
        IGuiManagementComponent mgr = (IGuiManagementComponent)factory.apply(this);
        for (IGuiManagementComponent m : this.managementComponents) {
            if (!m.getClass().isAssignableFrom(mgr.getClass())) continue;
            return (T)m;
        }
        this.managementComponents.add(mgr);
        mgr.onAttach(this);
        return (T)mgr;
    }

    public <T extends IGuiManagementComponent> void removeManager(Class<T> type) {
        Iterator<IGuiManagementComponent> mgrIterator = this.managementComponents.iterator();
        while (mgrIterator.hasNext()) {
            IGuiManagementComponent mgr = mgrIterator.next();
            if (!mgr.getClass().isAssignableFrom(type)) continue;
            mgrIterator.remove();
            mgr.onDetach(this);
        }
    }

    public <T extends IGuiManagementComponent> Optional<T> getManager(Class<T> type) {
        for (IGuiManagementComponent m : this.managementComponents) {
            if (!m.getClass().isAssignableFrom(type)) continue;
            return Optional.of(m);
        }
        return Optional.empty();
    }

    public void updateLayout(double width, double height) {
        this.updatingLayout = true;
        this.setWidth(width);
        this.setHeight(height);
        if (!this.initialized && this.initialWindowBuilder != null) {
            this.createWindow(this.initialWindowBuilder);
            this.initialized = true;
        }
        this.init();
        this.updatingLayout = false;
    }

    protected void setWidth(double width) {
        double oldWidth = this.width;
        this.width = width;
        double diff = width - oldWidth;
        this.iterateAll(false, (win, i) -> {
            double k = win.dWidth() / 2.0;
            if (win.anchor.has(EAlign.RIGHT)) {
                if (win.anchor.has(EAlign.LEFT)) {
                    win.setWidth(win.dWidth() + diff);
                } else {
                    win.setX(this.width - win.dWidth());
                }
            }
            if (win.anchor.hasNone(new EAlign[]{EAlign.LEFT, EAlign.RIGHT}) && oldWidth > 0.0 && width > 0.0) {
                double p = Math.max(1.0 / oldWidth * (win.dX() + k), 0.0);
                win.setX(p * width - k);
            }
            return true;
        });
    }

    protected void setHeight(double height) {
        double oldHeight = this.height;
        this.height = height;
        double diff = height - oldHeight;
        this.iterateAll(false, (win, i) -> {
            double k = win.dHeight() / 2.0;
            if (win.anchor.has(EAlign.BOTTOM)) {
                if (win.anchor.has(EAlign.TOP)) {
                    win.setHeight(win.dHeight() + diff);
                } else {
                    win.setX(this.height - win.dHeight());
                }
            }
            if (win.anchor.hasNone(new EAlign[]{EAlign.TOP, EAlign.BOTTOM}) && oldHeight > 0.0 && height > 0.0) {
                double p = Math.max(1.0 / oldHeight * (win.dY() + k), 0.0);
                win.setY(p * height - k);
            }
            return true;
        });
    }

    protected void init() {
        this.interateManagerExtension(mgr -> {
            mgr.init();
            return false;
        });
        this.iterateAll(false, (win, i) -> {
            win.updateLayoutEvent((int)this.width, (int)this.height);
            return true;
        });
    }

    public void render(DLGuiGraphics graphics, int mouseX, int mouseY) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        for (RenderLayer layer : RenderLayer.values()) {
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_252880_(0.0f, 0.0f, (float)(-layer.z()));
            graphics.poseStack().m_85836_();
            this.interateManagerExtension(mgr -> {
                mgr.render(IGuiManagementComponent.Phase.PRE, graphics, mouseX, mouseY, layer);
                return false;
            });
            if (!layer.isSpecial()) {
                this.iterateAll(false, (win, i) -> {
                    graphics.poseStack().m_85836_();
                    graphics.poseStack().m_252880_((float)win.x(), (float)win.y(), (float)i.intValue());
                    win.renderEvent(graphics, mouseX - win.x(), mouseY - win.y(), layer, win.x(), win.y(), 0.0, 0.0, win.getPositionBox(), 1.0);
                    graphics.poseStack().m_85849_();
                    return true;
                });
            } else if (layer == RenderLayer.SCREEN_SPACE) {
                this.iterateAll(false, (win, i) -> {
                    graphics.poseStack().m_85836_();
                    win.renderOnScreenEvent(graphics, mouseX, mouseY);
                    graphics.poseStack().m_85849_();
                    return true;
                });
            } else if (layer == RenderLayer.OVERLAY) {
                this.renderInputOverlayComponents.forEach(x -> {
                    graphics.poseStack().m_85836_();
                    graphics.poseStack().m_252880_((float)x.xOffset(), (float)x.yOffset(), 0.0f);
                    x.component().renderEvent(graphics, x.mouseX() - (double)x.xOffset(), x.mouseY() - (double)x.yOffset(), layer, x.xOffset(), x.yOffset(), 0.0, 0.0, Rectangle.withSize(0.0, 0.0, this.width, this.height), 1.0);
                    graphics.poseStack().m_85849_();
                });
            }
            graphics.poseStack().m_85849_();
            this.interateManagerExtension(mgr -> {
                mgr.render(IGuiManagementComponent.Phase.POST, graphics, mouseX, mouseY, layer);
                return false;
            });
            this.invokeEvent(this, new DLGuiStandardEvents.RenderEvent(graphics, mouseX, mouseY, layer, Rectangle.withSize(0.0, 0.0, this.getScreenWidth(), this.getScreenHeight())));
            graphics.poseStack().m_85849_();
        }
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
    }

    public void tick() {
        this.interateManagerExtension(mgr -> {
            mgr.tick();
            return false;
        });
        this.invokeEvent(this, new DLGuiStandardEvents.TickEvent());
        this.iterateAll(false, (win, i) -> {
            win.tick();
            return true;
        });
    }

    public double getMouseDownX() {
        return this.mouseDownX;
    }

    public double getMouseDownY() {
        return this.mouseDownY;
    }

    public int getMouseDownButton() {
        return this.mouseDownButton;
    }

    public boolean isMouseDragging() {
        return this.isDragging;
    }

    public boolean isMouseDown() {
        return this.isMouseDown;
    }

    public DLWindow getFocusedWindow() {
        return this.focusedWindow;
    }

    public double mouseXOnScreen() {
        return Minecraft.m_91087_().f_91067_.m_91589_() * (double)Minecraft.m_91087_().m_91268_().m_85445_() / (double)Minecraft.m_91087_().m_91268_().m_85443_();
    }

    public double mouseYOnScreen() {
        return Minecraft.m_91087_().f_91067_.m_91594_() * (double)Minecraft.m_91087_().m_91268_().m_85446_() / (double)Minecraft.m_91087_().m_91268_().m_85444_();
    }

    public List<DLGuiComponent> getDraggedOverComponents() {
        return Collections.unmodifiableList(this.dragOverComponents);
    }

    public DLGuiComponent getFocusedComponent() {
        return this.focusedComponent;
    }

    public boolean shouldCloseOnEscape() {
        return this.closeOnEscape;
    }

    public void setCloseOnEscape(boolean b) {
        this.closeOnEscape = b;
    }

    public boolean isPauseScreen() {
        return this.isPauseScreen || this.getFocusedWindow() != null && (Boolean)this.getFocusedWindow().pauseGame.get() != false;
    }

    public void setPauseScreen(boolean b) {
        this.isPauseScreen = b;
    }

    public boolean shouldShowPreviousScreenOnClose() {
        return this.showPreviousScreenOnClose;
    }

    public void setShowPreviousScreenOnClose(boolean b) {
        this.showPreviousScreenOnClose = b;
    }

    public ModalId getCurrentModalId() {
        return this.windows.getLast().id();
    }

    private ModalWindowStack getCurrentModal() {
        Iterator<ModalWindowStack> iterator = this.windows.descendingIterator();
        while (iterator.hasNext()) {
            ModalWindowStack stack = iterator.next();
            if (stack.isEmpty()) continue;
            return stack;
        }
        return null;
    }

    public boolean hasModal(ModalId id) {
        return this.windows.contains(id);
    }

    private ModalWindowStack getModalById(ModalId id) {
        return this.windows.stream().filter(x -> x.equals(id)).findFirst().orElseThrow();
    }

    public DLWindow[] getWindows(ModalId id) {
        return (DLWindow[])this.getModalById(id).toArray(DLWindow[]::new);
    }

    public boolean hasWindows() {
        return !this.windows.isEmpty();
    }

    public DLWindow getCurrentActiveWindow() {
        DLWindow w;
        int i;
        if (!this.hasWindows()) {
            return null;
        }
        ModalWindowStack current = this.getCurrentModal();
        if (current == null) {
            return null;
        }
        List<DLWindow> ordered = this.orderedListForStack(current);
        for (i = ordered.size() - 1; i >= 0; --i) {
            w = ordered.get(i);
            if (!((Boolean)w.topLevel.get()).booleanValue()) continue;
            return w;
        }
        for (i = ordered.size() - 1; i >= 0; --i) {
            w = ordered.get(i);
            if (((Boolean)w.topLevel.get()).booleanValue()) continue;
            return w;
        }
        return null;
    }

    public void closeWindow(DLWindow window) {
        this.closeWindows(List.of(window));
    }

    public void closeWindows(Collection<DLWindow> wins) {
        HashSet<DLWindow> removedWindows = new HashSet<DLWindow>(wins.size());
        Iterator<ModalWindowStack> stacks = this.windows.descendingIterator();
        while (stacks.hasNext()) {
            ModalWindowStack stack = stacks.next();
            for (DLWindow win : wins) {
                if (!stack.remove(win)) continue;
                removedWindows.add(win);
            }
            if (!stack.isEmpty()) continue;
            stacks.remove();
        }
        if (this.windows.isEmpty()) {
            this.closeInternal();
        }
        if (this.focusedWindow != null && wins.contains(this.focusedWindow)) {
            this.focusedWindow = null;
        }
        this.updateWindowFocus(false);
        for (DLWindow win : removedWindows) {
            try {
                win.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            win.setWindowManager(null);
        }
        this.mouseMovedInternal(this.focusedWindow, false, this.mouseXOnScreen(), this.mouseYOnScreen());
    }

    public void closeModal(ModalId id) {
        ModalWindowStack stack = this.getModalById(id);
        stack.forEach(win -> {
            try {
                win.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.windows.remove(stack);
        if (this.windows.isEmpty()) {
            this.closeInternal();
        }
        if (stack.contains(this.focusedWindow)) {
            this.focusedWindow = null;
        }
        this.updateWindowFocus(false);
        stack.forEach(win -> win.setWindowManager(null));
    }

    public <T extends DLWindow> ModalId createModal(WindowBuilder<T> windowBuilder) {
        this.createModalInternal();
        return this.createWindow(windowBuilder);
    }

    public ModalWindowStack createModalInternal() {
        UUID id;
        while (this.windows.contains(id = UUID.randomUUID())) {
        }
        ModalWindowStack stack = new ModalWindowStack(id);
        this.windows.add(stack);
        return stack;
    }

    public <T extends DLWindow> ModalId createWindow(WindowBuilder<T> windowBuilder) {
        if (!this.hasWindows()) {
            this.createModalInternal();
        }
        return this.createWindow(windowBuilder, this.getCurrentModalId());
    }

    public <T extends DLWindow> ModalId createWindow(WindowBuilder<T> windowBuilder, ModalId id) {
        if (!this.hasWindows()) {
            this.createModalInternal();
        }
        ModalWindowStack stack = this.getModalById(id);
        DLWindow.WindowCreatedEvent window = windowBuilder.build(this);
        stack.add((DLWindow)((Object)window));
        window.invokeEvent(window, (DLWindow.WindowCreatedEvent)new DLWindow.WindowCreatedEvent(this, id, (int)this.width, (int)this.height));
        if (((Boolean)((DLWindow)((Object)window)).focusOnSpawn.get()).booleanValue()) {
            this.updateWindowFocus(false);
        }
        this.iterateModals((st, win, consumed) -> {
            if (st.id().equals(this.getCurrentModalId())) {
                return true;
            }
            this.mouseMovedInternal(win, true, this.mouseXOnScreen(), this.mouseYOnScreen());
            return true;
        }, null, null);
        return stack.id();
    }

    public void bringWindowToFront(DLWindow window) {
        boolean windowChanged;
        ModalWindowStack stack = this.getCurrentModal();
        if (stack == null) {
            return;
        }
        DLWindow previousWindow = (DLWindow)stack.getLast();
        boolean bl = windowChanged = previousWindow != window;
        if (windowChanged) {
            if (((Boolean)window.topLevel.get()).booleanValue()) {
                stack.remove(window);
                stack.addLast(window);
            } else {
                this.repositionNonTopWindowToFront(stack, window);
            }
        }
        if (windowChanged || this.focusedWindow == null) {
            this.updateWindowFocus(false);
        }
    }

    public void sendWindowToBack(DLWindow window) {
        ModalWindowStack stack = this.getCurrentModal();
        if (stack == null) {
            return;
        }
        if (((Boolean)window.topLevel.get()).booleanValue()) {
            this.repositionTopLevelWindowToBack(stack, window);
        } else {
            this.repositionNonTopWindowToBack(stack, window);
        }
    }

    private void repositionNonTopWindowToFront(ModalWindowStack stack, DLWindow window) {
        stack.remove(window);
        ArrayList<DLWindow> nonTop = new ArrayList<DLWindow>();
        ArrayList<DLWindow> top = new ArrayList<DLWindow>();
        for (DLWindow w : stack) {
            if (((Boolean)w.topLevel.get()).booleanValue()) {
                top.add(w);
                continue;
            }
            nonTop.add(w);
        }
        ConcurrentLinkedDeque<DLWindow> tmp = new ConcurrentLinkedDeque<DLWindow>();
        for (DLWindow w : nonTop) {
            tmp.add(w);
        }
        tmp.add(window);
        for (DLWindow w : top) {
            tmp.add(w);
        }
        stack.clear();
        stack.addAll(tmp);
    }

    private void repositionNonTopWindowToBack(ModalWindowStack stack, DLWindow window) {
        stack.remove(window);
        ArrayList<DLWindow> nonTop = new ArrayList<DLWindow>();
        ArrayList<DLWindow> top = new ArrayList<DLWindow>();
        for (DLWindow w : stack) {
            if (((Boolean)w.topLevel.get()).booleanValue()) {
                top.add(w);
                continue;
            }
            nonTop.add(w);
        }
        ConcurrentLinkedDeque<DLWindow> tmp = new ConcurrentLinkedDeque<DLWindow>();
        tmp.add(window);
        for (DLWindow w : nonTop) {
            tmp.add(w);
        }
        for (DLWindow w : top) {
            tmp.add(w);
        }
        stack.clear();
        stack.addAll(tmp);
    }

    private void repositionTopLevelWindowToBack(ModalWindowStack stack, DLWindow window) {
        stack.remove(window);
        ArrayList<DLWindow> nonTop = new ArrayList<DLWindow>();
        ArrayList<DLWindow> top = new ArrayList<DLWindow>();
        for (DLWindow w : stack) {
            if (((Boolean)w.topLevel.get()).booleanValue()) {
                top.add(w);
                continue;
            }
            nonTop.add(w);
        }
        ConcurrentLinkedDeque<DLWindow> tmp = new ConcurrentLinkedDeque<DLWindow>();
        for (DLWindow w : nonTop) {
            tmp.add(w);
        }
        tmp.add(window);
        for (DLWindow w : top) {
            tmp.add(w);
        }
        stack.clear();
        stack.addAll(tmp);
    }

    private List<DLWindow> orderedListForStack(ModalWindowStack stack) {
        ArrayList<DLWindow> nonTop = new ArrayList<DLWindow>();
        ArrayList<DLWindow> top = new ArrayList<DLWindow>();
        for (DLWindow w : stack) {
            if (((Boolean)w.topLevel.get()).booleanValue()) {
                top.add(w);
                continue;
            }
            nonTop.add(w);
        }
        ArrayList<DLWindow> result = new ArrayList<DLWindow>(nonTop.size() + top.size());
        result.addAll(nonTop);
        result.addAll(top);
        return result;
    }

    public void updateWindowFocus(boolean unfocus) {
        boolean wasLocked = this.updateFocusLocked;
        this.updateFocusLocked = true;
        DLWindow previouslyFocusedWindow = this.focusedWindow;
        if (!wasLocked) {
            this.updateFocusLocked = false;
            AtomicReference<Object> window = new AtomicReference<Object>(null);
            if (unfocus) {
                ModalWindowStack stack = this.getCurrentModal();
                if (stack != null) {
                    List<DLWindow> ordered = this.orderedListForStack(stack);
                    for (int i = ordered.size() - 1; i >= 0; --i) {
                        DLWindow win = ordered.get(i);
                        if (!win.getPositionBox().collision(this.mouseXOnScreen(), this.mouseYOnScreen())) continue;
                        window.set(win);
                        break;
                    }
                }
            } else {
                window.set(this.getCurrentActiveWindow());
            }
            this.focusedWindow = window.get();
            if (previouslyFocusedWindow != null) {
                previouslyFocusedWindow.invokeEvent(previouslyFocusedWindow, new DLWindow.WindowFocusEvent(this, false));
            }
            if (this.focusedWindow != null) {
                this.focusedWindow.invokeEvent(this.focusedWindow, new DLWindow.WindowFocusEvent(this, true));
            }
        }
    }

    private void closeInternal() {
        this.onClose();
        this.close.accept(this);
    }

    public void close() {
        for (ModalWindowStack stack : this.windows) {
            this.closeModal(stack.id());
        }
        this.closeInternal();
    }

    public void focusComponent(DLGuiComponent component) {
        if (this.focusedComponent != null) {
            this.focusedComponent.setFocus(false);
        }
        this.focusedComponent = component;
        if (component != null) {
            component.setFocus(true);
        }
        this.focusedComponent.getParent().ifPresent(p -> {
            if (((Boolean)p.scrollToFocus.get()).booleanValue()) {
                p.scrollIntoView(this.focusedComponent);
            }
        });
    }

    public void invokeLater(Runnable task) {
        this.delayedTasks.add(task);
    }

    private void clearMouseInteractionData() {
        this.mouseDownComponents.clear();
        this.draggingComponents.clear();
        this.dragOverComponents.clear();
        this.renderInputOverlayComponents.clear();
        this.specialDragAction = false;
        this.isDragging = false;
        this.mouseDownButton = -1;
    }

    protected boolean interateManagerExtension(Function<IGuiManagementComponent, Boolean> action) {
        for (IGuiManagementComponent manager : this.managementComponents) {
            if (!action.apply(manager).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected void iterateAll(boolean backwards, BiFunction<DLWindow, Integer, Boolean> callback) {
        if (backwards) {
            this.iterateAllBackwards(callback);
        } else {
            this.iterateAllForwards(callback);
        }
    }

    private void iterateAllBackwards(BiFunction<DLWindow, Integer, Boolean> callback) {
        int i = 0;
        for (ModalWindowStack stack : this.windows) {
            List<DLWindow> ordered = this.orderedListForStack(stack);
            for (int j = ordered.size() - 1; j >= 0; --j) {
                DLWindow win = ordered.get(j);
                if (!callback.apply(win, i).booleanValue()) {
                    return;
                }
                ++i;
            }
        }
    }

    private void iterateAllForwards(BiFunction<DLWindow, Integer, Boolean> callback) {
        int i = 0;
        for (ModalWindowStack stack : this.windows) {
            List<DLWindow> ordered = this.orderedListForStack(stack);
            for (DLWindow win : ordered) {
                if (!callback.apply(win, i).booleanValue()) {
                    return;
                }
                ++i;
            }
        }
    }

    public boolean iterateModals(IModalIterator callback, Runnable prepare, Consumer<Boolean> andThen) {
        MutableBoolean consumed = new MutableBoolean();
        if (this.hasWindows()) {
            DLUtils.doIfNotNull(prepare, Runnable::run);
            Iterator<ModalWindowStack> stack = this.windows.descendingIterator();
            boolean firstDone = false;
            while (stack.hasNext()) {
                consumed.setValue(firstDone || consumed.getValue() != false);
                ModalWindowStack current = stack.next();
                if (current == null || current.isEmpty()) continue;
                firstDone = true;
                List<DLWindow> ordered = this.orderedListForStack(current);
                for (int i = ordered.size() - 1; i >= 0; --i) {
                    DLWindow window = ordered.get(i);
                    consumed.setValue(callback.run(current, window, consumed.getValue()) || consumed.getValue() != false);
                }
            }
        }
        DLUtils.doIfNotNull(andThen, x -> x.accept(consumed.getValue()));
        while (!this.delayedTasks.isEmpty()) {
            this.delayedTasks.poll().run();
        }
        return false;
    }

    public boolean iterateCurrentModal(BiFunction<DLWindow, Boolean, Boolean> callback, Runnable prepare, Consumer<Boolean> andThen) {
        MutableBoolean consumed = new MutableBoolean();
        if (this.hasWindows()) {
            DLUtils.doIfNotNull(prepare, Runnable::run);
            ModalWindowStack current = this.getCurrentModal();
            if (current != null) {
                List<DLWindow> ordered = this.orderedListForStack(current);
                for (int i = ordered.size() - 1; i >= 0; --i) {
                    DLWindow window = ordered.get(i);
                    consumed.setValue(callback.apply(window, consumed.getValue()) != false || consumed.getValue() != false);
                }
            }
        }
        DLUtils.doIfNotNull(andThen, x -> x.accept(consumed.getValue()));
        while (!this.delayedTasks.isEmpty()) {
            this.delayedTasks.poll().run();
        }
        return false;
    }

    public void prepareMouseClick(double mouseX, double mouseY, int button) {
        this.clearMouseInteractionData();
        this.focusedComponent = null;
        this.mouseDownX = mouseX;
        this.mouseDownY = mouseY;
        this.mouseDownButton = button;
        this.isMouseDown = true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.interateManagerExtension(mgr -> mgr.mouseClicked(IGuiManagementComponent.Phase.PRE, false, mouseX, mouseY, button))) {
            return true;
        }
        if (!this.hasWindows()) {
            return false;
        }
        switch (button) {
            case 0: {
                this.invokeEvent(this, new DLGuiStandardEvents.ClickEvent(mouseX, mouseY));
                break;
            }
            case 1: {
                this.invokeEvent(this, new DLGuiStandardEvents.RightClickEvent(mouseX, mouseY));
            }
        }
        if (!this.hasWindows()) {
            return false;
        }
        this.invokeEvent(this, new DLGuiStandardEvents.MousePressedEvent(mouseX, mouseY, button));
        boolean eventResult = this.iterateCurrentModal((win, consumed) -> {
            DLGuiComponent.Flags flags = new DLGuiComponent.Flags((boolean)consumed, (boolean)consumed, false, true, (ImmutableSet<DLGuiComponent>)ImmutableSet.of(), (ImmutableSet<DLGuiComponent>)ImmutableSet.of());
            HitResult result = win.iterateComponents(mouseX, mouseY, win.x(), win.y(), Rectangle.INFINITE, flags, DLGuiComponent.ConsumptionType.CLICK, 1.0);
            for (Map.Entry<HitResult.ComponentSelectionState, LinkedList<HitResult.ComponentHitContext>> e : result.components().entrySet()) {
                for (HitResult.ComponentHitContext c : e.getValue()) {
                    c.component().setFocus(e.getKey() == HitResult.ComponentSelectionState.FOCUSED);
                    if (e.getKey().isHit()) {
                        c.component().setMouseDown(true, c.mouseX(), c.mouseY(), button);
                        this.mouseDownComponents.add(c.component());
                    }
                    if (e.getKey() != HitResult.ComponentSelectionState.FOCUSED) continue;
                    this.focusedComponent = c.component();
                }
            }
            boolean b = result.consumed();
            if (!this.hasWindows()) {
                return b;
            }
            if (b && !consumed.booleanValue()) {
                this.bringWindowToFront((DLWindow)win);
            }
            return b;
        }, () -> this.prepareMouseClick(mouseX, mouseY, button), consumed -> {
            if (!consumed.booleanValue()) {
                this.updateWindowFocus(true);
            }
        });
        return this.interateManagerExtension(mgr -> mgr.mouseClicked(IGuiManagementComponent.Phase.POST, eventResult, mouseX, mouseY, button)) || eventResult;
    }

    public boolean mouseMoved(double mouseX, double mouseY) {
        boolean result = this.iterateModals((stack, win, consumed) -> this.mouseMovedInternal(win, consumed, mouseX, mouseY), null, null);
        return result;
    }

    private boolean mouseMovedInternal(DLWindow window, boolean consumed, double mouseX, double mouseY) {
        if (this.interateManagerExtension(mgr -> mgr.mouseMoved(IGuiManagementComponent.Phase.PRE, false, mouseX, mouseY))) {
            return true;
        }
        if (!this.hasWindows()) {
            return false;
        }
        this.invokeEvent(this, new DLGuiStandardEvents.MouseMoveEvent(mouseX, mouseY));
        if (this.isDragging) {
            return false;
        }
        DLGuiComponent.Flags flags = new DLGuiComponent.Flags(consumed, consumed, false, true, (ImmutableSet<DLGuiComponent>)ImmutableSet.of(), (ImmutableSet<DLGuiComponent>)ImmutableSet.of());
        HitResult result = window.iterateComponents(mouseX, mouseY, window.x(), window.y(), Rectangle.INFINITE, flags, DLGuiComponent.ConsumptionType.MOUSE_MOVE, 1.0);
        for (Map.Entry<HitResult.ComponentSelectionState, LinkedList<HitResult.ComponentHitContext>> e : result.components().entrySet()) {
            for (HitResult.ComponentHitContext c : e.getValue()) {
                c.component().setSelected(e.getKey().isHit(), c.mouseX(), c.mouseY());
            }
        }
        return this.interateManagerExtension(mgr -> mgr.mouseMoved(IGuiManagementComponent.Phase.POST, result.consumed(), mouseX, mouseY)) || result.consumed();
    }

    public void finishMouseRelease(double mouseX, double mouseY, int button) {
        for (DLGuiComponent component : this.dragOverComponents) {
            component.setDragComponentOver(false, this.draggingComponents.stream().map(x -> x.component()).toList(), mouseX, mouseY, button);
        }
        this.clearMouseInteractionData();
        this.isMouseDown = false;
        this.iterateCurrentModal((win, consumed) -> this.mouseMovedInternal((DLWindow)win, (boolean)consumed, mouseX, mouseY), null, null);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.interateManagerExtension(mgr -> mgr.mouseReleased(IGuiManagementComponent.Phase.PRE, false, mouseX, mouseY, button))) {
            return true;
        }
        if (!this.hasWindows()) {
            return false;
        }
        this.invokeEvent(this, new DLGuiStandardEvents.MouseReleaseEvent(mouseX, mouseY, button));
        boolean eventResult = this.iterateCurrentModal((win, consumed) -> {
            DLGuiComponent.Flags flags = new DLGuiComponent.Flags((boolean)consumed, (boolean)consumed, false, true, (ImmutableSet<DLGuiComponent>)ImmutableSet.of(), (ImmutableSet<DLGuiComponent>)ImmutableSet.of());
            HitResult result = win.iterateComponents(mouseX, mouseY, win.x(), win.y(), Rectangle.INFINITE, flags, DLGuiComponent.ConsumptionType.CLICK, 1.0);
            for (Map.Entry<HitResult.ComponentSelectionState, LinkedList<HitResult.ComponentHitContext>> e : result.components().entrySet()) {
                for (HitResult.ComponentHitContext c : e.getValue()) {
                    if (e.getKey().isHit() && this.mouseDownComponents.contains(c.component())) {
                        c.component().mouseClickDispatcher(c.mouseX(), c.mouseY(), button);
                    }
                    c.component().setMouseDown(false, c.mouseX(), c.mouseY(), button);
                    if (!c.component().isDragged()) continue;
                    c.component().setDragging(false, c.mouseX(), c.mouseY(), button, this.mouseDownX, this.mouseDownY, 0.0, 0.0, this.specialDragAction, this.dragOverComponents);
                }
            }
            return false;
        }, null, consumed -> this.finishMouseRelease(mouseX, mouseY, button));
        return this.interateManagerExtension(mgr -> mgr.mouseReleased(IGuiManagementComponent.Phase.POST, eventResult, mouseX, mouseY, button)) || eventResult;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.interateManagerExtension(mgr -> mgr.mouseScrolled(IGuiManagementComponent.Phase.PRE, false, mouseX, mouseY, scrollX, scrollY))) {
            return true;
        }
        if (!this.hasWindows()) {
            return false;
        }
        this.invokeEvent(this, new DLGuiStandardEvents.ScrollEvent(mouseX, mouseY, scrollX, scrollY));
        boolean eventResult = this.iterateCurrentModal((win, consumed) -> {
            DLGuiComponent.Flags flags = new DLGuiComponent.Flags((boolean)consumed, (boolean)consumed, false, true, (ImmutableSet<DLGuiComponent>)ImmutableSet.of(), (ImmutableSet<DLGuiComponent>)ImmutableSet.of());
            HitResult result = win.iterateComponents(mouseX, mouseY, win.x(), win.y(), Rectangle.INFINITE, flags, DLGuiComponent.ConsumptionType.SCROLL, 1.0);
            for (Map.Entry<HitResult.ComponentSelectionState, LinkedList<HitResult.ComponentHitContext>> e : result.components().entrySet()) {
                for (HitResult.ComponentHitContext c : e.getValue()) {
                    if (!this.hasWindows()) {
                        return result.consumed();
                    }
                    if (!e.getKey().isHit()) continue;
                    c.component().invokeEvent(c.component(), new DLGuiStandardEvents.ScrollEvent(c.mouseX(), c.mouseY(), -scrollX, -scrollY), true);
                }
            }
            this.mouseMovedInternal((DLWindow)win, (boolean)consumed, mouseX, mouseY);
            return result.consumed();
        }, null, null);
        return this.interateManagerExtension(mgr -> mgr.mouseScrolled(IGuiManagementComponent.Phase.POST, eventResult, mouseX, mouseY, scrollX, scrollY)) || eventResult;
    }

    public void prepareMouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        this.specialDragAction |= Math.abs(this.mouseDownX - mouseX) > 5.0 || Math.abs(this.mouseDownY - mouseY) > 5.0;
        this.draggingComponents.clear();
        this.dragOverComponents.clear();
        this.renderInputOverlayComponents.clear();
    }

    public void finishMouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        ImmutableList immutableDragOverComponents = ImmutableList.copyOf(this.dragOverComponents);
        ArrayList<DLGuiComponent> draggingC = new ArrayList<DLGuiComponent>(this.draggingComponents.size());
        for (HitResult.ComponentHitContext c : this.draggingComponents) {
            if (c.component().setDragging(true, c.mouseX(), c.mouseY(), button, this.mouseDownX, this.mouseDownY, dragX, dragY, this.specialDragAction, (List<DLGuiComponent>)immutableDragOverComponents)) {
                this.renderInputOverlayComponents.add(c);
            }
            draggingC.add(c.component());
        }
        for (DLGuiComponent component : this.dragOverComponents) {
            component.setDragComponentOver(true, draggingC, mouseX, mouseY, button);
        }
        for (DLGuiComponent component : draggingC) {
            component.invokeEvent(component, new DLGuiStandardEvents.DraggingOverEvent((List<DLGuiComponent>)immutableDragOverComponents, mouseX, mouseY, button));
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.interateManagerExtension(mgr -> mgr.mouseDragged(IGuiManagementComponent.Phase.PRE, false, mouseX, mouseY, button, dragX, dragY))) {
            return true;
        }
        this.isDragging = true;
        if (this.mouseDownComponents.isEmpty()) {
            return false;
        }
        boolean eventResult = this.iterateCurrentModal((win, consumed) -> {
            DLGuiComponent.Flags flags = new DLGuiComponent.Flags((boolean)consumed, (boolean)consumed, false, true, (ImmutableSet<DLGuiComponent>)ImmutableSet.of(), (ImmutableSet<DLGuiComponent>)ImmutableSet.copyOf(this.mouseDownComponents));
            HitResult result = win.iterateComponents(mouseX, mouseY, win.x(), win.y(), Rectangle.INFINITE, flags, DLGuiComponent.ConsumptionType.DRAG, 1.0);
            for (Map.Entry<HitResult.ComponentSelectionState, LinkedList<HitResult.ComponentHitContext>> e : result.components().entrySet()) {
                for (HitResult.ComponentHitContext c : e.getValue()) {
                    if (this.mouseDownComponents.contains(c.component())) {
                        this.draggingComponents.add(c);
                        continue;
                    }
                    if (e.getKey().isHit()) {
                        this.dragOverComponents.add(c.component());
                        continue;
                    }
                    if (!c.component().isComponentDraggedOver()) continue;
                    c.component().setDragComponentOver(false, new ArrayList<DLGuiComponent>(this.mouseDownComponents), c.mouseX(), c.mouseY(), button);
                }
            }
            return result.consumed();
        }, () -> this.prepareMouseDragged(mouseX, mouseY, button, dragX, dragY), consumed -> this.finishMouseDragged(mouseX, mouseY, button, dragX, dragY));
        return this.interateManagerExtension(mgr -> mgr.mouseDragged(IGuiManagementComponent.Phase.POST, eventResult, mouseX, mouseY, button, dragX, dragY)) || eventResult;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean fRes;
        if (this.shouldCloseOnEscape() && keyCode == 256) {
            this.close();
            return true;
        }
        if (this.interateManagerExtension(mgr -> mgr.keyPressed(IGuiManagementComponent.Phase.PRE, false, keyCode, scanCode, modifiers))) {
            return true;
        }
        boolean eventResult = this.invokeEvent(this, new DLGuiStandardEvents.KeyPressEvent(keyCode, scanCode, modifiers));
        if (this.focusedComponent != null) {
            this.focusedComponent.invokeEvent(this.focusedComponent, new DLGuiStandardEvents.KeyPressEvent(keyCode, scanCode, modifiers), true);
            eventResult = true;
        }
        return this.interateManagerExtension(arg_0 -> DLWindowManager.lambda$keyPressed$42(fRes = eventResult, keyCode, scanCode, modifiers, arg_0)) || eventResult;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        boolean fRes;
        if (this.interateManagerExtension(mgr -> mgr.keyReleased(IGuiManagementComponent.Phase.PRE, false, keyCode, scanCode, modifiers))) {
            return true;
        }
        boolean eventResult = this.invokeEvent(this, new DLGuiStandardEvents.KeyReleaseEvent(keyCode, scanCode, modifiers));
        if (this.focusedComponent != null) {
            this.focusedComponent.invokeEvent(this.focusedComponent, new DLGuiStandardEvents.KeyReleaseEvent(keyCode, scanCode, modifiers), true);
            eventResult = true;
        }
        return this.interateManagerExtension(arg_0 -> DLWindowManager.lambda$keyReleased$44(fRes = eventResult, keyCode, scanCode, modifiers, arg_0)) || eventResult;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        boolean fRes;
        if (this.interateManagerExtension(mgr -> mgr.charTyped(IGuiManagementComponent.Phase.PRE, false, codePoint, modifiers))) {
            return true;
        }
        boolean eventResult = this.invokeEvent(this, new DLGuiStandardEvents.CharTypeEvent(codePoint, modifiers));
        if (this.focusedComponent != null) {
            this.focusedComponent.invokeEvent(this.focusedComponent, new DLGuiStandardEvents.CharTypeEvent(codePoint, modifiers), true);
            eventResult = true;
        }
        return this.interateManagerExtension(arg_0 -> DLWindowManager.lambda$charTyped$46(fRes = eventResult, codePoint, modifiers, arg_0)) || eventResult;
    }

    public boolean onFilesDrop(List<Path> paths) {
        double mouseX = this.mouseXOnScreen();
        double mouseY = this.mouseYOnScreen();
        if (this.interateManagerExtension(mgr -> mgr.onFilesDrop(IGuiManagementComponent.Phase.PRE, false, paths))) {
            return true;
        }
        boolean eventResult = this.iterateCurrentModal((win, consumed) -> {
            DLGuiComponent.Flags flags = new DLGuiComponent.Flags((boolean)consumed, (boolean)consumed, false, true, (ImmutableSet<DLGuiComponent>)ImmutableSet.of(), (ImmutableSet<DLGuiComponent>)ImmutableSet.of());
            HitResult result = win.iterateComponents(mouseX, mouseY, win.x(), win.y(), Rectangle.INFINITE, flags, DLGuiComponent.ConsumptionType.DRAG_AND_DROP, 1.0);
            for (Map.Entry<HitResult.ComponentSelectionState, LinkedList<HitResult.ComponentHitContext>> e : result.components().entrySet()) {
                for (HitResult.ComponentHitContext c : e.getValue()) {
                    if (!e.getKey().isHit()) continue;
                    c.component().invokeEvent(c.component(), new DLGuiStandardEvents.DragAndDropFilesEvent(paths, c.mouseX(), c.mouseY()), true);
                }
            }
            boolean b = result.consumed();
            if (b) {
                this.bringWindowToFront((DLWindow)win);
            }
            return b;
        }, null, null);
        return this.interateManagerExtension(mgr -> mgr.onFilesDrop(IGuiManagementComponent.Phase.POST, eventResult, paths)) || eventResult;
    }

    public void onClose() {
        this.interateManagerExtension(mgr -> {
            mgr.close();
            return false;
        });
        this.iterateAll(false, (win, i) -> {
            try {
                win.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        });
        CursorType.set(null);
    }

    public static boolean hasControlDown() {
        return Screen.m_96637_();
    }

    public static boolean hasShiftDown() {
        return Screen.m_96638_();
    }

    public static boolean hasAltDown() {
        return Screen.m_96639_();
    }

    public static boolean isCut(int keyCode) {
        return Screen.m_96628_((int)keyCode);
    }

    public static boolean isPaste(int keyCode) {
        return Screen.m_96630_((int)keyCode);
    }

    public static boolean isCopy(int keyCode) {
        return Screen.m_96632_((int)keyCode);
    }

    public static boolean isSelectAll(int keyCode) {
        return Screen.m_96634_((int)keyCode);
    }

    public double getScreenWidth() {
        return this.width;
    }

    public double getScreenHeight() {
        return this.height;
    }

    public boolean isUpdatingLayout() {
        return this.updatingLayout;
    }

    public AbstractContainerMenu m_6262_() {
        return this.menu;
    }

    public boolean supportsMenus() {
        return this.menu != null;
    }

    private static /* synthetic */ Boolean lambda$charTyped$46(boolean fRes, char codePoint, int modifiers, IGuiManagementComponent mgr) {
        return mgr.charTyped(IGuiManagementComponent.Phase.POST, fRes, codePoint, modifiers);
    }

    private static /* synthetic */ Boolean lambda$keyReleased$44(boolean fRes, int keyCode, int scanCode, int modifiers, IGuiManagementComponent mgr) {
        return mgr.keyReleased(IGuiManagementComponent.Phase.POST, fRes, keyCode, scanCode, modifiers);
    }

    private static /* synthetic */ Boolean lambda$keyPressed$42(boolean fRes, int keyCode, int scanCode, int modifiers, IGuiManagementComponent mgr) {
        return mgr.keyPressed(IGuiManagementComponent.Phase.POST, fRes, keyCode, scanCode, modifiers);
    }

    private static interface IModalIterator {
        public boolean run(ModalWindowStack var1, DLWindow var2, boolean var3);
    }
}

