/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.base;

import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.RenderLayer;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import java.nio.file.Path;
import java.util.List;

public interface IGuiManagementComponent
extends Comparable<IGuiManagementComponent> {
    public int getPriority();

    default public void onAttach(DLWindowManager manager) {
    }

    default public void onDetach(DLWindowManager manager) {
    }

    default public void init() {
    }

    default public void render(Phase phase, DLGuiGraphics graphics, int mouseX, int mouseY, RenderLayer layer) {
    }

    default public void tick() {
    }

    default public void close() {
    }

    default public boolean mouseClicked(Phase phase, boolean consumed, double mouseX, double mouseY, int button) {
        return false;
    }

    default public boolean mouseMoved(Phase phase, boolean consumed, double mouseX, double mouseY) {
        return false;
    }

    default public boolean mouseReleased(Phase phase, boolean consumed, double mouseX, double mouseY, int button) {
        return false;
    }

    default public boolean mouseScrolled(Phase phase, boolean consumed, double mouseX, double mouseY, double scrollX, double scrollY) {
        return false;
    }

    default public boolean mouseDragged(Phase phase, boolean consumed, double mouseX, double mouseY, int button, double dragX, double dragY) {
        return false;
    }

    default public boolean keyPressed(Phase phase, boolean consumed, int keyCode, int scanCode, int modifiers) {
        return false;
    }

    default public boolean keyReleased(Phase phase, boolean consumed, int keyCode, int scanCode, int modifiers) {
        return false;
    }

    default public boolean charTyped(Phase phase, boolean consumed, char codePoint, int modifiers) {
        return false;
    }

    default public boolean onFilesDrop(Phase phase, boolean consumed, List<Path> paths) {
        return false;
    }

    @Override
    default public int compareTo(IGuiManagementComponent o) {
        return Integer.compare(this.getPriority(), o.getPriority());
    }

    public static enum Phase {
        PRE,
        POST;

    }
}

