/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.base.manager;

import de.mrjulsen.mcdragonlib.client.gui.container.DLSlot;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.IGuiManagementComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.RenderLayer;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class InventoryManager
implements IGuiManagementComponent {
    public final DLWindowManager windowManager;
    protected final Set<Slot> quickCraftSlots = new HashSet<Slot>();
    private boolean isQuickCrafting = false;
    private int quickCraftingButton = -1;
    private int quickCraftingType = -1;
    private int quickCraftingRemainder = 0;
    private DLSlot lastClickedSlot;
    private long lastClickedTime;
    private int lastClickedButton;
    private boolean doubleClick;
    private ItemStack quickMovedItem = ItemStack.f_41583_;
    private boolean skipNextRelease;
    private ItemStack draggingStack = ItemStack.f_41583_;
    private boolean isSplittingStack;
    private DLSlot clickedSlot;
    private DLSlot snapbackEnd;
    private int snapbackStartX;
    private int snapbackStartY;
    private long snapbackTime;
    private ItemStack snapbackItem = ItemStack.f_41583_;
    private Slot quickdropSlot;
    private long quickdropTime;

    public InventoryManager(DLWindowManager windowManager) {
        this.windowManager = windowManager;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    public boolean isHoldingItem() {
        return this.lastClickedSlot == null ? false : !this.lastClickedSlot.menu.m_142621_().m_41619_();
    }

    public ItemStack getHoldingItem() {
        ItemStack ret = this.lastClickedSlot != null ? this.lastClickedSlot.menu.m_142621_() : ItemStack.f_41583_;
        return ret;
    }

    public boolean isQuickCrafting() {
        return this.isQuickCrafting;
    }

    public void setQuickCrafting(boolean b, int button, int type) {
        this.setQuickCrafting(b);
        this.quickCraftingButton = button;
        this.quickCraftingType = type;
    }

    public void setQuickCrafting(boolean b) {
        this.isQuickCrafting = b;
        this.quickCraftSlots.clear();
    }

    public int getQuickCraftingButton() {
        return this.quickCraftingButton;
    }

    public int getQuickCraftingType() {
        return this.quickCraftingType;
    }

    public Set<Slot> getQuickCraftingSlots() {
        return this.quickCraftSlots;
    }

    public ItemStack getQuickMovedItem() {
        return this.quickMovedItem;
    }

    public void setLastQuickMoved(ItemStack quickMovedItem) {
        this.quickMovedItem = quickMovedItem;
    }

    public void setQuickCraftingRemainder(int value) {
        this.quickCraftingRemainder = value;
    }

    public int getQuickCraftingRemainder() {
        return this.quickCraftingRemainder;
    }

    public void setSkipNextRelease(boolean b) {
        this.skipNextRelease = b;
    }

    public boolean shouldSkipNextRelease() {
        return this.skipNextRelease;
    }

    public void setLastClickedSlot(DLSlot slot) {
        this.lastClickedSlot = slot;
    }

    public void setLastClickTime(long time) {
        this.lastClickedTime = time;
    }

    public void setLastClickedButton(int button) {
        this.lastClickedButton = button;
    }

    public long getLastClickTime() {
        return this.lastClickedTime;
    }

    public int getLastClickButton() {
        return this.lastClickedButton;
    }

    public void setDoubleClick(boolean b) {
        this.doubleClick = b;
    }

    public boolean isDoubleClick() {
        return this.doubleClick;
    }

    public DLSlot getLastClickedSlot() {
        return this.lastClickedSlot;
    }

    public void setDraggingItem(ItemStack stack) {
        this.draggingStack = stack;
    }

    public ItemStack getDraggingItem() {
        return this.draggingStack;
    }

    public void setIsSplittingStack(boolean b) {
        this.isSplittingStack = b;
    }

    public boolean isSplittingStack() {
        return this.isSplittingStack;
    }

    public void setSelectedSlot(DLSlot slot) {
        this.clickedSlot = slot;
    }

    public DLSlot getSelectedSlot() {
        return this.clickedSlot;
    }

    public DLSlot getSnapbackEnd() {
        return this.snapbackEnd;
    }

    public void setSnapbackEnd(DLSlot snapbackEnd) {
        this.snapbackEnd = snapbackEnd;
    }

    public int getSnapbackStartX() {
        return this.snapbackStartX;
    }

    public void setSnapbackStartX(int snapbackStartX) {
        this.snapbackStartX = snapbackStartX;
    }

    public int getSnapbackStartY() {
        return this.snapbackStartY;
    }

    public void setSnapbackStartY(int snapbackStartY) {
        this.snapbackStartY = snapbackStartY;
    }

    public long getSnapbackTime() {
        return this.snapbackTime;
    }

    public void setSnapbackTime(long snapbackTime) {
        this.snapbackTime = snapbackTime;
    }

    public ItemStack getSnapbackItem() {
        return this.snapbackItem;
    }

    public void setSnapbackItem(ItemStack snapbackItem) {
        this.snapbackItem = snapbackItem;
    }

    public Slot getQuickdropSlot() {
        return this.quickdropSlot;
    }

    public void setQuickdropSlot(Slot quickdropSlot) {
        this.quickdropSlot = quickdropSlot;
    }

    public long getQuickdropTime() {
        return this.quickdropTime;
    }

    public void setQuickdropTime(long quickdropTime) {
        this.quickdropTime = quickdropTime;
    }

    @Override
    public void render(IGuiManagementComponent.Phase phase, DLGuiGraphics graphics, int mouseX, int mouseY, RenderLayer layer) {
        if (phase != IGuiManagementComponent.Phase.POST && layer != RenderLayer.FRONT) {
            return;
        }
        ItemStack itemStack = this.getDraggingItem().m_41619_() ? this.getHoldingItem() : this.getDraggingItem();
        String string = null;
        if (!itemStack.m_41619_()) {
            if (this.isQuickCrafting() && this.getQuickCraftingSlots().size() > 1) {
                if ((itemStack = itemStack.m_255036_(this.getQuickCraftingRemainder())).m_41619_()) {
                    string = String.valueOf(ChatFormatting.YELLOW) + "0";
                }
            } else if (this.isSplittingStack() && !itemStack.m_41619_()) {
                itemStack = itemStack.m_255036_(Mth.m_14167_((float)((float)itemStack.m_41613_() / 2.0f)));
            }
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_252880_(0.0f, 0.0f, 232.0f);
            int itemX = mouseX - 8;
            int itemY = mouseY - 8;
            if (!this.getDraggingItem().m_41619_()) {
                itemY = mouseY - 16;
            }
            GuiUtils.renderItem(graphics, itemStack, itemX, itemY, 1.0f, true);
            GuiUtils.renderItemDecoration(graphics, itemStack, itemX, itemY, 1.0f, string);
            graphics.poseStack().m_85849_();
        }
        if (!this.snapbackItem.m_41619_()) {
            float f = (float)(Util.m_137550_() - this.snapbackTime) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.snapbackItem = ItemStack.f_41583_;
            }
            int l = (int)(this.snapbackEnd.getXOnScreen() - (double)this.snapbackStartX);
            int m = (int)(this.snapbackEnd.getYOnScreen() - (double)this.snapbackStartY);
            int o = this.snapbackStartX + (int)((float)l * f);
            int p = this.snapbackStartY + (int)((float)m * f);
            this.renderFloatingItem(graphics, this.snapbackItem, o, p, null);
        }
    }

    private void renderFloatingItem(DLGuiGraphics guiGraphics, ItemStack stack, int x, int y, String text) {
        guiGraphics.poseStack().m_85836_();
        guiGraphics.poseStack().m_252880_(0.0f, 0.0f, 232.0f);
        GuiUtils.renderItem(guiGraphics, stack, x, y, 1.0f, false);
        guiGraphics.poseStack().m_85849_();
    }
}

