/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.components;

import com.mojang.blaze3d.platform.NativeImage;
import de.mrjulsen.mcdragonlib.annotations.SupportsEvents;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.CursorType;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.EAlign;
import de.mrjulsen.mcdragonlib.client.render.DefaultGuiTextures;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.events.IEvent;
import de.mrjulsen.mcdragonlib.util.Cache;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.Pair;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.MathUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.properties.BooleanProperty;
import de.mrjulsen.mcdragonlib.util.properties.ColorProperty;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.DynamicTexture;

@SupportsEvents(value={ColorChangedEvent.class})
public class DLColorPicker
extends DLGuiComponent {
    public static final int SLIDER_SIZE = 10;
    public static final int INNER_PADDING = 4;
    public final ColorProperty color = (ColorProperty)new ColorProperty(DLColor.WHITE, DLColor.WHITE).withAfterPropertyChangedCallback((o, a) -> this.invokeEvent(this, new ColorChangedEvent((DLColor)a), false));
    public final Property<HSVSlots> hsvSlots = new Property<HSVSlots>(new HSVSlots(HSVSlot.S, HSVSlot.V, HSVSlot.H));
    public final Property<EAlign> sliderAlign = (Property)new Property<EAlign>(EAlign.RIGHT).withAfterPropertyChangedCallback((o, a) -> this.updateScreenLayout());
    public final BooleanProperty showColorSlider = (BooleanProperty)new BooleanProperty(true).withAfterPropertyChangedCallback((o, a) -> this.updateScreenLayout());
    public final BooleanProperty showAlphaSlider = (BooleanProperty)new BooleanProperty(false).withAfterPropertyChangedCallback((o, a) -> this.updateScreenLayout());
    private float selectedHue = 0.0f;
    private float selectedSaturation = 0.0f;
    private float selectedBrightness = 1.0f;
    private float selectedAlpha = 1.0f;
    private final Cache<Rectangle> quadArea = new Cache<Rectangle>(() -> {
        int sliderSize = 0;
        if (((Boolean)this.showColorSlider.get()).booleanValue()) {
            sliderSize += 14;
        }
        if (((Boolean)this.showAlphaSlider.get()).booleanValue()) {
            sliderSize += 14;
        }
        return Rectangle.withSize(1 + (this.sliderAlign.get() == EAlign.LEFT ? sliderSize : 0), 1 + (this.sliderAlign.get() == EAlign.TOP ? sliderSize : 0), this.width() - 2 - (((EAlign)this.sliderAlign.get()).isHorizontal() ? sliderSize : 0), this.height() - 2 - (((EAlign)this.sliderAlign.get()).isVertical() ? sliderSize : 0));
    });
    private final Cache<Rectangle> colorSliderArea = new Cache<Rectangle>(() -> {
        int sliderSize = 0;
        if (((Boolean)this.showColorSlider.get()).booleanValue()) {
            sliderSize += 14;
        }
        if (((Boolean)this.showAlphaSlider.get()).booleanValue()) {
            sliderSize += 14;
        }
        return Rectangle.withSize(1 + (this.sliderAlign.get() == EAlign.RIGHT ? this.width() - sliderSize + 4 : 0), 1 + (this.sliderAlign.get() == EAlign.BOTTOM ? this.height() - sliderSize + 4 : 0), (((EAlign)this.sliderAlign.get()).isVertical() ? this.width() : 10) - 2, (((EAlign)this.sliderAlign.get()).isHorizontal() ? this.height() : 10) - 2);
    });
    private final Cache<Rectangle> alphaSliderArea = new Cache<Rectangle>(() -> Rectangle.withSize(1 + (this.sliderAlign.get() == EAlign.RIGHT ? this.width() - 10 : (((EAlign)this.sliderAlign.get()).isHorizontal() ? 14 : 0)), 1 + (this.sliderAlign.get() == EAlign.BOTTOM ? this.height() - 10 : (((EAlign)this.sliderAlign.get()).isVertical() ? 14 : 0)), (((EAlign)this.sliderAlign.get()).isVertical() ? this.width() : 10) - 2, (((EAlign)this.sliderAlign.get()).isHorizontal() ? this.height() : 10) - 2));
    private final Cache<DynamicTexture> quadTexture = new Cache<DynamicTexture>(() -> {
        NativeImage img = new NativeImage((int)this.quadArea.get().width(), (int)this.quadArea.get().height(), false);
        for (int i = 0; i < (int)this.quadArea.get().width(); ++i) {
            for (int k = 0; k < (int)this.quadArea.get().height(); ++k) {
                float vX = (float)i / (float)((int)this.quadArea.get().width());
                float vY = 1.0f - (float)k / (float)((int)this.quadArea.get().height());
                DLColor color = HSVSlot.colorOf(Pair.of(((HSVSlots)this.hsvSlots.get()).quadX(), Float.valueOf(vX)), Pair.of(((HSVSlots)this.hsvSlots.get()).quadY(), Float.valueOf(vY)), Pair.of(((HSVSlots)this.hsvSlots.get()).slider(), Float.valueOf(((HSVSlots)this.hsvSlots.get()).slider().get(this))));
                color = color.swapChannels(DLColor.ColorChannel.R, DLColor.ColorChannel.B);
                img.m_84988_(i, k, color.getAsARGB());
            }
        }
        DynamicTexture tex = new DynamicTexture(img);
        return tex;
    });
    private final Cache<DynamicTexture> colorSliderTexture = new Cache<DynamicTexture>(() -> {
        NativeImage img = new NativeImage((int)this.colorSliderArea.get().width(), (int)this.colorSliderArea.get().height(), false);
        if (((EAlign)this.sliderAlign.get()).isHorizontal()) {
            for (int k = 0; k < (int)this.colorSliderArea.get().height(); ++k) {
                float val = 1.0f - (float)k / (float)((int)this.colorSliderArea.get().height());
                DLColor color = HSVSlot.colorOf(this, ((HSVSlots)this.hsvSlots.get()).slider(), val);
                color = color.swapChannels(DLColor.ColorChannel.R, DLColor.ColorChannel.B);
                for (int i = 0; i < (int)this.colorSliderArea.get().width(); ++i) {
                    img.m_84988_(i, k, color.getAsARGB());
                }
            }
        } else {
            for (int k = 0; k < (int)this.colorSliderArea.get().width(); ++k) {
                float val = 1.0f - (float)k / (float)((int)this.colorSliderArea.get().width());
                DLColor color = HSVSlot.colorOf(this, ((HSVSlots)this.hsvSlots.get()).slider(), val);
                color = color.swapChannels(DLColor.ColorChannel.R, DLColor.ColorChannel.B);
                for (int i = 0; i < (int)this.colorSliderArea.get().height(); ++i) {
                    img.m_84988_(k, i, color.getAsARGB());
                }
            }
        }
        return new DynamicTexture(img);
    });
    private boolean skipValueUpdate = false;

    public DLColorPicker(int x, int y, int w, int h) {
        super(x, y, w, h);
        this.addEventListener(DLGuiStandardEvents.DragEvent.class, (s, e) -> {
            this.skipValueUpdate = true;
            if (this.quadArea.get().collision(e.localMouseOriginX(), e.localMouseOriginY())) {
                float relX = (float)((e.mouseX() - this.quadArea.get().x()) / this.quadArea.get().width());
                float relY = (float)((e.mouseY() - this.quadArea.get().y()) / this.quadArea.get().height());
                relX = MathUtils.clamp(relX, 0.0f, 1.0f);
                relY = MathUtils.clamp(relY, 0.0f, 1.0f);
                ((HSVSlots)this.hsvSlots.get()).quadX().set(this, relX);
                ((HSVSlots)this.hsvSlots.get()).quadY().set(this, 1.0f - relY);
                this.resetSliderTexture();
            } else if (this.colorSliderArea.get().collision(e.localMouseOriginX(), e.localMouseOriginY())) {
                float rel = 0.0f;
                rel = ((EAlign)this.sliderAlign.get()).isHorizontal() ? (float)((e.mouseY() - this.colorSliderArea.get().y()) / this.colorSliderArea.get().height()) : (float)((e.mouseX() - this.colorSliderArea.get().x()) / this.colorSliderArea.get().width());
                rel = MathUtils.clamp(rel, 0.0f, 1.0f);
                ((HSVSlots)this.hsvSlots.get()).slider().set(this, 1.0f - rel);
                this.resetQuadTexture();
            } else if (this.alphaSliderArea.get().collision(e.localMouseOriginX(), e.localMouseOriginY())) {
                float rel = 0.0f;
                rel = ((EAlign)this.sliderAlign.get()).isHorizontal() ? (float)((e.mouseY() - this.alphaSliderArea.get().y()) / this.alphaSliderArea.get().height()) : (float)((e.mouseX() - this.alphaSliderArea.get().x()) / this.alphaSliderArea.get().width());
                this.selectedAlpha = rel = MathUtils.clamp(rel, 0.0f, 1.0f);
                this.resetQuadTexture();
            }
            this.color.set(DLColor.fromHsv(this.selectedHue * 360.0f, this.selectedSaturation, this.selectedBrightness).withAlpha((int)(this.selectedAlpha * 255.0f)));
            this.skipValueUpdate = false;
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.MouseMoveEvent.class, (s, e) -> {
            if (this.quadArea.get().collision(e.mouseX(), e.mouseY()) || this.colorSliderArea.get().collision(e.mouseX(), e.mouseY()) || this.alphaSliderArea.get().collision(e.mouseX(), e.mouseY())) {
                this.cursor.set(CursorType.CROSSHAIR);
            } else {
                this.cursor.set(null);
            }
            return false;
        });
        this.addEventListener(ColorChangedEvent.class, (s, e) -> {
            if (this.skipValueUpdate) {
                return false;
            }
            this.selectedHue = this.color.get().getHue() / 360.0f;
            this.selectedBrightness = this.color.get().getBrightness();
            this.selectedSaturation = this.color.get().getSaturation();
            this.selectedAlpha = this.color.get().getAlphaF();
            this.updateScreenLayout();
            return false;
        });
    }

    @Override
    public Rectangle getRenderBounds() {
        Rectangle rect = super.getRenderBounds();
        return Rectangle.withPoints(rect.left() - 3.0, rect.top() - 3.0, rect.right() + 3.0, rect.bottom() + 3.0);
    }

    @Override
    public void updateScreenLayout() {
        this.resetQuadTexture();
        this.resetSliderTexture();
        this.quadArea.clear();
        this.colorSliderArea.clear();
        this.alphaSliderArea.clear();
    }

    private void resetQuadTexture() {
        if (this.quadTexture.isCached()) {
            this.quadTexture.get().close();
        }
        this.quadTexture.clear();
    }

    private void resetSliderTexture() {
        if (this.colorSliderTexture.isCached()) {
            this.colorSliderTexture.get().close();
        }
        this.colorSliderTexture.clear();
    }

    public int getQuadCursorX() {
        return (int)((double)((HSVSlots)this.hsvSlots.get()).quadX().get(this) * this.quadArea.get().width() + this.quadArea.get().x());
    }

    public int getQuadCursorY() {
        return (int)((double)(1.0f - ((HSVSlots)this.hsvSlots.get()).quadY().get(this)) * this.quadArea.get().height() + this.quadArea.get().y());
    }

    public int getColorSliderCursor() {
        if (((EAlign)this.sliderAlign.get()).isHorizontal()) {
            return (int)((double)(1.0f - ((HSVSlots)this.hsvSlots.get()).slider().get(this)) * this.colorSliderArea.get().height() + this.colorSliderArea.get().y());
        }
        return (int)((double)(1.0f - ((HSVSlots)this.hsvSlots.get()).slider().get(this)) * this.colorSliderArea.get().width() + this.colorSliderArea.get().x());
    }

    public int getAlphaSliderCursor() {
        if (((EAlign)this.sliderAlign.get()).isHorizontal()) {
            return (int)((double)this.selectedAlpha * this.alphaSliderArea.get().height() + this.alphaSliderArea.get().y());
        }
        return (int)((double)this.selectedAlpha * this.alphaSliderArea.get().width() + this.alphaSliderArea.get().x());
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        DefaultGuiTextures.DRAGONLIB_UI.getSprite("slot").render(graphics, (int)this.quadArea.get().x() - 1, (int)this.quadArea.get().y() - 1, (int)this.quadArea.get().width() + 2, (int)this.quadArea.get().height() + 2);
        int w = this.quadTexture.get().m_117991_().m_84982_();
        int h = this.quadTexture.get().m_117991_().m_85084_();
        GuiUtils.drawTexture(this.quadTexture.get().m_117963_(), graphics, (int)this.quadArea.get().x(), (int)this.quadArea.get().y(), w, h, 0, 0, w, h, GuiUtils.TextureFillMode.STRETCH, w, h);
        if (((Boolean)this.showColorSlider.get()).booleanValue()) {
            DefaultGuiTextures.DRAGONLIB_UI.getSprite("slot").render(graphics, (int)this.colorSliderArea.get().x() - 1, (int)this.colorSliderArea.get().y() - 1, (int)this.colorSliderArea.get().width() + 2, (int)this.colorSliderArea.get().height() + 2);
            w = this.colorSliderTexture.get().m_117991_().m_84982_();
            h = this.colorSliderTexture.get().m_117991_().m_85084_();
            GuiUtils.drawTexture(this.colorSliderTexture.get().m_117963_(), graphics, (int)this.colorSliderArea.get().x(), (int)this.colorSliderArea.get().y(), w, h, 0, 0, w, h, GuiUtils.TextureFillMode.STRETCH, w, h);
        }
        if (((Boolean)this.showAlphaSlider.get()).booleanValue()) {
            DefaultGuiTextures.DRAGONLIB_UI.getSprite("slot").render(graphics, (int)this.alphaSliderArea.get().x() - 1, (int)this.alphaSliderArea.get().y() - 1, (int)this.alphaSliderArea.get().width() + 2, (int)this.alphaSliderArea.get().height() + 2);
            DefaultGuiTextures.DRAGONLIB_UI.getSprite("transparency").render(graphics, (int)this.alphaSliderArea.get().x(), (int)this.alphaSliderArea.get().y(), (int)this.alphaSliderArea.get().width(), (int)this.alphaSliderArea.get().height());
            if (((EAlign)this.sliderAlign.get()).isHorizontal()) {
                GuiUtils.fillGradient(graphics, this.alphaSliderArea.get(), DLColor.TRANSPARENT, this.color.get().withAlpha(255), EAlign.TOP);
            } else {
                GuiUtils.fillGradient(graphics, this.alphaSliderArea.get(), DLColor.TRANSPARENT, this.color.get().withAlpha(255), EAlign.LEFT);
            }
        }
        GuiUtils.drawBox(graphics, this.getQuadCursorX() - 3, this.getQuadCursorY() - 3, 6, 6, this.color.get(), DLColor.pickBasedOnBrightness(this.color.get(), DLColor.WHITE, DLColor.BLACK, 0.5f));
        if (((EAlign)this.sliderAlign.get()).isHorizontal()) {
            if (((Boolean)this.showColorSlider.get()).booleanValue()) {
                GuiUtils.drawBox(graphics, (int)this.colorSliderArea.get().left() - 3, this.getColorSliderCursor() - 3, (int)this.colorSliderArea.get().width() + 6, 6, ((HSVSlots)this.hsvSlots.get()).slider().colorOf(this), DLColor.BLACK);
            }
            if (((Boolean)this.showAlphaSlider.get()).booleanValue()) {
                GuiUtils.drawBox(graphics, (int)this.alphaSliderArea.get().left() - 3, this.getAlphaSliderCursor() - 3, (int)this.alphaSliderArea.get().width() + 6, 6, this.color.get().withAlpha((int)(this.selectedAlpha * 255.0f)), DLColor.BLACK);
            }
        } else {
            if (((Boolean)this.showColorSlider.get()).booleanValue()) {
                GuiUtils.drawBox(graphics, this.getColorSliderCursor() - 3, (int)this.colorSliderArea.get().top() - 3, 6, (int)this.colorSliderArea.get().height() + 6, ((HSVSlots)this.hsvSlots.get()).slider().colorOf(this), DLColor.BLACK);
            }
            if (((Boolean)this.showAlphaSlider.get()).booleanValue()) {
                GuiUtils.drawBox(graphics, this.getAlphaSliderCursor() - 3, (int)this.alphaSliderArea.get().top() - 3, 6, (int)this.alphaSliderArea.get().height() + 6, this.color.get().withAlpha((int)(this.selectedAlpha * 255.0f)), DLColor.BLACK);
            }
        }
    }

    @Override
    public void renderFrontLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        if (this.isSelected() && ((Boolean)this.showAlphaSlider.get()).booleanValue() && this.alphaSliderArea.get().collision(mouseX, mouseY)) {
            GuiUtils.drawTooltip(graphics, graphics.defaultFont(), (int)mouseX, (int)mouseY, List.of(TextUtils.translate("gui.dragonlib.opacity").m_130946_(" " + (int)(100.0f * this.selectedAlpha) + "%")), (int)this.getWindowManager().getScreenWidth());
        }
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.resetSliderTexture();
        this.resetQuadTexture();
    }

    public record HSVSlots(HSVSlot quadX, HSVSlot quadY, HSVSlot slider) {
    }

    private static enum HSVSlot {
        H(instance -> Float.valueOf(instance.selectedHue), (instance, val) -> {
            instance.selectedHue = val.floatValue();
        }),
        S(instance -> Float.valueOf(instance.selectedSaturation), (instance, val) -> {
            instance.selectedSaturation = val.floatValue();
        }),
        V(instance -> Float.valueOf(instance.selectedBrightness), (instance, val) -> {
            instance.selectedBrightness = val.floatValue();
        });

        private final Function<DLColorPicker, Float> getter;
        private final BiConsumer<DLColorPicker, Float> setter;

        private HSVSlot(Function<DLColorPicker, Float> getter, BiConsumer<DLColorPicker, Float> setter) {
            this.getter = getter;
            this.setter = setter;
        }

        public float get(DLColorPicker instance) {
            return this.getter.apply(instance).floatValue();
        }

        public void set(DLColorPicker instance, float f) {
            this.setter.accept(instance, Float.valueOf(f));
        }

        public DLColor colorOf(DLColorPicker instance) {
            return HSVSlot.colorOf(instance, this, this.get(instance));
        }

        public static DLColor colorOf(DLColorPicker instance, HSVSlot channel, float f) {
            return switch (channel.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> DLColor.fromHsv(f * 360.0f, 1.0f, 1.0f);
                case 1 -> DLColor.fromHsv(instance.selectedHue * 360.0f, f, 1.0f);
                case 2 -> DLColor.fromHsv(instance.selectedHue * 360.0f, 0.0f, f);
            };
        }

        public static DLColor colorOf(Pair<HSVSlot, Float> a, Pair<HSVSlot, Float> b, Pair<HSVSlot, Float> c) {
            float h = 360.0f;
            float s = 1.0f;
            float v = 1.0f;
            switch (a.getFirst().ordinal()) {
                case 0: {
                    h = a.getSecond().floatValue() * 360.0f;
                    break;
                }
                case 1: {
                    s = a.getSecond().floatValue();
                    break;
                }
                case 2: {
                    v = a.getSecond().floatValue();
                }
            }
            switch (b.getFirst().ordinal()) {
                case 0: {
                    h = b.getSecond().floatValue() * 360.0f;
                    break;
                }
                case 1: {
                    s = b.getSecond().floatValue();
                    break;
                }
                case 2: {
                    v = b.getSecond().floatValue();
                }
            }
            switch (c.getFirst().ordinal()) {
                case 0: {
                    h = c.getSecond().floatValue() * 360.0f;
                    break;
                }
                case 1: {
                    s = c.getSecond().floatValue();
                    break;
                }
                case 2: {
                    v = c.getSecond().floatValue();
                }
            }
            return DLColor.fromHsv(h, s, v);
        }
    }

    public record ColorChangedEvent(DLColor color) implements IEvent
    {
    }
}

