/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.components;

import com.mojang.blaze3d.systems.RenderSystem;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLPopupWindow;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindow;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.ModalId;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLAbstractCollectionComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLCycleButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.IStateRenderer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.VanillaListScrollBarRenderer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.EAlign;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.ITextFormatter;
import de.mrjulsen.mcdragonlib.client.render.GuiIcons;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.MathUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.properties.NumberProperty;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class DLComboBox<T>
extends DLCycleButton<T> {
    public static final int DROP_DOWN_BUTTON_WIDTH = 14;
    public final Property<ITextFormatter<DLComboBox<T>>> textFormat = new Property<ITextFormatter<DLComboBox>>(src -> TextUtils.text(((Optional)src.selectedItem.get()).map(x -> x.toString()).orElse(((Component)this.text.get()).getString())).m_130948_(((Component)src.text.get()).m_7383_()));
    public final NumberProperty<Integer> shiftStep = new NumberProperty<Integer>(Integer.valueOf(5), 1, Integer.MAX_VALUE);
    public final Property<IComboBoxDropDownBuilder<T>> dropDownBuilder = new Property<IComboBoxDropDownBuilder<IComboBoxDropDownBuilder<T>>>((id, winWidth, winHeight) -> new DLComboBoxDropDownList(this, id, 0, 0, winWidth, winHeight));

    public DLComboBox(int x, int y, int w, int h) {
        super(x, y, w, h);
        this.addEventListener(DLGuiStandardEvents.ScrollEvent.class, (src, event) -> {
            this.changeValueOnScroll(-((int)Math.signum(event.deltaY())));
            return false;
        });
    }

    @Override
    public boolean defaultButtonClickAction(DLGuiComponent src, DLGuiStandardEvents.ClickEvent event) {
        ModalId id = this.getWindowManager().createModal(root -> {
            DLPopupWindow popup = new DLPopupWindow(root, (int)this.getXOnScreen(), (int)(this.getYOnScreen() + (double)this.height() * this.getGlobalScale()), this.width());
            return popup;
        });
        DLWindow win = this.getWindowManager().getWindows(id)[0];
        DLComboBoxDropDownList<DLAbstractCollectionComponent.ListLayoutChangedEvent> list = ((IComboBoxDropDownBuilder)this.dropDownBuilder.get()).build(id, win.width(), win.height());
        list.anchor.set(EAlign.values());
        win.addComponent(list);
        list.addEventListener(DLAbstractCollectionComponent.ListLayoutChangedEvent.class, (s, e) -> {
            win.setHeight(MathUtils.clamp((double)(2 + e.layoutResult().contentHeight()), 8.0, this.getWindowManager().getScreenHeight() / 3.0));
            win.setY(Math.min((double)(win.y() + win.height()), this.getWindowManager().getScreenHeight()) - (double)win.height());
            list.scrollBar.visible.set(e.layoutResult().causesOverflowY(list.contentPanel.height()));
            list.scrollBar.max.set(e.layoutResult().contentHeight());
            list.scrollBar.screenSize.set(list.contentPanel.height());
            return false;
        });
        list.items.addAll(this.items);
        return false;
    }

    public void changeValueOnScroll(int direction) {
        this.selectedIndex.set(MathUtils.clamp((Integer)this.selectedIndex.get() + direction * (DLWindowManager.hasShiftDown() ? (Integer)this.shiftStep.get() : 1), 0, this.items.size() - 1));
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        RenderSystem.enableBlend();
        DLWindowManager manager = this.getWindowManager();
        GuiUtils.setTint(this.backgroundTint.get());
        DLButton.ButtonState backgroundState = DLButton.ButtonState.DISABLED;
        if (this.isSelected()) {
            backgroundState = DLButton.ButtonState.DISABLED_SELECTED;
        }
        ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width() - 2, this.height(), this, backgroundState);
        DLButton.ButtonState state = DLButton.ButtonState.NORMAL;
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            state = DLButton.ButtonState.DISABLED;
        } else if (this.isMouseDown() && (manager == null || manager.getMouseDownButton() == 0)) {
            state = DLButton.ButtonState.DOWN_SELECTED;
        } else if (this.isSelected()) {
            state = DLButton.ButtonState.SELECTED;
        }
        ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, this.width() - 14, 0, 14, this.height(), this, state);
        GuiUtils.setTint(this.textColor.get());
        Font font = Minecraft.m_91087_().f_91062_;
        int n = this.height() / 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        GuiUtils.drawString(graphics, font, 4, n - 9 / 2, (FormattedText)((ITextFormatter)this.textFormat.get()).combine(this), (Boolean)this.enabled.get() != false ? DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR : DragonLib.VANILLA_BUTTON_DISABLED_FONT_COLOR, ETextAlignment.LEFT, false);
        GuiIcons.ARROW_DOWN.render(graphics, this.width() - 14 + 7 - 8 + (this.isMouseDown() ? 1 : 0), this.height() / 2 - 8 + (this.isMouseDown() ? 1 : 0));
        GuiUtils.resetTint();
    }

    public static interface IComboBoxDropDownBuilder<T> {
        public DLComboBoxDropDownList<T> build(ModalId var1, int var2, int var3);
    }

    public static class DLComboBoxDropDownList<T>
    extends DLAbstractCollectionComponent<T, DLComboboxDropDownItem<T>> {
        protected final DLComboBox<T> combobox;
        protected final ModalId id;
        protected final DLScrollBar scrollBar;
        protected int totalItemHeight = 0;

        public DLComboBoxDropDownList(DLComboBox<T> combobox, ModalId id, int x, int y, int w, int h) {
            super(x, y, w, h);
            this.id = id;
            this.combobox = combobox;
            this.scrollBar = new DLScrollBar(this.width() - 1 - 7, 1, 7, this.height() - 2, DLScrollBar.Orientation.VERTICAL);
            this.scrollBar.componentRenderer.set(VanillaListScrollBarRenderer.VANILLA_SCROLLBAR);
            this.scrollBar.inputConsumptionPolicy.set(type -> true);
            this.scrollBar.anchor.set2(new EAlign[]{EAlign.TOP, EAlign.BOTTOM, EAlign.RIGHT});
            this.addComponent(this.scrollBar);
            this.contentPanel.setPosition(1.0, 1.0);
            this.contentPanel.setSize(this.width() - 2, this.height() - 2);
            this.scrollBar.addEventListener(DLScrollBar.ValueChangedEvent.class, (src, event) -> {
                this.contentPanel.setScrollOffsetY((Double)this.scrollBar.value.get());
                return false;
            });
            this.addEventListener(DLGuiStandardEvents.ScrollEvent.class, this.scrollBar::invokeEvent);
        }

        @Override
        protected DLComboboxDropDownItem<T> defaultItemBuilder(T item) {
            boolean bl = ((Optional)this.combobox.selectedItem.get()).map(x -> x == item).orElse(false);
            int n = this.width();
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            return new DLComboboxDropDownItem<T>(this, item, bl, n, 9 + 2);
        }

        public final void closeMenu() {
            if (this.getWindowManager() == null) {
                return;
            }
            this.getWindowManager().closeModal(this.id);
        }

        @Override
        public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
            GuiUtils.fill(graphics, 0, 0, this.width(), this.height(), DLColor.fromInt(-10066330));
            GuiUtils.fill(graphics, 1, 1, this.width() - 2, this.height() - 2, DLColor.fromInt(-12303292));
        }

        public static class DLComboboxDropDownItem<T>
        extends DLAbstractCollectionComponent.DLCollectionItem<T, DLComboBoxDropDownList<T>> {
            protected final boolean selected;

            protected DLComboboxDropDownItem(DLComboBoxDropDownList<T> collectionComponentRef, T item, boolean selected, int w, int h) {
                super(collectionComponentRef, item, w, h);
                this.selected = selected;
                this.addEventListener(DLGuiStandardEvents.ClickEvent.class, (src, event) -> {
                    collectionComponentRef.combobox.selectedItem.set(Optional.ofNullable(item));
                    collectionComponentRef.closeMenu();
                    return false;
                });
            }

            @Override
            public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
                if (this.isSelected()) {
                    GuiUtils.fill(graphics, 0, 0, this.width(), this.height(), DLColor.fromInt(0x22FFFFFF));
                } else if (this.selected) {
                    GuiUtils.drawBox(graphics, Rectangle.withSize(0.0, 0.0, this.width(), this.height()), DLColor.TRANSPARENT, DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR);
                }
                Font font = Minecraft.m_91087_().f_91062_;
                int n = this.height() / 2;
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                GuiUtils.drawString(graphics, font, 4, n - 9 / 2, String.valueOf(this.item), DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR, ETextAlignment.LEFT, false);
            }
        }
    }
}

