/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.components;

import com.mojang.blaze3d.systems.RenderSystem;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.annotations.SupportsEvents;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.IStateRenderer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.ITextFormatter;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLSprite;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.events.IEvent;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.properties.BooleanProperty;
import de.mrjulsen.mcdragonlib.util.properties.ListProperty;
import de.mrjulsen.mcdragonlib.util.properties.NumberProperty;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

@SupportsEvents(value={SelectedItemChanged.class})
public class DLCycleButton<T>
extends DLButton {
    public final ListProperty<T> items = new ListProperty().withUpdateCallback((val, operation) -> this.updateSelectedItem(operation == ListProperty.ListOperation.ADD));
    public final NumberProperty<Integer> selectedIndex = new NumberProperty<Integer>(Integer.valueOf(-1), -1, Integer.MAX_VALUE);
    public final Property<Optional<T>> selectedItem = new Property<Optional<Optional<T>>>(Optional.empty());
    public final Property<ITextFormatter<DLCycleButton<T>>> textFormat = new Property<ITextFormatter<DLCycleButton>>(src -> TextUtils.text(((Component)src.text.get()).getString()).m_130946_(": ").m_130946_(((Optional)src.selectedItem.get()).map(x -> x.toString()).orElse("")).m_130948_(((Component)src.text.get()).m_7383_()));
    public final BooleanProperty cycling = new BooleanProperty(true);

    public DLCycleButton(int x, int y, int w, int h) {
        super(x, y, w, h);
        this.selectedIndex.withAfterPropertyChangedCallback((o, n) -> {
            if (!o.equals(n)) {
                Optional<Object> item = Optional.ofNullable(n >= this.items.size() || n < 0 ? null : (Object)this.items.get((int)n));
                this.selectedItem.set(item);
                this.invokeEvent(this, new SelectedItemChanged<Object>(item, (int)n));
            }
        });
        this.selectedItem.withAfterPropertyChangedCallback((o, n) -> {
            if (o.orElse(null) != n.orElse(null)) {
                this.selectedIndex.set(n.map(a -> this.items.indexOf(a)).orElse(-1));
            }
        });
    }

    @Override
    public boolean defaultButtonClickAction(DLGuiComponent src, DLGuiStandardEvents.ClickEvent event) {
        int targetIndex = (Integer)this.selectedIndex.get();
        targetIndex = Screen.m_96638_() ? --targetIndex : ++targetIndex;
        if (targetIndex < 0) {
            targetIndex = (Boolean)this.cycling.get() != false ? this.items.size() - 1 : 0;
        } else if (targetIndex >= this.items.size()) {
            targetIndex = (Boolean)this.cycling.get() != false ? 0 : this.items.size() - 1;
        }
        this.selectedIndex.set(targetIndex);
        return super.defaultButtonClickAction(src, event);
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        RenderSystem.enableBlend();
        DLWindowManager manager = this.getWindowManager();
        GuiUtils.setTint(this.backgroundTint.get());
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, DLButton.ButtonState.DISABLED);
        } else if (this.isMouseDown() && (manager == null || manager.getMouseDownButton() == 0)) {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, DLButton.ButtonState.DOWN_SELECTED);
        } else if (this.isSelected()) {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, DLButton.ButtonState.SELECTED);
        } else {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, DLButton.ButtonState.NORMAL);
        }
        DLSprite iconSprite = (DLSprite)this.icon.get();
        boolean hasIcon = iconSprite != null && !iconSprite.isEmpty();
        Component buttonText = ((ITextFormatter)this.textFormat.get()).combine(this);
        int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)buttonText);
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int textHeight = 9;
        int iconWidth = hasIcon ? iconSprite.getWidth() : 0;
        int iconHeight = hasIcon ? iconSprite.getHeight() : 0;
        int spacing = hasIcon && !buttonText.getString().isEmpty() ? 4 : 0;
        int centerY = this.height() / 2;
        int offset = this.isMouseDown() ? 1 : 0;
        int iconY = centerY - iconHeight / 2;
        int textY = centerY - textHeight / 2;
        int iconX = 0;
        int textX = 0;
        int buttonWidth = this.width();
        switch ((ETextAlignment)this.iconAlignment.get()) {
            case LEFT: {
                iconX = 4;
                int textStartX = iconX + iconWidth + spacing;
                switch ((ETextAlignment)this.textAlignment.get()) {
                    case LEFT: {
                        textX = Math.max(textStartX, 4);
                        break;
                    }
                    case CENTER: {
                        int centerTextX = buttonWidth / 2 - textWidth / 2;
                        textX = Math.max(centerTextX, textStartX);
                        break;
                    }
                    case RIGHT: {
                        textX = Math.max(buttonWidth - textWidth - 4, textStartX);
                    }
                }
                break;
            }
            case RIGHT: {
                iconX = buttonWidth - iconWidth - 4;
                int maxTextRight = iconX - spacing;
                switch ((ETextAlignment)this.textAlignment.get()) {
                    case LEFT: {
                        textX = 4;
                        break;
                    }
                    case CENTER: {
                        int centerTextX = buttonWidth / 2 - textWidth / 2;
                        textX = Math.min(centerTextX, maxTextRight - textWidth);
                        break;
                    }
                    case RIGHT: {
                        textX = Math.min(buttonWidth - textWidth - 4, maxTextRight - textWidth);
                    }
                }
                break;
            }
            case CENTER: {
                if (this.textAlignment.get() == ETextAlignment.CENTER) {
                    int startX;
                    int totalWidth = iconWidth + spacing + textWidth;
                    iconX = startX = (buttonWidth - totalWidth) / 2;
                    textX = iconX + iconWidth + spacing;
                    break;
                }
                switch ((ETextAlignment)this.textAlignment.get()) {
                    case LEFT: {
                        textX = 4;
                        break;
                    }
                    case CENTER: {
                        textX = buttonWidth / 2 - textWidth / 2;
                        break;
                    }
                    case RIGHT: {
                        textX = buttonWidth - textWidth - 4;
                    }
                }
                int centerIconX = buttonWidth / 2 - iconWidth / 2;
                if (textX < centerIconX + iconWidth && textX + textWidth > centerIconX) {
                    iconX = textX + textWidth + spacing;
                    if (iconX + iconWidth <= buttonWidth - 4 || (iconX = textX - iconWidth - spacing) >= 4) break;
                    iconX = centerIconX;
                    break;
                }
                iconX = centerIconX;
                break;
            }
            default: {
                iconX = 4;
                int textStartX = iconX + iconWidth + spacing;
                textX = Math.max(textStartX, 4);
            }
        }
        if (hasIcon) {
            iconSprite.render(graphics, iconX + offset, iconY + offset);
        }
        GuiUtils.setTint(this.textColor.get());
        GuiUtils.drawString(graphics, Minecraft.m_91087_().f_91062_, textX + offset, textY + offset, (FormattedText)buttonText, (Boolean)this.enabled.get() != false ? DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR : DragonLib.VANILLA_BUTTON_DISABLED_FONT_COLOR, ETextAlignment.LEFT, (boolean)((Boolean)this.drawFontShadow.get()));
        GuiUtils.resetTint();
    }

    protected void updateSelectedItem(boolean firstIfUnselected) {
        if (((Optional)this.selectedItem.get()).isPresent() && this.items.contains(((Optional)this.selectedItem.get()).get())) {
            this.selectedIndex.set(this.items.indexOf(((Optional)this.selectedItem.get()).get()));
        } else {
            this.selectedIndex.set(firstIfUnselected ? 0 : -1);
        }
    }

    public record SelectedItemChanged<T>(Optional<T> item, int index) implements IEvent
    {
    }
}

