/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.components;

import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.annotations.SupportsEvents;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLAbstractCollectionComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.layout.LayoutResult;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.VanillaListScrollBarRenderer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.EAlign;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.events.IEvent;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.properties.BooleanProperty;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import de.mrjulsen.mcdragonlib.util.properties.VirtualProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.FormattedText;
import org.apache.commons.lang3.mutable.MutableBoolean;

@SupportsEvents(value={ItemSelectionChangeEvent.class})
public class DLItemSelectionBox<T>
extends DLAbstractCollectionComponent<T, DLListBoxItem<T>> {
    private boolean loopFix = false;
    public final BooleanProperty multiselect = new BooleanProperty(false);
    public final VirtualProperty<List<T>> selectedItems = new VirtualProperty<List>(List.of(), () -> {
        ArrayList<Object> selectedItems = new ArrayList<Object>(this.contentPanel.getComponents().size());
        for (DLListBoxItem itm : this.contentPanel.getComponentsOfType(DLListBoxItem.class, true)) {
            if (!((Boolean)itm.selected.get()).booleanValue()) continue;
            selectedItems.add(itm.item);
        }
        return Collections.unmodifiableList(selectedItems);
    }, selectedItems -> {
        boolean prevLoop = this.loopFix;
        this.loopFix = true;
        try {
            for (DLListBoxItem itm : this.contentPanel.getComponentsOfType(DLListBoxItem.class, true)) {
                itm.selected.set(selectedItems.contains(itm.item));
            }
        }
        finally {
            this.loopFix = prevLoop;
        }
    });
    public final Property<Function<T, FormattedText>> textFormat = (Property)new Property<Function<Object, FormattedText>>(item -> TextUtils.text(String.valueOf(item))).withAfterPropertyChangedCallback((a, b) -> this.createComponents());
    protected final DLScrollBar scrollBar = new DLScrollBar(this.width() - 1 - 7, 1, 7, this.height() - 2, DLScrollBar.Orientation.VERTICAL);
    private DLAbstractCollectionComponent.DLCollectionItem<?, ?> previouslyClickedItem;

    public DLItemSelectionBox(int x, int y, int w, int h) {
        super(x, y, w, h);
        this.scrollBar.componentRenderer.set(VanillaListScrollBarRenderer.VANILLA_SCROLLBAR);
        this.scrollBar.inputConsumptionPolicy.set(type -> true);
        this.scrollBar.anchor.set2(new EAlign[]{EAlign.TOP, EAlign.BOTTOM, EAlign.RIGHT});
        this.addComponent(this.scrollBar);
        this.contentPanel.setPosition(1.0, 1.0);
        this.contentPanel.setSize(this.width() - 2 - this.scrollBar.width(), this.height() - 2);
        this.contentPanel.addEventListener(DLGuiStandardEvents.ComponentLayoutUpdatedEvent.class, (s, e) -> {
            this.layoutComponents(e.layoutResult());
            return false;
        });
        this.scrollBar.addEventListener(DLScrollBar.ValueChangedEvent.class, (src, event) -> {
            this.contentPanel.setScrollOffsetY((Double)this.scrollBar.value.get());
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.ScrollEvent.class, this.scrollBar::invokeEvent);
        this.addEventListener(DLGuiStandardEvents.KeyPressEvent.class, (src, event) -> {
            if (DLWindowManager.isSelectAll(event.keyCode())) {
                this.selectAll();
            }
            return false;
        });
        this.addEventListener(ItemSelectionChangeEvent.class, (src, event) -> {
            if (this.loopFix) {
                return false;
            }
            this.loopFix = true;
            try {
                this.defaultItemSelection((ItemSelectionChangeEvent)event);
            }
            finally {
                this.loopFix = false;
            }
            return false;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectAll() {
        boolean prevLoop = this.loopFix;
        this.loopFix = true;
        try {
            for (DLListBoxItem itm : this.contentPanel.getComponentsOfType(DLListBoxItem.class, true)) {
                itm.selected.set(true);
            }
        }
        finally {
            this.loopFix = prevLoop;
        }
    }

    protected void defaultItemSelection(ItemSelectionChangeEvent event) {
        DLListBoxItem<?> clickedItem = event.item();
        boolean ctrl = DLWindowManager.hasControlDown();
        boolean shift = DLWindowManager.hasShiftDown();
        List<DLListBoxItem> allItems = this.contentPanel.getComponentsOfType(DLListBoxItem.class, true).stream().map(x -> x).toList();
        if (!((Boolean)this.multiselect.get()).booleanValue()) {
            for (DLListBoxItem itm : allItems) {
                if (itm == clickedItem) continue;
                itm.selected.set(false);
            }
            event.selected().setValue(true);
        } else if (shift && this.previouslyClickedItem != null) {
            int idxA = Math.max(0, this.contentPanel.getComponents().indexOf(this.previouslyClickedItem));
            int idxB = Math.max(0, this.contentPanel.getComponents().indexOf(clickedItem));
            int start = Math.min(idxA, idxB);
            int end = Math.max(idxA, idxB);
            if (start < 0 || end < 0 || start >= this.contentPanel.getComponents().size() || end >= this.contentPanel.getComponents().size()) {
                for (DLListBoxItem itm : allItems) {
                    if (itm == clickedItem) continue;
                    itm.selected.set(false);
                }
                event.selected().setValue(true);
            } else {
                for (int i = start; i <= end; ++i) {
                    DLGuiComponent comp = this.contentPanel.getComponents().get(i);
                    if (!(comp instanceof DLListBoxItem)) continue;
                    DLListBoxItem itm = (DLListBoxItem)comp;
                    itm.selected.set(true);
                }
                event.selected().setValue(true);
            }
        } else if (ctrl) {
            event.selected().setValue((Boolean)clickedItem.selected.get() == false);
        } else {
            for (DLListBoxItem itm : allItems) {
                if (itm == clickedItem) continue;
                itm.selected.set(false);
            }
            event.selected().setValue(true);
        }
        this.previouslyClickedItem = clickedItem;
    }

    protected List<DLListBoxItem<T>> getSelectedComponent() {
        return this.contentPanel.getComponentsOfType(DLListBoxItem.class, true).stream().filter(x -> (Boolean)x.selected.get()).map(x -> x).toList();
    }

    @Override
    protected void createComponents() {
        super.createComponents();
        for (DLListBoxItem itm : this.contentPanel.getComponentsOfType(DLListBoxItem.class, true)) {
            itm.addEventListener(DLGuiStandardEvents.KeyPressEvent.class, this::invokeEvent);
        }
    }

    protected void layoutComponents(LayoutResult result) {
        this.scrollBar.visible.set(result.causesOverflowY(this.contentPanel.height()));
        this.scrollBar.max.set(result.contentHeight());
        this.scrollBar.screenSize.set(this.contentPanel.height());
    }

    @Override
    protected DLListBoxItem<T> defaultItemBuilder(T item) {
        return new DLListBoxItem<T>(this, item, this.width(), 16);
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        GuiUtils.drawBox(graphics, Rectangle.withSize(0.0, 0.0, this.width(), this.height()), DLColor.fromInt(0x66000000), DLColor.WHITE);
    }

    public record ItemSelectionChangeEvent(DLListBoxItem<?> item, MutableBoolean selected) implements IEvent
    {
    }

    public static class DLListBoxItem<T>
    extends DLAbstractCollectionComponent.DLCollectionItem<T, DLItemSelectionBox<T>> {
        public final BooleanProperty selected = (BooleanProperty)new BooleanProperty(false).withModificationCallback((o, n) -> {
            MutableBoolean sel = new MutableBoolean(n);
            ((DLItemSelectionBox)this.collectionComponentRef).invokeEvent(this.collectionComponentRef, new ItemSelectionChangeEvent(this, sel));
            return sel.getValue();
        });

        protected DLListBoxItem(DLItemSelectionBox<T> collectionComponentRef, T item, int w, int h) {
            super(collectionComponentRef, item, w, h);
            this.addEventListener(DLGuiStandardEvents.ClickEvent.class, (src, event) -> {
                this.selected.set(true);
                return false;
            });
        }

        @Override
        public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
            if (((Boolean)this.selected.get()).booleanValue()) {
                GuiUtils.fill(graphics, 0, 0, this.width(), this.height(), DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR);
                GuiUtils.fill(graphics, 1, 1, this.width() - 2, this.height() - 2, DLColor.BLACK);
            } else if (this.isSelected()) {
                GuiUtils.fill(graphics, 0, 0, this.width(), this.height(), DLColor.fromInt(0x22FFFFFF));
            }
            Font font = Minecraft.m_91087_().f_91062_;
            int n = this.height() / 2;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            GuiUtils.drawString(graphics, font, 4, n - 9 / 2, (FormattedText)((Function)((DLItemSelectionBox)this.collectionComponentRef).textFormat.get()).apply(this.item), (Boolean)this.selected.get() != false ? DragonLib.VANILLA_BUTTON_HIGHLIGHTED_FONT_COLOR : DragonLib.VANILLA_BUTTON_ACTIVE_FONT_COLOR, ETextAlignment.LEFT, false);
        }
    }
}

