/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.components;

import de.mrjulsen.mcdragonlib.annotations.SupportsEvents;
import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLRichTextEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.IStateRenderer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.VanillaSimpleButtonRenderer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.VanillaTextBoxRenderer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.DLAbstractRichTextInputField;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.Padding;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.RichTextComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.INumberFormatAdapter;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLSprite;
import de.mrjulsen.mcdragonlib.events.IEvent;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.properties.BooleanProperty;
import de.mrjulsen.mcdragonlib.util.properties.NumberProperty;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;

@SupportsEvents(value={ValueChangedEvent.class, ValueRangeChangedEvent.class})
public class DLNumberPicker
extends DLGuiComponent {
    private static final int BUTTON_WIDTH = 16;
    protected final DLRichTextEditBox textBox;
    protected final DLButton addBtn;
    protected final DLButton subBtn;
    public final BooleanProperty showButtons = new BooleanProperty(true);
    public final NumberProperty<Double> step = new NumberProperty<Double>(1.0);
    public final NumberProperty<Double> shiftStep = new NumberProperty<Double>(5.0);
    public final NumberProperty<Double> min = new NumberProperty<Double>(0.0);
    public final NumberProperty<Double> max = new NumberProperty<Double>(100.0);
    public final NumberProperty<Double> value = (NumberProperty)new NumberProperty<Supplier<Double>>((Supplier<Double>)0.0, () -> (Double)this.min.get(), () -> (Double)this.max.get()).withAfterPropertyChangedCallback((o, val) -> this.invokeEvent(this, new ValueChangedEvent((double)val)));
    public final Property<INumberFormatAdapter> format = new Property<INumberFormatAdapter.DecimalNumberFormat>(new INumberFormatAdapter.DecimalNumberFormat(0));
    public final Property<IStateRenderer<DLButton.ButtonState>> buttonsComponentRenderer = new Property<VanillaSimpleButtonRenderer>(VanillaSimpleButtonRenderer.VANILLA_BUTTON_GRAY);
    public final Property<IStateRenderer<DLRichTextEditBox.TextBoxState>> textboxComponentRenderer = new Property<VanillaTextBoxRenderer>(VanillaTextBoxRenderer.VANILLA_TEXTBOX);
    protected boolean valueUpdateLoopFix = false;

    public DLNumberPicker(int x, int y, int w, int h) {
        super(x, y, w, h);
        this.textBox = new DLRichTextEditBox(0, 0, this.width() - 16, this.height()){

            @Override
            public List<DLContextMenu.ItemEntry> buildContextMenuContents(int x, int y) {
                List<DLContextMenu.ItemEntry> entries = super.buildContextMenuContents(x, y);
                if (!((Boolean)this.readOnly.get()).booleanValue()) {
                    entries.add(DLContextMenu.ItemEntry.SEPARATOR);
                    entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.translate("gui.dragonlib.menu.increment"), DLSprite.empty(), (Double)DLNumberPicker.this.value.get() < (Double)DLNumberPicker.this.max.get(), () -> DLNumberPicker.this.addToValue(1.0), null));
                    entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.translate("gui.dragonlib.menu.decrement"), DLSprite.empty(), (Double)DLNumberPicker.this.value.get() > (Double)DLNumberPicker.this.min.get(), () -> DLNumberPicker.this.addToValue(-1.0), null));
                }
                return entries;
            }
        };
        this.textBox.multiline.set(false);
        this.textBox.contentPadding.set(new Padding(0, 2, 0, 2));
        this.textBox.decoratedPadding.set(new Padding(1));
        this.textBox.lineSpacing.set(2);
        this.textBox.componentRenderer.set((IStateRenderer)this.textboxComponentRenderer.get());
        this.textBox.cursorXOffset.set(1);
        this.textBox.acceptAndCancelKeysEnabled.set(true);
        this.textBox.inputConsumptionPolicy.set(type -> type != DLGuiComponent.ConsumptionType.SCROLL);
        this.addComponent(this.textBox);
        this.addBtn = new DLButton(this.width() - 16, 0, 16, this.height() / 2);
        this.addBtn.text.set((Component)TextUtils.text("+"));
        this.addBtn.componentRenderer.set((IStateRenderer)this.buttonsComponentRenderer.get());
        this.addBtn.addEventListener(DLGuiStandardEvents.MouseHoldDownEvent.class, (src, event) -> {
            this.addToValue(1.0);
            return true;
        });
        this.addBtn.inputConsumptionPolicy.set(type -> type != DLGuiComponent.ConsumptionType.SCROLL);
        this.addComponent(this.addBtn);
        this.subBtn = new DLButton(this.width() - 16, this.height() / 2, 16, this.height() / 2);
        this.subBtn.text.set((Component)TextUtils.text("-"));
        this.subBtn.componentRenderer.set((IStateRenderer)this.buttonsComponentRenderer.get());
        this.subBtn.addEventListener(DLGuiStandardEvents.MouseHoldDownEvent.class, (src, event) -> {
            this.addToValue(-1.0);
            return true;
        });
        this.subBtn.inputConsumptionPolicy.set(type -> type != DLGuiComponent.ConsumptionType.SCROLL);
        this.addComponent(this.subBtn);
        this.addEventListener(ValueChangedEvent.class, (src, event) -> {
            this.updateTextboxValue();
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.ScrollEvent.class, (src, event) -> {
            this.addToValue(Math.signum(event.deltaY()));
            this.updateTextboxValue();
            return false;
        });
        this.textBox.addEventListener(DLGuiStandardEvents.FocusChangedEvent.class, (src, event) -> {
            if (!event.focus()) {
                this.updateValueFromTextbox();
            }
            return false;
        });
        this.textBox.addEventListener(DLAbstractRichTextInputField.TextAcceptKeyPressedEvent.class, (src, event) -> {
            this.updateValueFromTextbox();
            return false;
        });
        this.textBox.addEventListener(DLAbstractRichTextInputField.TextCancelKeyPressedEvent.class, (src, event) -> {
            this.updateTextboxValue();
            return false;
        });
        this.updateTextboxValue();
        this.updateButtons();
        this.min.withAfterPropertyChangedCallback((o, val) -> this.invokeEvent(this, new ValueRangeChangedEvent((Double)this.min.get(), (Double)this.max.get())));
        this.max.withAfterPropertyChangedCallback((o, val) -> this.invokeEvent(this, new ValueRangeChangedEvent((Double)this.min.get(), (Double)this.max.get())));
        this.showButtons.withAfterPropertyChangedCallback((o, val) -> {
            this.updateButtons();
            if (val.booleanValue()) {
                this.textBox.setWidth(this.width() - 16);
            } else {
                this.textBox.setWidth(this.width());
            }
        });
        this.buttonsComponentRenderer.withAfterPropertyChangedCallback((o, val) -> {
            this.addBtn.componentRenderer.set((IStateRenderer<DLButton.ButtonState>)val);
            this.subBtn.componentRenderer.set((IStateRenderer<DLButton.ButtonState>)val);
        });
        this.textboxComponentRenderer.withAfterPropertyChangedCallback((o, val) -> this.textBox.componentRenderer.set((IStateRenderer<DLRichTextEditBox.TextBoxState>)val));
    }

    protected void addToValue(double fac) {
        this.value.set((Double)this.value.get() + (DLWindowManager.hasShiftDown() ? (Double)this.shiftStep.get() : (Double)this.step.get()) * fac);
    }

    protected void updateTextboxValue() {
        this.valueUpdateLoopFix = true;
        String formatted = ((INumberFormatAdapter)this.format.get()).format((Double)this.value.get());
        ((RichTextComponent)this.textBox.text.get()).set(formatted);
        this.valueUpdateLoopFix = false;
    }

    protected void updateValueFromTextbox() {
        String input = ((RichTextComponent)this.textBox.text.get()).getPlainText().trim();
        try {
            double parsed = ((INumberFormatAdapter)this.format.get()).parse(input);
            this.value.set(parsed);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.updateTextboxValue();
    }

    protected void updateButtons() {
        this.addBtn.visible.set((Boolean)this.showButtons.get());
        this.subBtn.visible.set((Boolean)this.showButtons.get());
        this.textBox.setWidth((Boolean)this.showButtons.get() != false ? (double)this.width() : (double)(this.width() - 16));
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        super.renderMainLayer(graphics, mouseX, mouseY, renderBounds);
    }

    public record ValueChangedEvent(double value) implements IEvent
    {
    }

    public record ValueRangeChangedEvent(double min, double max) implements IEvent
    {
    }
}

