/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.components;

import de.mrjulsen.mcdragonlib.annotations.SupportsEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLGuiComponent;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.events.IEvent;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.properties.ColorProperty;
import de.mrjulsen.mcdragonlib.util.properties.NumberProperty;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.util.function.Supplier;

@SupportsEvents(value={BackgroundColorChangedEvent.class, ValueChangedEvent.class, MaxValueChangedEvent.class, BarColorChanged.class, BorderColorChanged.class, StyleChanged.class})
public class DLProgressBar
extends DLGuiComponent {
    public final NumberProperty<Integer> indeterminateBarWidth = new NumberProperty<Integer>(20);
    public final NumberProperty<Integer> animationSpeed = new NumberProperty<Integer>(2);
    public final NumberProperty<Double> max = (NumberProperty)new NumberProperty<Double>(1.0).withAfterPropertyChangedCallback((o, val) -> this.invokeEvent(this, new MaxValueChangedEvent((double)val)));
    public final NumberProperty<Double> value = (NumberProperty)new NumberProperty<Supplier<Double>>((Supplier<Double>)0.0, () -> 0.0, () -> (Double)this.max.get()).withAfterPropertyChangedCallback((o, val) -> this.invokeEvent(this, new ValueChangedEvent((double)val)));
    public final ColorProperty color = (ColorProperty)new ColorProperty(DLColor.GREEN, DLColor.WHITE).withAfterPropertyChangedCallback((o, val) -> this.invokeEvent(this, new BarColorChanged((DLColor)val)));
    public final ColorProperty backgroundColor = (ColorProperty)new ColorProperty(DLColor.BLACK, DLColor.BLACK).withAfterPropertyChangedCallback((o, val) -> this.invokeEvent(this, new BackgroundColorChangedEvent((DLColor)val)));
    public final ColorProperty borderColor = (ColorProperty)new ColorProperty(DLColor.WHITE, DLColor.WHITE).withAfterPropertyChangedCallback((o, val) -> this.invokeEvent(this, new BorderColorChanged((DLColor)val)));
    public final Property<ProgressBarStyle> style = (Property)new Property<ProgressBarStyle>(ProgressBarStyle.CONTINUOUS).withAfterPropertyChangedCallback((o, val) -> this.invokeEvent(this, new StyleChanged((ProgressBarStyle)((Object)val))));
    private int animationOffset = 0;

    public DLProgressBar(int x, int y, int w, int h) {
        super(x, y, w, h);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.style.get() == ProgressBarStyle.INDETERMINATE) {
            this.animationOffset += ((Integer)this.animationSpeed.get()).intValue();
            int maxOffset = this.width() - 4;
            if (this.animationOffset > maxOffset) {
                this.animationOffset = -((Integer)this.indeterminateBarWidth.get()).intValue();
            }
        }
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        GuiUtils.fill(graphics, 0, 0, this.width(), this.height(), this.borderColor.get());
        GuiUtils.fill(graphics, 1, 1, this.width() - 2, this.height() - 2, this.backgroundColor.get());
        switch (((ProgressBarStyle)((Object)this.style.get())).ordinal()) {
            case 1: {
                int barAreaX = 2;
                int barAreaWidth = this.width() - 4;
                int rawX = barAreaX + this.animationOffset;
                int rawWidth = (Integer)this.indeterminateBarWidth.get();
                int visibleX = Math.max(rawX, barAreaX);
                int visibleEndX = Math.min(rawX + rawWidth, barAreaX + barAreaWidth);
                int visibleWidth = visibleEndX - visibleX;
                if (visibleWidth <= 0) break;
                GuiUtils.fill(graphics, visibleX, 2, visibleWidth, this.height() - 4, this.color.get());
                break;
            }
            default: {
                int fillWidth = (int)((double)(this.width() - 4) / (Double)this.max.get() * (Double)this.value.get());
                GuiUtils.fill(graphics, 2, 2, fillWidth, this.height() - 4, this.color.get());
            }
        }
        super.renderMainLayer(graphics, mouseX, mouseY, renderBounds);
    }

    public static enum ProgressBarStyle {
        CONTINUOUS,
        INDETERMINATE;

    }

    public record StyleChanged(ProgressBarStyle style) implements IEvent
    {
    }

    public record BorderColorChanged(DLColor color) implements IEvent
    {
    }

    public record BackgroundColorChangedEvent(DLColor color) implements IEvent
    {
    }

    public record BarColorChanged(DLColor color) implements IEvent
    {
    }

    public record ValueChangedEvent(double value) implements IEvent
    {
    }

    public record MaxValueChangedEvent(double max) implements IEvent
    {
    }
}

