/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.components;

import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLRichTextLabel;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.IStateRenderer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.render.VanillaTextBoxRenderer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.DLAbstractRichTextInputField;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.RichTextComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.autocomplete.DLAutocompleteWindow;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.autocomplete.IAutocompletionManager;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLSprite;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.properties.Property;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;

public class DLRichTextEditBox
extends DLAbstractRichTextInputField {
    public final Property<IStateRenderer<TextBoxState>> componentRenderer = new Property<VanillaTextBoxRenderer>(VanillaTextBoxRenderer.VANILLA_TEXTBOX);
    public final Property<IAutocompletionManager<?>> autocompleteManager = (Property)new Property<Object>(null).withAfterPropertyChangedCallback((o, n) -> this.closeAutocompleteWindow());
    protected DLAutocompleteWindow<?> autocompleteWindow;

    public DLRichTextEditBox(int x, int y, int w, int h) {
        super(x, y, w, h);
        this.setupAutocomplete();
    }

    protected void openAutocompleteWindow() {
        if (this.autocompleteManager.get() == null) {
            return;
        }
        IAutocompletionManager manager = (IAutocompletionManager)this.autocompleteManager.get();
        this.getWindowManager().createWindow(mgr -> {
            this.autocompleteWindow = manager.createWindow(mgr, this);
            this.autocompleteWindow.addEventListener(DLGuiStandardEvents.CloseEvent.class, (c, e) -> {
                this.autocompleteWindow = null;
                return false;
            });
            manager.configureWindow(this.autocompleteWindow, this);
            return this.autocompleteWindow;
        });
    }

    protected void closeAutocompleteWindow() {
        if (this.autocompleteWindow != null) {
            if (this.autocompleteManager.get() != null) {
                IAutocompletionManager manager = (IAutocompletionManager)this.autocompleteManager.get();
                manager.closeWindow(this.autocompleteWindow, this);
            }
            this.getWindowManager().closeWindow(this.autocompleteWindow);
        }
    }

    protected void setupAutocomplete() {
        this.addEventListener(DLRichTextLabel.TextChangedEvent.class, (s, e) -> {
            if (this.autocompleteWindow != null && this.autocompleteWindow.supressTextUpdate()) {
                return false;
            }
            if (e.text().getPlainText().isEmpty() || this.autocompleteManager.get() == null) {
                this.closeAutocompleteWindow();
            } else if (this.autocompleteWindow == null) {
                this.openAutocompleteWindow();
            }
            IAutocompletionManager manager = (IAutocompletionManager)this.autocompleteManager.get();
            if (this.autocompleteWindow != null) {
                manager.configureWindow(this.autocompleteWindow, this);
            }
            return false;
        });
        this.addEventListener(DLGuiStandardEvents.FocusChangedEvent.class, (s, e) -> {
            if (this.autocompleteManager.get() != null && e.focus() && this.autocompleteWindow == null) {
                this.openAutocompleteWindow();
            }
            return false;
        });
    }

    @Override
    public List<DLContextMenu.ItemEntry> buildContextMenuContents(int x, int y) {
        ArrayList<DLContextMenu.ItemEntry> entries = new ArrayList<DLContextMenu.ItemEntry>();
        if (!((Boolean)this.readOnly.get()).booleanValue()) {
            entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.translate("gui.dragonlib.menu.cut"), DLSprite.empty(), this.hasSelection(), () -> this.cutSelected(), null));
        }
        entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.translate("gui.dragonlib.menu.copy"), DLSprite.empty(), this.hasSelection(), () -> this.copySelected(), null));
        if (!((Boolean)this.readOnly.get()).booleanValue()) {
            entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.translate("gui.dragonlib.menu.paste"), DLSprite.empty(), true, () -> this.paste(), null));
        }
        if (!((Boolean)this.readOnly.get()).booleanValue()) {
            entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.translate("gui.dragonlib.menu.delete"), DLSprite.empty(), this.hasSelection(), () -> ((RichTextComponent)this.text.get()).clear(), null));
        }
        entries.add(DLContextMenu.ItemEntry.SEPARATOR);
        entries.add(new DLContextMenu.ItemEntry((Component)TextUtils.translate("gui.dragonlib.menu.select_all"), DLSprite.empty(), true, () -> this.selectAll(), null));
        return entries;
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, TextBoxState.DISABLED);
        } else if (this.isFocused()) {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, TextBoxState.FOCUSED);
        } else if (this.isSelected()) {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, TextBoxState.SELECTED);
        } else {
            ((IStateRenderer)this.componentRenderer.get()).renderSprite(graphics, 0, 0, this.width(), this.height(), this, TextBoxState.NORMAL);
        }
        super.renderMainLayer(graphics, mouseX, mouseY, renderBounds);
    }

    public static enum TextBoxState {
        NORMAL,
        SELECTED,
        FOCUSED,
        DISABLED;

    }
}

