/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.richtext;

import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.TextSegment;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.TextStyle;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.WidthProvider;
import java.util.Objects;
import java.util.function.Consumer;

public class LineSplitter
implements TextSegment.CharCallback {
    private final WidthProvider widthProvider;
    private final float maxWidth;
    public int offset;
    private final Consumer<LineBreak> onLineBreak;
    private float currentLineWidth = 0.0f;
    private float widthSinceLastBreak = 0.0f;
    private int lastSpaceGlobalIndex = -1;
    private float widthSinceLastSpace = 0.0f;
    private float scale = 1.0f;
    private float lineHeight = 1.0f;

    public LineSplitter(float maxWidth, int offset, WidthProvider widthProvider, Consumer<LineBreak> onLineBreak) {
        this.widthProvider = widthProvider;
        this.maxWidth = Math.max(maxWidth, 1.0f);
        this.offset = offset;
        this.onLineBreak = onLineBreak;
    }

    @Override
    public boolean accept(int index, TextStyle style, int c) {
        int globalIndex = index + this.offset;
        if (c == 10) {
            this.emitBreak(globalIndex);
            this.scale = Math.max(this.scale, style.scale());
            float f = style.scale();
            Objects.requireNonNull(style.font());
            this.lineHeight = Math.max(this.lineHeight, f * 9.0f);
            return true;
        }
        float glyphWidth = this.widthProvider.getWidth(style, c);
        this.currentLineWidth += glyphWidth;
        this.widthSinceLastBreak += glyphWidth;
        this.widthSinceLastSpace += glyphWidth;
        if (c == 32) {
            this.lastSpaceGlobalIndex = globalIndex;
            this.widthSinceLastSpace = 0.0f;
        }
        if (this.currentLineWidth > this.maxWidth) {
            if (this.lastSpaceGlobalIndex >= 0) {
                float nextLineWidth = this.widthSinceLastSpace;
                this.emitBreak(this.lastSpaceGlobalIndex);
                this.currentLineWidth = nextLineWidth;
                this.widthSinceLastBreak = nextLineWidth;
            } else {
                this.emitBreak(globalIndex);
                this.currentLineWidth = glyphWidth;
                this.widthSinceLastBreak = glyphWidth;
            }
        }
        this.scale = Math.max(this.scale, style.scale());
        float f = style.scale();
        Objects.requireNonNull(style.font());
        this.lineHeight = Math.max(this.lineHeight, f * 9.0f);
        return true;
    }

    private void emitBreak(int breakAt) {
        this.onLineBreak.accept(new LineBreak(breakAt, this.widthSinceLastBreak, this.scale, this.lineHeight));
        this.currentLineWidth = 0.0f;
        this.widthSinceLastBreak = 0.0f;
        this.lastSpaceGlobalIndex = -1;
        this.widthSinceLastSpace = 0.0f;
        this.scale = 1.0f;
        this.lineHeight = 1.0f;
    }

    public float highestScale() {
        return this.scale;
    }

    public float widthSinceLastBreak() {
        return this.widthSinceLastBreak;
    }

    public float lineHeight() {
        return this.lineHeight;
    }

    public record LineBreak(int breakIndex, float lineWidth, float scale, float lineHeight) {
    }
}

