/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.autocomplete;

import de.mrjulsen.mcdragonlib.client.gui.events.DLGuiStandardEvents;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindow;
import de.mrjulsen.mcdragonlib.client.gui.widgets.base.DLWindowManager;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLAbstractCollectionComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.components.DLRichTextEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.RichTextComponent;
import de.mrjulsen.mcdragonlib.client.gui.widgets.richtext.autocomplete.DLAutocompleteListBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.EAlign;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.events.EventListenerId;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.math.MathUtils;
import de.mrjulsen.mcdragonlib.util.math.Point;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import de.mrjulsen.mcdragonlib.util.properties.VirtualProperty;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.network.chat.FormattedText;

public class DLAutocompleteWindow<T>
extends DLWindow {
    private final DLAutocompleteListBox<T> listBox;
    private final DLRichTextEditBox parentComponent;
    boolean supressTextUpdate;
    private final EventListenerId keyEventId;
    private final EventListenerId focusEventId;
    public final VirtualProperty<Predicate<T>> filter;
    public final VirtualProperty<List<T>> suggestions;

    public DLAutocompleteWindow(DLWindowManager manager, DLRichTextEditBox parentComponent) {
        super(manager);
        this.parentComponent = parentComponent;
        Point pos = parentComponent.toScreenCoordinates();
        this.setPosition(pos.x(), pos.y() + (double)parentComponent.height() + 2.0);
        this.setSize(parentComponent.width(), 120.0);
        this.topLevel.set(true);
        this.listBox = this.addComponent(new DLAutocompleteListBox(this, parentComponent, 1, 1, this.width() - 2, this.height() - 2));
        this.listBox.anchor.set(EAlign.values());
        this.filter = new VirtualProperty<Predicate>(item -> true, () -> (Predicate)this.listBox.filter.get(), func -> this.listBox.filter.set(func));
        this.suggestions = (VirtualProperty)new VirtualProperty<List>(List.of(), () -> this.listBox.items.get(), items -> this.listBox.items.set(items)).withAfterPropertyChangedCallback((o, n) -> this.listBox.selectedItems.set(List.of(this.listBox.items.get().get(0))));
        this.listBox.addEventListener(DLAbstractCollectionComponent.FilterChangedEvent.class, (s, e) -> {
            this.listBox.selectFirst();
            return false;
        });
        this.keyEventId = parentComponent.addEventListener(DLGuiStandardEvents.KeyPressEvent.class, (s, e) -> {
            switch (e.keyCode()) {
                case 265: {
                    this.changeIndex(-1);
                    return true;
                }
                case 264: {
                    this.changeIndex(1);
                    return true;
                }
                case 257: 
                case 258: {
                    this.supressTextUpdate = true;
                    if (!((List)this.listBox.selectedItems.get()).isEmpty()) {
                        ((RichTextComponent)parentComponent.text.get()).set(((FormattedText)((Function)this.listBox.textFormat.get()).apply(((List)this.listBox.selectedItems.get()).get(0))).getString());
                    }
                    this.getWindowManager().closeWindow(this);
                    this.supressTextUpdate = false;
                    return true;
                }
            }
            return false;
        }, 100);
        this.focusEventId = parentComponent.addEventListener(DLGuiStandardEvents.FocusChangedEvent.class, (s, e) -> {
            if (this.getWindowManager().getFocusedWindow() != this && !e.focus()) {
                this.getWindowManager().closeWindow(this);
            }
            return false;
        });
        this.addEventListener(DLWindow.WindowFocusEvent.class, (src, e) -> {
            this.getWindowManager().invokeLater(() -> {
                if (!e.focus() && !parentComponent.isFocused()) {
                    this.getWindowManager().closeWindow(this);
                }
            });
            return false;
        });
    }

    private void changeIndex(int direction) {
        if (!((List)this.listBox.selectedItems.get()).isEmpty()) {
            int currentIndex = this.listBox.visibleCurrentIndex();
            int index = MathUtils.clamp(currentIndex + direction, 0, this.listBox.visibleItems.size() - 1);
            this.listBox.selectByVisibleIndex(index);
        }
    }

    @Override
    public void renderMainLayer(DLGuiGraphics graphics, double mouseX, double mouseY, Rectangle renderBounds) {
        GuiUtils.drawBox(graphics, 0, 0, this.width(), this.height(), DLColor.fromInt(-587202560), DLColor.fromInt(-2368549));
    }

    @Override
    public void close() throws Exception {
        this.parentComponent.removeEventListener(DLGuiStandardEvents.KeyPressEvent.class, this.keyEventId);
        this.parentComponent.removeEventListener(DLGuiStandardEvents.FocusChangedEvent.class, this.focusEventId);
        super.close();
    }

    public boolean supressTextUpdate() {
        return this.supressTextUpdate;
    }
}

