/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.model;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import de.mrjulsen.mcdragonlib.client.model.mesh.FaceVertex;
import de.mrjulsen.mcdragonlib.mixin.VertexFormatAccessor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class ModelUtils {
    private static final float UV_SUBSTEP_COUNT = 8.0f;
    public static final int STRIDE = DefaultVertexFormat.f_85811_.m_86017_();
    public static final int POSITION = ModelUtils.findOffset(DefaultVertexFormat.f_85804_);
    public static final int COLOR = ModelUtils.findOffset(DefaultVertexFormat.f_85805_);
    public static final int UV0 = ModelUtils.findOffset(DefaultVertexFormat.f_85806_);
    public static final int UV1 = ModelUtils.findOffset(DefaultVertexFormat.f_85807_);
    public static final int UV2 = ModelUtils.findOffset(DefaultVertexFormat.f_85808_);
    public static final int NORMAL = ModelUtils.findOffset(DefaultVertexFormat.f_85809_);

    private static int findOffset(VertexFormatElement element) {
        int index = DefaultVertexFormat.f_85811_.m_86023_().indexOf((Object)element);
        return index < 0 ? -1 : ((VertexFormatAccessor)DefaultVertexFormat.f_85811_).dragonlib$getOffsets().getInt(index) / 4;
    }

    public static void unpackPosition(int[] vertexData, float[] pos, int vert) {
        int offset = vert * STRIDE + POSITION;
        pos[0] = Float.intBitsToFloat(vertexData[offset]);
        pos[1] = Float.intBitsToFloat(vertexData[offset + 1]);
        pos[2] = Float.intBitsToFloat(vertexData[offset + 2]);
    }

    public static void unpackUV(int[] vertexData, float[] uv, int vert) {
        int offset = vert * STRIDE + UV0;
        uv[0] = Float.intBitsToFloat(vertexData[offset]);
        uv[1] = Float.intBitsToFloat(vertexData[offset + 1]);
    }

    public static void unpackNormals(int[] vertexData, float[] normal, int vert) {
        int offset = vert * STRIDE + NORMAL;
        int packedNormal = vertexData[offset];
        normal[0] = (float)((byte)(packedNormal & 0xFF)) / 127.0f;
        normal[1] = (float)((byte)(packedNormal >> 8 & 0xFF)) / 127.0f;
        normal[2] = (float)((byte)(packedNormal >> 16 & 0xFF)) / 127.0f;
    }

    public static void unpackColor(int[] vertexData, int[] color, int vert) {
        int offset = vert * STRIDE + COLOR;
        int packedColor = vertexData[offset];
        color[0] = packedColor & 0xFF;
        color[1] = packedColor >> 8 & 0xFF;
        color[2] = packedColor >> 16 & 0xFF;
        color[3] = packedColor >> 24 & 0xFF;
    }

    public static void unpackLight(int[] vertexData, int[] light, int vert) {
        int offset = vert * STRIDE + UV2;
        int packedLight = vertexData[offset];
        light[0] = LightTexture.m_109883_((int)packedLight);
        light[1] = LightTexture.m_109894_((int)packedLight);
    }

    public static void packPosition(float[] pos, int[] vertexData, int vert) {
        int offset = vert * STRIDE + POSITION;
        vertexData[offset] = Float.floatToRawIntBits(pos[0]);
        vertexData[offset + 1] = Float.floatToRawIntBits(pos[1]);
        vertexData[offset + 2] = Float.floatToRawIntBits(pos[2]);
    }

    public static void packUV(float[] uv, int[] vertexData, int vert) {
        int offset = vert * STRIDE + UV0;
        vertexData[offset] = Float.floatToRawIntBits(uv[0]);
        vertexData[offset + 1] = Float.floatToRawIntBits(uv[1]);
    }

    public static void packNormals(float[] normal, int[] vertexData, int vert) {
        int offset = vert * STRIDE + NORMAL;
        int packedNormal = vertexData[offset];
        vertexData[offset] = (byte)(normal[0] * 127.0f) & 0xFF | ((byte)(normal[1] * 127.0f) & 0xFF) << 8 | ((byte)(normal[2] * 127.0f) & 0xFF) << 16 | packedNormal & 0xFF000000;
    }

    public static void packColor(int[] color, int[] vertexData, int vert) {
        int offset = vert * STRIDE + COLOR;
        vertexData[offset] = color[0] & 0xFF | (color[1] & 0xFF) << 8 | (color[2] & 0xFF) << 16 | (color[3] & 0xFF) << 24;
    }

    public static void packLight(int[] light, int[] vertexData, int vert) {
        int offset = vert * STRIDE + UV2;
        vertexData[offset] = LightTexture.m_109885_((int)light[0], (int)light[1]);
    }

    @Deprecated(forRemoval=true)
    public static void fillNormal(BakedQuad quad) {
        int[] vertexData = quad.m_111303_();
        float[][] pos = new float[4][3];
        for (int vert = 0; vert < 4; ++vert) {
            ModelUtils.unpackPosition(vertexData, pos[vert], vert);
        }
        float[][] normal = new float[4][3];
        ModelUtils.fillNormal(pos, normal);
        for (int vert = 0; vert < 4; ++vert) {
            ModelUtils.packNormals(normal[vert], vertexData, vert);
        }
    }

    public static Direction fillNormal(float[][] pos, float[][] normal) {
        Vector3f v1 = new Vector3f(pos[3][0], pos[3][1], pos[3][2]);
        Vector3f t1 = new Vector3f(pos[1][0], pos[1][1], pos[1][2]);
        Vector3f v2 = new Vector3f(pos[2][0], pos[2][1], pos[2][2]);
        Vector3f t2 = new Vector3f(pos[0][0], pos[0][1], pos[0][2]);
        v1.sub((Vector3fc)t1);
        v2.sub((Vector3fc)t2);
        v2.cross((Vector3fc)v1);
        v2.normalize();
        for (int vert = 0; vert < 4; ++vert) {
            normal[vert][0] = v2.x;
            normal[vert][1] = v2.y;
            normal[vert][2] = v2.z;
        }
        return Direction.m_122372_((float)v2.x, (float)v2.y, (float)v2.z);
    }

    public static Vector3f fillNormal(FaceVertex[] vertices) {
        Vector3f v1 = new Vector3f((Vector3fc)vertices[3].getVertex().getPos());
        Vector3f t1 = new Vector3f((Vector3fc)vertices[1].getVertex().getPos());
        Vector3f v2 = new Vector3f((Vector3fc)vertices[2].getVertex().getPos());
        Vector3f t2 = new Vector3f((Vector3fc)vertices[0].getVertex().getPos());
        v1.sub((Vector3fc)t1);
        v2.sub((Vector3fc)t2);
        v2.cross((Vector3fc)v1);
        v2.normalize();
        for (int vert = 0; vert < 4; ++vert) {
            vertices[vert].getVertex().setNormal(new Vector3f(v2.x, v2.y, v2.z));
        }
        return v2;
    }

    @Deprecated(forRemoval=true)
    public static void remapUV(Direction quadDir, TextureAtlasSprite sprite, float coord1, float coord2, float coordTo, float[][] uv, int uv1, int uv2, int uvTo, boolean vAxis, boolean invert, boolean rotated, boolean mirrored) {
        ModelUtils.remapUV(quadDir, sprite, coord1, coord2, coordTo, uv, uv, uv1, uv2, uvTo, vAxis, invert, rotated, mirrored);
    }

    @Deprecated(forRemoval=true)
    public static void remapUV(Direction quadDir, TextureAtlasSprite sprite, float coord1, float coord2, float coordTo, float[][] uvSrc, float[][] uvDest, int uv1, int uv2, int uvTo, boolean vAxis, boolean invert, boolean rotated, boolean mirrored) {
        ModelUtils.remapUV(sprite, coord1, coord2, coordTo, uvSrc, uvDest, uv1, uv2, uvTo, vAxis, rotated);
    }

    public static boolean useDiscreteUVSteps() {
        return true;
    }

    public static void remapUV(TextureAtlasSprite sprite, float coord1, float coord2, float coordTo, float[][] uvSrc, float[][] uvDest, int uv1, int uv2, int uvTo, boolean vAxis, boolean rotated) {
        boolean invert;
        float coordMin = Math.min(coord1, coord2);
        float coordMax = Math.max(coord1, coord2);
        int uvIdx = rotated != vAxis ? 1 : 0;
        float uvAbs1 = uvSrc[uv1][uvIdx];
        float uvAbs2 = uvSrc[uv2][uvIdx];
        float uvAbsMin = Math.min(uvAbs1, uvAbs2);
        float uvAbsMax = Math.max(uvAbs1, uvAbs2);
        boolean bl = invert = (coord2 > coord1 ^ uvAbs2 > uvAbs1) != vAxis;
        if (coordTo == coordMin) {
            uvDest[uvTo][uvIdx] = invert ? uvAbsMax : uvAbsMin;
        } else if (coordTo == coordMax) {
            uvDest[uvTo][uvIdx] = invert ? uvAbsMin : uvAbsMax;
        } else if (ModelUtils.useDiscreteUVSteps()) {
            float uvRelMin = uvIdx == 0 ? sprite.m_174727_(uvAbsMin) : sprite.m_174741_(uvAbsMin);
            float uvRelMax = uvIdx == 0 ? sprite.m_174727_(uvAbsMax) : sprite.m_174741_(uvAbsMax);
            float mult = (coordTo - coordMin) / (coordMax - coordMin);
            if (invert) {
                mult = 1.0f - mult;
            }
            float uvRelTo = Mth.m_14179_((float)mult, (float)uvRelMin, (float)uvRelMax);
            uvRelTo = (float)Math.round(uvRelTo * 8.0f) / 8.0f;
            uvDest[uvTo][uvIdx] = uvIdx == 0 ? sprite.m_118367_((double)uvRelTo) : sprite.m_118393_((double)uvRelTo);
        } else {
            float mult = (coordTo - coordMin) / (coordMax - coordMin);
            if (invert) {
                mult = 1.0f - mult;
            }
            uvDest[uvTo][uvIdx] = Mth.m_14179_((float)mult, (float)uvAbsMin, (float)uvAbsMax);
        }
    }

    public static boolean isQuadRotated(float[][] uv) {
        return !(!Mth.m_14033_((float)uv[0][1], (float)uv[1][1]) && !Mth.m_14033_((float)uv[3][1], (float)uv[2][1]) || !Mth.m_14033_((float)uv[1][0], (float)uv[2][0]) && !Mth.m_14033_((float)uv[0][0], (float)uv[3][0]));
    }

    @Deprecated(forRemoval=true)
    public static boolean isQuadMirrored(float[][] uv) {
        boolean rotated = ModelUtils.isQuadRotated(uv);
        return ModelUtils.isQuadMirrored(uv, rotated);
    }

    public static boolean isQuadMirrored(float[][] uv, boolean rotated) {
        if (!rotated) {
            return uv[0][0] > uv[3][0] && uv[1][0] > uv[2][0] || uv[0][1] > uv[1][1] && uv[3][1] > uv[2][1];
        }
        return uv[0][0] > uv[1][0] && uv[3][0] > uv[2][0] || uv[0][1] < uv[3][1] && uv[1][1] < uv[2][1];
    }

    public static BakedQuad invertTintIndex(BakedQuad quad) {
        return new BakedQuad(quad.m_111303_(), ModelUtils.encodeSecondaryTintIndex(quad.m_111305_()), quad.m_111306_(), quad.m_173410_(), quad.m_111307_());
    }

    public static int encodeSecondaryTintIndex(int tintIndex) {
        return (tintIndex + 2) * -1;
    }

    public static int decodeSecondaryTintIndex(int tintIndex) {
        return tintIndex * -1 - 2;
    }

    public static <T> void copyAll(List<T> src, ArrayList<T> dest) {
        dest.ensureCapacity(dest.size() + src.size());
        for (int i = 0; i < src.size(); ++i) {
            dest.add(src.get(i));
        }
    }

    public static boolean isPositive(Direction dir) {
        return dir.m_122421_() == Direction.AxisDirection.POSITIVE;
    }

    public static boolean positionsIntersect(Vector3f a, Vector3f b, float threshold) {
        return (double)a.distanceSquared((Vector3fc)b) <= Math.pow(threshold, 2.0);
    }

    private ModelUtils() {
    }
}

