/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.model.mesh;

import de.mrjulsen.mcdragonlib.client.model.mesh.Edge;
import de.mrjulsen.mcdragonlib.client.model.mesh.Face;
import de.mrjulsen.mcdragonlib.client.model.mesh.FaceVertex;
import de.mrjulsen.mcdragonlib.client.model.mesh.Mesh;
import de.mrjulsen.mcdragonlib.client.model.mesh.Vertex;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;

public class BasicMesh
extends Mesh {
    public BasicMesh() {
        super(new ArrayList<Vertex>(), new ArrayList<Edge>(), new ArrayList<Face>());
    }

    public static BasicMesh fromBlock(BlockState state, RandomSource random) {
        BakedModel srcModel = Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(state);
        BasicMesh mesh = new BasicMesh();
        Direction[] directions = new Direction[Direction.values().length + 1];
        System.arraycopy(Direction.values(), 0, directions, 0, Direction.values().length);
        for (Direction side : directions) {
            for (BakedQuad quad : srcModel.m_213637_(state, side, random)) {
                mesh.addFace(new Face(quad, side));
            }
        }
        mesh.cleanUp(1.0E-4f, true, true, true);
        return mesh;
    }

    public static BasicMesh fromBakedModel(BlockState state, BakedModel srcModel, RandomSource random) {
        BasicMesh mesh = new BasicMesh();
        Direction[] directions = new Direction[Direction.values().length + 1];
        System.arraycopy(Direction.values(), 0, directions, 0, Direction.values().length);
        for (Direction side : directions) {
            for (BakedQuad quad : srcModel.m_213637_(state, side, random)) {
                mesh.addFace(new Face(quad, side));
            }
        }
        mesh.cleanUp(1.0E-4f, true, true, true);
        return mesh;
    }

    public void combine(boolean merge, Mesh ... meshes) {
        for (Mesh mesh : meshes) {
            if (mesh == this) {
                throw new IllegalArgumentException("Cannot combine Mesh with itself.");
            }
            for (Face face : mesh.getFaces()) {
                this.addFace(face);
            }
        }
        if (merge) {
            this.cleanUp(1.0E-4f, true, true, true);
        }
    }

    public void addFace(Face face) {
        this.faces.add(face);
        this.edges.addAll(face.getEdges());
        for (FaceVertex wrapper : face.getCorners()) {
            this.vertices.add(wrapper.getVertex());
        }
    }

    public void removeFace(Face face) {
        HashMap<Vertex, Vertex> replacements = new HashMap<Vertex, Vertex>(4);
        this.faces.remove(face);
        for (FaceVertex wrapper : face.getCorners()) {
            Vertex current = wrapper.getVertex();
            Vertex copy = current.copy();
            wrapper.updateVertex(copy);
            replacements.put(current, copy);
        }
        face.updateEdges(x -> x.copy(y -> BasicMesh.replaceFunc(replacements, y)));
    }

    public void swapTextures(ResourceLocation current, ResourceLocation newLocation) {
        for (Face face : this.faces) {
            ResourceLocation loc;
            if (face.getTextureLocation() == null || !(loc = face.getTextureLocation()).equals((Object)current)) continue;
            TextureAtlasSprite sprite = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(newLocation);
            face.setTexture(sprite);
        }
    }
}

