/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.model.mesh;

import de.mrjulsen.mcdragonlib.client.model.mesh.Edge;
import de.mrjulsen.mcdragonlib.client.model.mesh.Face;
import de.mrjulsen.mcdragonlib.client.model.mesh.FaceVertex;
import de.mrjulsen.mcdragonlib.client.model.mesh.Mesh;
import de.mrjulsen.mcdragonlib.client.model.mesh.Vertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.Direction;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CubeMesh
extends Mesh {
    public CubeMesh(Vector3f position) {
        this(position, new Vector3f(1.0f, 1.0f, 1.0f));
    }

    public CubeMesh(Vector3f position, Vector3f size) {
        super(new ArrayList<Vertex>(), new ArrayList<Edge>(), Arrays.asList(new Face[6]));
        for (int i = 0; i < Direction.values().length; ++i) {
            Direction side = Direction.m_122376_((int)i);
            Vector3f facePos = new Vector3f((float)side.m_122436_().m_123341_(), (float)side.m_122436_().m_123342_(), (float)side.m_122436_().m_123343_()).max((Vector3fc)new Vector3f());
            Face face = Face.createFace(side, facePos, 1.0f, 1.0f);
            this.setFace(side, face);
        }
        this.cleanUp();
        this.scale(size, new Vector3f());
        this.translate(position);
    }

    @Override
    protected void replaceFaces(List<Face> other) {
        for (int i = 0; i < other.size() && i < this.faces.size(); ++i) {
            this.faces.set(i, other.get(i));
        }
    }

    protected void setFace(Direction direction, Face face) {
        this.faces.set(direction.m_122411_(), face);
        this.edges.addAll(face.getEdges());
        for (FaceVertex wrapper : face.getCorners()) {
            this.vertices.add(wrapper.getVertex());
        }
    }

    public Face removeFace(Direction direction) {
        HashMap<Vertex, Vertex> replacements = new HashMap<Vertex, Vertex>(4);
        Face face = (Face)this.faces.get(direction.m_122411_());
        this.faces.set(direction.m_122411_(), null);
        for (FaceVertex wrapper : face.getCorners()) {
            Vertex current = wrapper.getVertex();
            Vertex copy = current.copy();
            wrapper.updateVertex(copy);
            replacements.put(current, copy);
        }
        face.updateEdges(x -> x.copy(y -> CubeMesh.replaceFunc(replacements, y)));
        return face;
    }

    public Face getFaceOnSide(Direction direction) {
        return (Face)this.faces.get(direction.m_122411_());
    }
}

