/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.model.mesh;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.mrjulsen.mcdragonlib.client.model.DLBlockModelRegistry;
import de.mrjulsen.mcdragonlib.client.model.IDynamicBakedModel;
import de.mrjulsen.mcdragonlib.client.model.ModelCacheKey;
import de.mrjulsen.mcdragonlib.client.model.ModelContext;
import de.mrjulsen.mcdragonlib.client.model.mesh.Face;
import de.mrjulsen.mcdragonlib.client.model.mesh.Mesh;
import de.mrjulsen.mcdragonlib.util.Cache;
import de.mrjulsen.mcdragonlib.util.DLColor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class DLModel {
    private final Map<ModelCacheKey, Map<DirectionKey, ListMultimap<RenderType, BakedQuad>>> cachedBlockQuads = Collections.synchronizedMap(new HashMap());
    private final Cache<List<RenderType>> renderTypesCache = new Cache<List>(() -> {
        HashSet<RenderType> types = new HashSet<RenderType>(RenderType.m_110506_().size());
        for (Map<DirectionKey, ListMultimap<RenderType, BakedQuad>> m : this.cachedBlockQuads.values()) {
            for (ListMultimap<RenderType, BakedQuad> k : m.values()) {
                for (RenderType t : k.keySet()) {
                    types.add(t);
                }
            }
        }
        return new ArrayList(types);
    });

    protected ModelCacheKey createCacheKey(BlockState state, RandomSource random, ModelContext contex) {
        return new ModelCacheKey(contex, state);
    }

    protected boolean invalidateCacheFor(ModelType type, BlockState state, RandomSource random, ModelContext context) {
        return false;
    }

    @Nullable
    public Boolean useAmbientOcclusion() {
        return null;
    }

    protected abstract Mesh getMesh(ModelType var1, BakedModel var2, BlockState var3, RandomSource var4, ModelContext var5);

    public final List<BakedQuad> getQuads(ModelType type, BakedModel originalModel, BlockState state, RandomSource random, RenderType renderType, Direction cullface, ModelContext context) {
        DirectionKey requestedCullfaceKey;
        Map quadsByCullface;
        ModelCacheKey key;
        boolean isItem = type == ModelType.ITEM;
        ModelCacheKey modelCacheKey = key = !isItem ? this.createCacheKey(state, random, context) : new ModelCacheKey(context, new Object[0]);
        if (this.invalidateCacheFor(type, state, random, context) && this.cachedBlockQuads.containsKey(key)) {
            this.cachedBlockQuads.remove(key);
        }
        if (!(quadsByCullface = this.cachedBlockQuads.computeIfAbsent(key, c -> {
            boolean clearRenderTypeCache = false;
            Mesh mesh = this.getMesh(type, originalModel, state, random, c.context());
            HashMap<DirectionKey, ListMultimap> map = new HashMap<DirectionKey, ListMultimap>(6);
            for (Face face : mesh.getFaces()) {
                DirectionKey cullfaceKey = DirectionKey.of(face.getCullface());
                ListMultimap mm = map.computeIfAbsent(cullfaceKey, x -> MultimapBuilder.ListMultimapBuilder.hashKeys((int)RenderType.m_110506_().size()).arrayListValues().build());
                if (!clearRenderTypeCache && !mm.containsKey((Object)face.getRenderType())) {
                    clearRenderTypeCache = true;
                }
                mm.putAll((Object)face.getRenderType(), face.build());
            }
            if (clearRenderTypeCache) {
                this.clearCaches();
            }
            return map;
        })).containsKey(requestedCullfaceKey = DirectionKey.of(cullface))) {
            return List.of();
        }
        ListMultimap quadsByRenderType = (ListMultimap)quadsByCullface.get(requestedCullfaceKey);
        if (isItem) {
            return new ArrayList<BakedQuad>(quadsByRenderType.values());
        }
        if (!quadsByRenderType.containsKey((Object)renderType)) {
            return List.of();
        }
        return quadsByRenderType.get((Object)renderType);
    }

    public final List<RenderType> getSupportedRenderTypes() {
        return this.cachedBlockQuads.isEmpty() ? RenderType.m_110506_() : this.renderTypesCache.get();
    }

    private final void clearCaches() {
        this.renderTypesCache.clear();
    }

    public static BakedModel getModel(BlockState state) {
        return Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(state);
    }

    public static boolean hasDynamicModel(BlockState state) {
        BakedModel model = DLModel.getModel(state);
        return model instanceof IDynamicBakedModel;
    }

    public static Optional<DLModel> of(BlockState state) {
        if (!DLModel.hasDynamicModel(state)) {
            return Optional.empty();
        }
        return Optional.ofNullable(((IDynamicBakedModel)DLModel.getModel(state)).getModel());
    }

    public static void renderModel(PoseStack.Pose pose, VertexConsumer consumer, @Nullable BlockState state, ModelContext context) {
        DLModel.of(state).ifPresent(x -> x.render(pose, consumer, state, context));
    }

    public static void renderModel(PoseStack.Pose pose, VertexConsumer consumer, ModelType type, @Nullable BlockState state, ModelContext context, DLColor color, int packedLight, int packedOverlay) {
        DLModel.of(state).ifPresent(x -> x.render(pose, consumer, type, state, context, color, packedLight, packedOverlay));
    }

    public void render(PoseStack.Pose pose, VertexConsumer consumer, @Nullable BlockState state, ModelContext context) {
        this.render(pose, consumer, ModelType.BLOCK, state, context, DLColor.WHITE, 0, 0);
    }

    public void render(PoseStack.Pose pose, VertexConsumer consumer, ModelType type, @Nullable BlockState state, ModelContext context, DLColor color, int packedLight, int packedOverlay) {
        RandomSource randomSource = RandomSource.m_216327_();
        long seed = 42L;
        for (RenderType renderType : this.getSupportedRenderTypes()) {
            for (Direction direction : Direction.values()) {
                randomSource.m_188584_(seed);
                DLModel.renderQuadList(pose, consumer, color, this.getQuads(type, DLBlockModelRegistry.getOriginalModel(state), state, randomSource, renderType, direction, context), packedLight, packedOverlay);
            }
            randomSource.m_188584_(seed);
            DLModel.renderQuadList(pose, consumer, color, this.getQuads(type, DLBlockModelRegistry.getOriginalModel(state), state, randomSource, renderType, null, context), packedLight, packedOverlay);
        }
    }

    private static void renderQuadList(PoseStack.Pose pose, VertexConsumer consumer, DLColor color, List<BakedQuad> quads, int packedLight, int packedOverlay) {
        for (BakedQuad bakedQuad : quads) {
            float b;
            float g;
            float r;
            if (bakedQuad.m_111304_()) {
                r = Mth.m_14036_((float)color.getRedF(), (float)0.0f, (float)1.0f);
                g = Mth.m_14036_((float)color.getGreenF(), (float)0.0f, (float)1.0f);
                b = Mth.m_14036_((float)color.getBlueF(), (float)0.0f, (float)1.0f);
            } else {
                r = 1.0f;
                g = 1.0f;
                b = 1.0f;
            }
            consumer.m_85987_(pose, bakedQuad, r, g, b, packedLight, packedOverlay);
        }
    }

    public static enum ModelType {
        BLOCK(false),
        ITEM(true);

        final boolean isItem;

        private ModelType(boolean b) {
            this.isItem = b;
        }

        public static ModelType isItem(boolean b) {
            return b ? ITEM : BLOCK;
        }
    }

    private static class DirectionKey {
        private static final HashMap<Direction, DirectionKey> keys = new HashMap(Direction.values().length + 1);

        private DirectionKey() {
        }

        public static DirectionKey of(Direction direction) {
            return keys.get(direction);
        }

        static {
            for (Direction dir : Direction.values()) {
                keys.put(dir, new DirectionKey());
            }
            keys.put(null, new DirectionKey());
        }
    }
}

