/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.model.mesh;

import de.mrjulsen.mcdragonlib.client.model.mesh.ITransformable;
import de.mrjulsen.mcdragonlib.client.model.mesh.IVertexElement;
import de.mrjulsen.mcdragonlib.client.model.mesh.Vertex;
import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import org.joml.Vector3fc;

public class Edge
implements ITransformable<Edge> {
    private final List<Vertex> vertices = Arrays.asList(new Vertex[2]);

    public Edge(Vertex a, Vertex b) {
        this.vertices.set(0, a);
        this.vertices.set(1, b);
    }

    @Override
    public List<? extends IVertexElement> getTransformableElements() {
        return this.vertices;
    }

    void updateVertices(UnaryOperator<Vertex> replaceFunc) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            this.vertices.set(i, (Vertex)replaceFunc.apply(this.vertices.get(i)));
        }
    }

    public Edge copy(UnaryOperator<Vertex> replaceFunc) {
        return new Edge((Vertex)replaceFunc.apply(this.getFirstVertex()), (Vertex)replaceFunc.apply(this.getSecondVertex()));
    }

    public Vertex getFirstVertex() {
        return this.vertices.get(0);
    }

    public Vertex getSecondVertex() {
        return this.vertices.get(1);
    }

    public float length() {
        return this.vertices.get(0).getPos().distance((Vector3fc)this.vertices.get(1).getPos());
    }
}

