/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.model.mesh;

import de.mrjulsen.mcdragonlib.client.model.mesh.IVertexElement;
import de.mrjulsen.mcdragonlib.client.model.mesh.Vertex;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector3f;

public class FaceVertex
implements IVertexElement {
    private Vertex vertex;
    private Vector2f uv;
    private Vector2i light;

    public FaceVertex(Vertex vertex, float[] uv, int[] light) {
        this.vertex = vertex;
        this.uv = new Vector2f(uv);
        this.light = new Vector2i(light);
    }

    @Override
    public Vector3f getPos() {
        return this.vertex.getPos();
    }

    public Vertex getVertex() {
        return this.vertex;
    }

    public Vector2f getUV() {
        return this.uv;
    }

    public float getU() {
        return this.getUV().x;
    }

    public float getV() {
        return this.getUV().y;
    }

    public float[] getUVAsArray() {
        return new float[]{this.getU(), this.getV()};
    }

    public Vector2i getLight() {
        return this.light;
    }

    public int[] getLightAsArray() {
        return new int[]{this.getLight().x, this.getLight().y};
    }

    public int getPackedLight() {
        return this.getLight().y << 16 | this.getLight().x & 0xFFFF;
    }

    public void updateVertex(Vertex vertex) {
        this.vertex = vertex;
    }

    public void setUV(Vector2f uv) {
        this.uv = uv;
    }

    public void setU(float u) {
        this.getUV().set(u, this.getV());
    }

    public void setV(float v) {
        this.getUV().set(this.getU(), v);
    }

    public void setLight(Vector2i light) {
        this.light = light;
    }

    public void setLight(int packedLight) {
        int lu = packedLight & 0xFFFF;
        int lv = packedLight >> 16 & 0xFFFF;
        this.setLight(new Vector2i(lu, lv));
    }
}

