/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.util;

import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLTexture;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;

public class DLSprite {
    private final DLTexture texture;
    private final ItemStack item;
    private final boolean itemDecorations;
    private final int width;
    private final int height;
    private final int u;
    private final int v;
    private final int uWidth;
    private final int vHeight;

    public DLSprite(DLTexture texture, int width, int height) {
        this(texture, width, height, 0, 0, width, height);
    }

    public DLSprite(DLTexture texture, int width, int height, int u, int v) {
        this(texture, width, height, u, v, width, height);
    }

    public DLSprite(DLTexture texture, int width, int height, int u, int v, int uWidth, int vHeight) {
        this(texture, null, false, width, height, u, v, uWidth, vHeight);
    }

    private DLSprite(DLTexture texture, ItemStack stack, boolean itemDecorations, int width, int height, int u, int v, int uWidth, int vHeight) {
        this.item = stack;
        this.texture = texture;
        this.itemDecorations = itemDecorations;
        this.width = width;
        this.height = height;
        this.u = u;
        this.v = v;
        this.uWidth = uWidth;
        this.vHeight = vHeight;
    }

    public DLSprite(ItemStack stack, int size, boolean decorated) {
        this(null, stack, decorated, size, size, 0, 0, size, size);
    }

    public static DLSprite empty() {
        return new DLSprite(null, null, false, 0, 0, 0, 0, 0, 0);
    }

    public Optional<DLTexture> getTexture() {
        return Optional.ofNullable(this.texture);
    }

    public Optional<ItemStack> getItem() {
        return Optional.ofNullable(this.item);
    }

    public boolean isItemDecorated() {
        return this.itemDecorations;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getU() {
        return this.u;
    }

    public int getV() {
        return this.v;
    }

    public int getUWidth() {
        return this.uWidth;
    }

    public int getVHeight() {
        return this.vHeight;
    }

    public boolean isEmpty() {
        return this.texture == null && this.item == null || this.width <= 0 && this.height <= 0;
    }

    public void render(DLGuiGraphics graphics, int x, int y) {
        if (this.isEmpty()) {
            return;
        }
        if (this.getTexture().isPresent()) {
            GuiUtils.drawTexture(this.texture, graphics, x, y, this.width, this.height, this.u, this.v, this.uWidth, this.vHeight, GuiUtils.TextureFillMode.STRETCH);
        } else if (this.getItem().isPresent()) {
            GuiUtils.renderItem(graphics, this.item, x, y, 0.0625f * (float)this.width, this.itemDecorations);
        }
    }
}

