/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.util;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import de.mrjulsen.mcdragonlib.client.gui.widgets.util.EAlign;
import de.mrjulsen.mcdragonlib.client.model.ModelContext;
import de.mrjulsen.mcdragonlib.client.model.mesh.BasicMesh;
import de.mrjulsen.mcdragonlib.client.model.mesh.DLModel;
import de.mrjulsen.mcdragonlib.client.model.mesh.Mesh;
import de.mrjulsen.mcdragonlib.client.util.DLGuiGraphics;
import de.mrjulsen.mcdragonlib.client.util.DLTexture;
import de.mrjulsen.mcdragonlib.data.ETextAlignment;
import de.mrjulsen.mcdragonlib.data.ITranslatableEnum;
import de.mrjulsen.mcdragonlib.util.DLColor;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.math.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class GuiUtils {
    public static double mouseXOnScreen() {
        return Minecraft.m_91087_().f_91067_.m_91589_() * (double)Minecraft.m_91087_().m_91268_().m_85445_() / (double)Minecraft.m_91087_().m_91268_().m_85443_();
    }

    public static double mouseYOnScreen() {
        return Minecraft.m_91087_().f_91067_.m_91594_() * (double)Minecraft.m_91087_().m_91268_().m_85446_() / (double)Minecraft.m_91087_().m_91268_().m_85444_();
    }

    public static double getScreenWidth() {
        return Minecraft.m_91087_().m_91268_().m_85445_();
    }

    public static double getScreenHeight() {
        return Minecraft.m_91087_().m_91268_().m_85446_();
    }

    public static void enableScissor(DLGuiGraphics graphics, Rectangle area) {
        GuiUtils.enableScissor(graphics, (int)area.x(), (int)area.y(), (int)area.width(), (int)area.height());
    }

    public static void enableScissor(DLGuiGraphics graphics, int x, int y, int w, int h) {
        int scale = (int)Minecraft.m_91087_().m_91268_().m_85449_();
        RenderSystem.enableScissor((int)(x * scale), (int)(Minecraft.m_91087_().m_91268_().m_85442_() - (y + h) * scale), (int)(w * scale), (int)(h * scale));
    }

    public static void disableScissor(DLGuiGraphics graphics) {
        RenderSystem.disableScissor();
    }

    public static void playButtonSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public static FormattedCharSequence toFormattedCharSequence(FormattedText text) {
        return text instanceof Component ? ((Component)text).m_7532_() : Language.m_128107_().m_5536_(text);
    }

    public static <T extends FormattedText> List<FormattedCharSequence> splitToFormattedCharSequences(Font font, Collection<T> components, int maxWidth) {
        ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>(components.size());
        for (FormattedText component : components) {
            lines.addAll(font.m_92923_(component, maxWidth));
        }
        return lines;
    }

    public static <T extends FormattedText> List<FormattedText> splitText(Font font, Collection<T> components, int maxWidth) {
        ArrayList<FormattedText> lines = new ArrayList<FormattedText>(components.size());
        for (FormattedText component : components) {
            lines.addAll(font.m_92865_().m_92414_(component, maxWidth, Style.f_131099_));
        }
        return lines;
    }

    public static void drawTooltip(DLGuiGraphics graphics, Font font, int x, int y, List<? extends FormattedText> lines, int maxWidth) {
        graphics.graphics().m_280245_(font, GuiUtils.splitToFormattedCharSequences(font, lines, maxWidth), x, y);
    }

    public static void drawTooltipDirectlyAt(DLGuiGraphics graphics, Font font, int x, int y, List<? extends FormattedText> lines, int maxWidth) {
        GuiUtils.drawTooltip(graphics, font, x - 8, y - 16, lines, maxWidth);
    }

    public static <T extends Enum<T>> List<Component> getEnumTooltipData(Class<T> enumClass, int maxWidth) {
        ArrayList<Component> c = new ArrayList<Component>();
        Enum enumValue = ((Enum[])enumClass.getEnumConstants())[0];
        c.add((Component)((ITranslatableEnum)((Object)enumValue)).getEnumDescriptionTranslation());
        c.add((Component)TextUtils.text(" "));
        for (Enum t : (Enum[])enumClass.getEnumConstants()) {
            c.add((Component)TextUtils.text("> ").m_130940_(ChatFormatting.BOLD).m_7220_((Component)((ITranslatableEnum)((Object)t)).getValueTranslation()).m_130940_(ChatFormatting.BOLD));
            c.add((Component)((ITranslatableEnum)((Object)t)).getValueDescriptionTranslation().m_130940_(ChatFormatting.GRAY));
        }
        return c;
    }

    public static void setTexture(ResourceLocation texture) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
    }

    public static void setTexture(int textureId) {
        RenderSystem.setShaderTexture((int)0, (int)textureId);
    }

    public static void setTint(DLColor color) {
        float a = color.getAlphaF();
        float r = color.getRedF();
        float g = color.getGreenF();
        float b = color.getBlueF();
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    public static void resetTint() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderTiledTexture(DLGuiGraphics graphics, Runnable bindTexture, int x, int y, int w, int h, float u, float v, float uW, float vH, int texWidth, int texHeight) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        bindTexture.run();
        float minU = u / (float)texWidth;
        float minV = v / (float)texHeight;
        float maxU = (u + uW) / (float)texWidth;
        float maxV = (v + vH) / (float)texHeight;
        float uSpan = maxU - minU;
        float vSpan = maxV - minV;
        Matrix4f matrix = graphics.poseStack().m_85850_().m_252922_();
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buffer = tess.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        int fullXTiles = w / (int)uW;
        int fullYTiles = h / (int)vH;
        float restX = (float)w % uW;
        float restY = (float)h % vH;
        float offsetY = 0.0f;
        for (int yTile = 0; yTile <= fullYTiles; ++yTile) {
            float tileHeight;
            float f = tileHeight = yTile < fullYTiles ? vH : restY;
            if (tileHeight <= 0.0f) break;
            float offsetX = 0.0f;
            for (int xTile = 0; xTile <= fullXTiles; ++xTile) {
                float tileWidth;
                float f2 = tileWidth = xTile < fullXTiles ? uW : restX;
                if (tileWidth <= 0.0f) break;
                float u0 = minU;
                float v0 = minV;
                float u1 = minU + uSpan * (tileWidth / uW);
                float v1 = minV + vSpan * (tileHeight / vH);
                float quadX0 = (float)x + offsetX;
                float quadY0 = (float)y + offsetY;
                float quadX1 = quadX0 + tileWidth;
                float quadY1 = quadY0 + tileHeight;
                buffer.m_252986_(matrix, quadX0, quadY1, 0.0f).m_7421_(u0, v1).m_5752_();
                buffer.m_252986_(matrix, quadX1, quadY1, 0.0f).m_7421_(u1, v1).m_5752_();
                buffer.m_252986_(matrix, quadX1, quadY0, 0.0f).m_7421_(u1, v0).m_5752_();
                buffer.m_252986_(matrix, quadX0, quadY0, 0.0f).m_7421_(u0, v0).m_5752_();
                offsetX += tileWidth;
            }
            offsetY += tileHeight;
        }
        tess.m_85914_();
    }

    public static void drawTexture(ResourceLocation texture, DLGuiGraphics graphics, int x, int y, int w, int h, int u, int v, int uW, int vH, TextureFillMode mode) {
        GuiUtils.drawTexture(texture, graphics, x, y, w, h, u, v, uW, vH, mode, 256, 256);
    }

    public static void drawTexture(ResourceLocation texture, DLGuiGraphics graphics, int x, int y, int w, int h, int u, int v, int uW, int vH, TextureFillMode mode, int textureWidth, int textureHeight) {
        switch (mode.ordinal()) {
            case 1: {
                GuiUtils.renderTiledTexture(graphics, () -> RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture), x, y, w, h, u, v, uW, vH, textureWidth, textureHeight);
                break;
            }
            default: {
                graphics.graphics().m_280411_(texture, x, y, w, h, (float)u, (float)v, uW, vH, textureWidth, textureHeight);
            }
        }
    }

    public static void drawTexture(int textureId, DLGuiGraphics graphics, int x, int y, int w, int h, int u, int v, int uW, int vH, TextureFillMode mode, int textureWidth, int textureHeight) {
        switch (mode.ordinal()) {
            case 1: {
                GuiUtils.renderTiledTexture(graphics, () -> RenderSystem.setShaderTexture((int)0, (int)textureId), x, y, w, h, u, v, uW, vH, textureWidth, textureHeight);
                break;
            }
            default: {
                GuiUtils.blit(graphics.graphics(), textureId, x, y, w, h, u, v, uW, vH, textureWidth, textureHeight);
            }
        }
    }

    public static void drawTexture(DLTexture texture, DLGuiGraphics graphics, int x, int y, int w, int h, int u, int v, int uW, int vH, TextureFillMode mode) {
        if (texture.usesTextureId() || texture.getTexture().isEmpty()) {
            GuiUtils.drawTexture(texture.getTextureId(), graphics, x, y, w, h, u, v, uW, vH, mode, texture.width(), texture.height());
        } else {
            GuiUtils.drawTexture(texture.getTexture().get(), graphics, x, y, w, h, u, v, uW, vH, mode, texture.width(), texture.height());
        }
    }

    public static void drawTexture(DLTexture texture, DLGuiGraphics graphics, int x, int y, int w, int h, int u, int v) {
        GuiUtils.drawTexture(texture, graphics, x, y, w, h, u, v, w, h, TextureFillMode.STRETCH);
    }

    public static void drawTexture(DLTexture texture, DLGuiGraphics graphics, int x, int y, int w, int h) {
        GuiUtils.drawTexture(texture, graphics, x, y, w, h, 0, 0, w, h, TextureFillMode.STRETCH);
    }

    private static void innerBlit(PoseStack pose, int textureId, int pX1, int pX2, int pY1, int pY2, int pBlitOffset, float pMinU, float pMaxU, float pMinV, float pMaxV) {
        RenderSystem.setShaderTexture((int)0, (int)textureId);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f matrix4f = pose.m_85850_().m_252922_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f, (float)pX1, (float)pY1, (float)pBlitOffset).m_7421_(pMinU, pMinV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)pX1, (float)pY2, (float)pBlitOffset).m_7421_(pMinU, pMaxV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)pX2, (float)pY2, (float)pBlitOffset).m_7421_(pMaxU, pMaxV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)pX2, (float)pY1, (float)pBlitOffset).m_7421_(pMaxU, pMinV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    private static void blit(GuiGraphics graphics, int textureId, int pX, int pY, int pWidth, int pHeight, float pUOffset, float pVOffset, int pUWidth, int pVHeight, int pTextureWidth, int pTextureHeight) {
        GuiUtils.blit(graphics, textureId, pX, pX + pWidth, pY, pY + pHeight, 0, pUWidth, pVHeight, pUOffset, pVOffset, pTextureWidth, pTextureHeight);
    }

    private static void blit(GuiGraphics graphics, int textureId, int pX1, int pX2, int pY1, int pY2, int pBlitOffset, int pUWidth, int pVHeight, float pUOffset, float pVOffset, int pTextureWidth, int pTextureHeight) {
        GuiUtils.innerBlit(graphics.m_280168_(), textureId, pX1, pX2, pY1, pY2, pBlitOffset, (pUOffset + 0.0f) / (float)pTextureWidth, (pUOffset + (float)pUWidth) / (float)pTextureWidth, (pVOffset + 0.0f) / (float)pTextureHeight, (pVOffset + (float)pVHeight) / (float)pTextureHeight);
    }

    public static void fill(DLGuiGraphics graphics, Rectangle area, DLColor color) {
        GuiUtils.fill(graphics, (int)area.x(), (int)area.y(), (int)area.width(), (int)area.height(), color);
    }

    public static void fill(DLGuiGraphics graphics, int x, int y, int w, int h, DLColor color) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        graphics.graphics().m_280509_(x, y, x + w, y + h, color.getAsARGB());
        RenderSystem.disableBlend();
    }

    public static void fillGradient(DLGuiGraphics graphics, Rectangle area, DLColor colorA, DLColor colorB, EAlign align) {
        GuiUtils.fillGradient(graphics, (int)area.x(), (int)area.y(), (int)area.width(), (int)area.height(), colorA, colorB, align);
    }

    public static void fillGradient(DLGuiGraphics graphics, int x, int y, int w, int h, DLColor colorA, DLColor colorB, EAlign align) {
        DLColor[] vertexColors = new DLColor[4];
        for (int i = 0; i < vertexColors.length; ++i) {
            vertexColors[(align.getOrder() + i) % vertexColors.length] = i < 2 ? colorA : colorB;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(graphics.poseStack().m_85850_().m_252922_(), (float)(x + w), (float)y, 0.0f).m_193479_(vertexColors[0].getAsARGB()).m_5752_();
        buffer.m_252986_(graphics.poseStack().m_85850_().m_252922_(), (float)x, (float)y, 0.0f).m_193479_(vertexColors[1].getAsARGB()).m_5752_();
        buffer.m_252986_(graphics.poseStack().m_85850_().m_252922_(), (float)x, (float)(y + h), 0.0f).m_193479_(vertexColors[2].getAsARGB()).m_5752_();
        buffer.m_252986_(graphics.poseStack().m_85850_().m_252922_(), (float)(x + w), (float)(y + h), 0.0f).m_193479_(vertexColors[3].getAsARGB()).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void drawBox(DLGuiGraphics graphics, Rectangle area, DLColor fillColor, DLColor borderColor) {
        GuiUtils.drawBox(graphics, (int)area.x(), (int)area.y(), (int)area.width(), (int)area.height(), fillColor, borderColor);
    }

    public static void drawBox(DLGuiGraphics graphics, int x, int y, int w, int h, DLColor fillColor, DLColor borderColor) {
        GuiUtils.fill(graphics, x, y, w, h, fillColor);
        GuiUtils.fill(graphics, x, y, w, 1, borderColor);
        GuiUtils.fill(graphics, x, y + h - 1, w, 1, borderColor);
        GuiUtils.fill(graphics, x, y + 1, 1, h - 2, borderColor);
        GuiUtils.fill(graphics, x + w - 1, y + 1, 1, h - 2, borderColor);
    }

    public static void drawString(DLGuiGraphics graphics, Font font, int x, int y, String text, DLColor color, ETextAlignment alignment, boolean dropShadow) {
        GuiUtils.drawString(graphics, font, x, y, (FormattedText)TextUtils.text(text), color, alignment, dropShadow);
    }

    public static void drawString(DLGuiGraphics graphics, Font font, int x, int y, FormattedText text, DLColor color, ETextAlignment alignment, boolean dropShadow) {
        int width = font.m_92852_(text);
        int offset = 0;
        switch (alignment) {
            default: {
                break;
            }
            case CENTER: {
                offset = -width / 2;
                break;
            }
            case RIGHT: {
                offset = -width;
            }
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        graphics.graphics().m_280649_(font, GuiUtils.toFormattedCharSequence(text), x + offset, y, color.getAsARGB(), dropShadow);
    }

    public static void renderItem(DLGuiGraphics graphics, ItemStack stack, int x, int y) {
        GuiUtils.renderItem(graphics, stack, x, y, 1.0f, true);
    }

    public static void renderItem(DLGuiGraphics graphics, ItemStack stack, int x, int y, float scale, boolean drawDecorations) {
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_252880_((float)x, (float)y, 0.0f);
        graphics.poseStack().m_85841_(scale, scale, 1.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        graphics.graphics().m_280480_(stack, 0, 0);
        if (drawDecorations) {
            graphics.graphics().m_280370_(Minecraft.m_91087_().f_91062_, stack, 0, 0);
        }
        graphics.poseStack().m_85849_();
    }

    public static void renderItemDecoration(DLGuiGraphics graphics, ItemStack stack, int x, int y, float scale, String text) {
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_252880_((float)x, (float)y, 0.0f);
        graphics.poseStack().m_85841_(scale, scale, 1.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        graphics.graphics().m_280302_(Minecraft.m_91087_().f_91062_, stack, 0, 0, text);
        graphics.poseStack().m_85849_();
    }

    public static void renderEntity(DLGuiGraphics graphics, int x, int y, LivingEntity entity) {
        GuiUtils.renderEntity(graphics, x, y, 1.0f, entity, 0xF000F0);
    }

    public static void renderEntity(DLGuiGraphics graphics, int x, int y, float scale, LivingEntity entity, int light) {
        GuiUtils.renderEntity(graphics, x, y, scale, entity, new Matrix4f(), new Quaternionf(), light);
    }

    public static void renderEntity(DLGuiGraphics graphics, int x, int y, float scale, LivingEntity entity, Matrix4f transformation, @Nullable Quaternionf cameraOrientation, int light) {
        float s = 16.0f * scale;
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85837_((double)x, (double)y, (double)(16.0f * (scale + 1.0f)));
        graphics.poseStack().m_252931_(new Matrix4f().scaling(s, s, -s));
        graphics.poseStack().m_252931_(transformation);
        Lighting.m_166384_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        if (cameraOrientation != null) {
            cameraOrientation.conjugate();
            entityRenderDispatcher.m_252923_(cameraOrientation);
        }
        entityRenderDispatcher.m_114468_(false);
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, graphics.poseStack(), (MultiBufferSource)graphics.graphics().m_280091_(), light));
        graphics.graphics().m_280262_();
        entityRenderDispatcher.m_114468_(true);
        graphics.poseStack().m_85849_();
        Lighting.m_84931_();
    }

    public static void renderEntityFollowingMouse(DLGuiGraphics graphics, int x, int y, LivingEntity entity) {
        GuiUtils.renderEntityFollowingMouse(graphics, x, y, 1.0f, entity);
    }

    public static void renderEntityFollowingMouse(DLGuiGraphics graphics, int x, int y, float scale, LivingEntity entity) {
        GuiUtils.renderEntityFollowingMouse(graphics, x, y, scale, (float)Minecraft.m_91087_().f_91067_.m_91589_(), (float)Minecraft.m_91087_().f_91067_.m_91594_(), entity, 0xF000F0);
    }

    public static void renderEntityFollowingMouse(DLGuiGraphics graphics, int x, int y, float scale, float screenMouseX, float screenMouseY, LivingEntity entity, int light) {
        Matrix4f transformation = graphics.poseStack().m_85850_().m_252922_();
        float aX = (float)Math.atan((transformation.m30() + (float)x - screenMouseX) / 40.0f);
        float aY = (float)Math.atan((transformation.m31() + (float)y - (screenMouseY + entity.m_20192_() * (16.0f * scale))) / 40.0f);
        GuiUtils.renderEntityFollowingAngle(graphics, x, y, scale, aX, aY, entity, light);
    }

    public static void renderEntityFollowingAngle(DLGuiGraphics graphics, int x, int y, float scale, float angleXComponent, float angleYComponent, LivingEntity entity, int light) {
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf1 = new Quaternionf().rotateX(angleYComponent * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf1);
        float f2 = entity.f_20883_;
        float f3 = entity.m_146908_();
        float f4 = entity.m_146909_();
        float f5 = entity.f_20886_;
        float f6 = entity.f_20885_;
        entity.f_20883_ = 180.0f + angleXComponent * 20.0f;
        entity.m_146922_(180.0f + angleXComponent * 40.0f);
        entity.m_146926_(-angleYComponent * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        Matrix4f matrix = new Matrix4f().rotate((Quaternionfc)quaternionf);
        GuiUtils.renderEntity(graphics, x, y, scale, entity, matrix, quaternionf1, light);
        entity.f_20883_ = f2;
        entity.m_146922_(f3);
        entity.m_146926_(f4);
        entity.f_20886_ = f5;
        entity.f_20885_ = f6;
    }

    public static void renderBlockState(DLGuiGraphics graphics, int x, int y, BlockState state, RenderType renderType) {
        GuiUtils.renderBlockState(graphics, x, y, 1.0f, state, renderType, new Matrix4f(), 0xF000F0);
    }

    public static void renderBlockState(DLGuiGraphics graphics, int x, int y, float scale, BlockState state, RenderType renderType, int light) {
        GuiUtils.renderBlockState(graphics, x, y, scale, state, renderType, new Matrix4f(), light);
    }

    public static void renderBlockState(DLGuiGraphics graphics, int x, int y, float scale, BlockState state, RenderType renderType, Matrix4f transformation, int light) {
        DLModel model = new DLModel(){

            @Override
            protected Mesh getMesh(DLModel.ModelType type, BakedModel originalModel, BlockState state, RandomSource random, ModelContext context) {
                BasicMesh mesh = BasicMesh.fromBlock(state, random);
                mesh.rotate(Axis.f_252403_.m_252977_(180.0f), new Vector3f(0.5f));
                return mesh;
            }
        };
        GuiUtils.renderModel(graphics, x, y, scale, model, state, renderType, transformation, light);
    }

    public static void renderModel(DLGuiGraphics graphics, int x, int y, DLModel model, BlockState state, RenderType renderType) {
        GuiUtils.renderModel(graphics, x, y, 1.0f, model, state, renderType, new Matrix4f(), 0xF000F0);
    }

    public static void renderModel(DLGuiGraphics graphics, int x, int y, float scale, DLModel model, BlockState state, RenderType renderType, int light) {
        GuiUtils.renderModel(graphics, x, y, scale, model, state, renderType, new Matrix4f(), light);
    }

    public static void renderModel(DLGuiGraphics graphics, int x, int y, float scale, DLModel model, BlockState state, RenderType renderType, Matrix4f transformation, int light) {
        float s = scale * 16.0f;
        Lighting.m_84930_();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        PoseStack stack = graphics.poseStack();
        stack.m_85836_();
        stack.m_85841_(1.0f, 1.0f, -1.0f);
        stack.m_85837_((double)x, (double)y, (double)(16.0f * (scale + 1.0f)));
        stack.m_252931_(new Matrix4f().scaling(s, s, s));
        stack.m_252931_(transformation);
        MultiBufferSource.BufferSource buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        model.render(graphics.poseStack().m_85850_(), buffersource.m_6299_(renderType), DLModel.ModelType.BLOCK, state, ModelContext.EMPTY, DLColor.WHITE, 0xF000F0, 0);
        buffersource.m_109911_();
        stack.m_85849_();
        Lighting.m_84931_();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
    }

    public static enum TextureFillMode {
        STRETCH,
        TILE;

    }
}

